/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;

public class StateSpaceMonitor {
    private final StateSpace stateSpace;
    private List<State> addedStates = new ArrayList<State>();
    private List<State> removedStates = new ArrayList<State>();
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            int featureId = event.getFeatureID(StateSpace.class);
            if (featureId == 2) {
                if (event.getEventType() == 3) {
                    StateSpaceMonitor.this.addedStates.add((State)event.getNewValue());
                } else if (event.getEventType() == 4) {
                    State removed = (State)event.getOldValue();
                    if (StateSpaceMonitor.this.addedStates.contains(removed)) {
                        StateSpaceMonitor.this.addedStates.remove(removed);
                    } else {
                        StateSpaceMonitor.this.removedStates.add(removed);
                    }
                }
            }
        }
    };

    public StateSpaceMonitor(StateSpace stateSpace) {
        this.stateSpace = stateSpace;
    }

    public void setActive(boolean active) {
        if (active && !this.stateSpace.eAdapters().contains((Object)this.adapter)) {
            this.stateSpace.eAdapters().add((Object)this.adapter);
        } else if (!active) {
            this.stateSpace.eAdapters().remove((Object)this.adapter);
        }
    }

    public void reset() {
        this.addedStates.clear();
        this.removedStates.clear();
    }

    public StateSpace getStateSpace() {
        return this.stateSpace;
    }

    public List<State> getAddedStates() {
        return this.addedStates;
    }

    public List<State> getRemovedStates() {
        return this.removedStates;
    }
}

