/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;

public class StateSpaceProperties {
    public static List<Node> getParameters(StateSpace stateSpace, Rule rule) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        String value = (String)stateSpace.getProperties().get((Object)StateSpaceProperties.getParametersKey(rule));
        if (value == null) {
            return nodes;
        }
        String[] names = value.split(",");
        int i = 0;
        while (i < names.length) {
            String name = names[i].trim();
            if (name.length() != 0) {
                Node node = StateSpaceProperties.findNodeByName(name, rule.getLhs());
                if (node == null) {
                    node = StateSpaceProperties.findNodeByName(name, rule.getRhs());
                }
                if (node != null) {
                    nodes.add(node);
                }
            }
            ++i;
        }
        return nodes;
    }

    public static void setParameters(StateSpace stateSpace, Rule rule, List<Node> nodes) {
        String value = "";
        int i = 0;
        while (i < nodes.size()) {
            String name = nodes.get(i).getName();
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("All parameter nodes must have a unique name");
            }
            value = String.valueOf(value) + name;
            if (i < nodes.size() - 1) {
                value = String.valueOf(value) + ",";
            }
            ++i;
        }
        stateSpace.getProperties().put((Object)StateSpaceProperties.getParametersKey(rule), (Object)value);
    }

    private static Node findNodeByName(String name, Graph graph) {
        for (Node node : graph.getNodes()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    public static double getRate(StateSpace stateSpace, Rule rule) {
        String value = (String)stateSpace.getProperties().get((Object)StateSpaceProperties.getRateKey(rule));
        if (value == null) {
            return -1.0;
        }
        try {
            NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
            Number number = format.parse(value);
            return number.doubleValue();
        }
        catch (ParseException parseException) {
            return -1.0;
        }
    }

    public static void setRate(StateSpace stateSpace, Rule rule, double rate) {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        stateSpace.getProperties().put((Object)StateSpaceProperties.getRateKey(rule), (Object)format.format(rate));
    }

    public static void initializeDefaultProperties(StateSpace stateSpace, Rule rule) {
        if (!stateSpace.getProperties().containsKey((Object)StateSpaceProperties.getRateKey(rule))) {
            StateSpaceProperties.setRate(stateSpace, rule, 1.0);
        }
        if (!stateSpace.getProperties().containsKey((Object)StateSpaceProperties.getParametersKey(rule))) {
            StateSpaceProperties.setParameters(stateSpace, rule, new ArrayList<Node>());
        }
    }

    private static String getRateKey(Rule rule) {
        return "rate" + StateSpaceProperties.capitalize(StateSpaceProperties.removeWhiteSpace(rule.getName()));
    }

    private static String getParametersKey(Rule rule) {
        return "params" + StateSpaceProperties.capitalize(StateSpaceProperties.removeWhiteSpace(rule.getName()));
    }

    private static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String first = string.substring(0, 1).toUpperCase();
        if (string.length() == 0) {
            return first;
        }
        return String.valueOf(first) + string.substring(1);
    }

    private static String removeWhiteSpace(String string) {
        string = string.replaceAll(" ", "_");
        string = string.replaceAll("\t", "_");
        string = string.replaceAll("\n", "_");
        return string;
    }
}

