/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;

public class EmfGraph {
    protected final Collection<EObject> eObjects = new LinkedHashSet<EObject>();
    protected final Collection<EPackage> ePackages = new HashSet<EPackage>();
    final Map<EClass, Collection<EObject>> domainMap = new HashMap<EClass, Collection<EObject>>();
    final Map<EClass, Collection<EClass>> inheritanceMap = new HashMap<EClass, Collection<EClass>>();
    final ECrossReferenceAdapter crossReferenceAdapter = new ECrossReferenceAdapter();

    public EmfGraph() {
    }

    public EmfGraph(EObject ... roots) {
        this();
        EObject[] eObjectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            EObject r = eObjectArray[n2];
            this.addRoot(r);
            ++n2;
        }
    }

    public boolean addEObject(EObject eObject) {
        return this.addEObjectToGraph(eObject);
    }

    public boolean removeEObject(EObject eObject) {
        return this.removeEObjectFromGraph(eObject);
    }

    public boolean addRoot(EObject root) {
        boolean collectionChanged = this.addEObjectToGraph(root);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            collectionChanged |= this.addEObjectToGraph((EObject)it.next());
        }
        return collectionChanged;
    }

    public boolean removeRoot(EObject root) {
        boolean collectionChanged = this.removeEObjectFromGraph(root);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            collectionChanged |= this.removeEObjectFromGraph((EObject)it.next());
        }
        return collectionChanged;
    }

    public Collection<EObject> getDomainForType(EClass type) {
        ArrayList<EObject> domain = new ArrayList<EObject>();
        Collection<EClass> inhMap = this.inheritanceMap.get(type);
        if (inhMap != null) {
            for (EClass child : inhMap) {
                domain.addAll(this.getDomain(child));
            }
        }
        return domain;
    }

    protected boolean addEObjectToGraph(EObject eObject) {
        boolean isNew = this.eObjects.add(eObject);
        if (isNew) {
            eObject.eAdapters().add((Object)this.crossReferenceAdapter);
            EClass type = eObject.eClass();
            EPackage ePackage = type.getEPackage();
            Collection<EObject> domain = this.domainMap.get(type);
            if (domain == null) {
                domain = new ArrayList<EObject>();
                this.domainMap.put(type, domain);
            }
            domain.add(eObject);
            this.addEPackage(ePackage);
        }
        return isNew;
    }

    protected boolean removeEObjectFromGraph(EObject eObject) {
        boolean wasRemoved = this.eObjects.remove(eObject);
        if (wasRemoved) {
            EClass type = eObject.eClass();
            Collection<EObject> domain = this.domainMap.get(type);
            domain.remove(eObject);
        }
        return wasRemoved;
    }

    protected boolean addEPackage(EPackage ePackage) {
        boolean isNew = this.ePackages.add(ePackage);
        if (isNew) {
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                EClass type = (EClass)classifier;
                this.addChildParentRelation(type, type);
                for (EClass parent : type.getEAllSuperTypes()) {
                    this.addChildParentRelation(type, parent);
                }
            }
        }
        return isNew;
    }

    protected void addChildParentRelation(EClass child, EClass parent) {
        Collection<EClass> children = this.inheritanceMap.get(parent);
        if (children == null) {
            children = new HashSet<EClass>();
            this.inheritanceMap.put(parent, children);
        }
        children.add(child);
    }

    protected Collection<EObject> getDomain(EClass type) {
        Collection<EObject> domain = this.domainMap.get(type);
        if (domain == null) {
            domain = new ArrayList<EObject>();
            this.domainMap.put(type, domain);
        }
        return domain;
    }

    public Collection<EObject> getRootObjects() {
        HashSet<EObject> rootObjects = new HashSet<EObject>();
        for (EObject eObject : this.geteObjects()) {
            if (eObject.eContainer() != null) continue;
            rootObjects.add(eObject);
        }
        return rootObjects;
    }

    public Collection<EObject> geteObjects() {
        return this.eObjects;
    }

    public ECrossReferenceAdapter getCrossReferenceAdapter() {
        return this.crossReferenceAdapter;
    }
}

