/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.testframework.Graphs;
import org.eclipse.emf.henshin.testframework.Tools;

public class GraphTransformations {
    public static void assertNumberOfObjectsIdentical(Rule r, EmfEngine engine) throws AssertionError {
        TransformationUnit tu = GraphTransformations.createTUFromRule(r);
        GraphTransformations.assertNumberOfObjectsIdentical(tu, engine);
    }

    public static void assertNumberOfObjectsIdentical(Rule r, EmfGraph graph) throws AssertionError {
        GraphTransformations.assertNumberOfObjectsIdentical(r, new EmfEngine(graph));
    }

    public static void assertNumberOfObjectsIdentical(TransformationUnit tu, EmfEngine engine) throws AssertionError {
        GraphTransformations.assertNumberOfObjectsIdentical(new UnitApplication((InterpreterEngine)engine, tu));
    }

    public static void assertNumberOfObjectsIdentical(UnitApplication ua) throws AssertionError {
        int[] sizes = Tools.getGraphSizes(ua);
        if (sizes[0] != sizes[1]) {
            throw new AssertionError((Object)("expected: Number of elements before and after execution of " + ua.getTransformationUnit().getName() + " identical. Values: <" + sizes[0] + "> -> <" + sizes[1] + ">"));
        }
    }

    public static void assertNumberOfObjectsChanged(Rule r, EmfGraph graph) throws AssertionError {
        GraphTransformations.assertNumberOfObjectsChanged(r, new EmfEngine(graph));
    }

    public static void assertNumberOfObjectsChanged(Rule r, EmfEngine engine) throws AssertionError {
        GraphTransformations.assertNumberOfObjectsChanged(GraphTransformations.createTUFromRule(r), engine);
    }

    public static void assertNumberOfObjectsChanged(TransformationUnit tu, EmfEngine engine) throws AssertionError {
        GraphTransformations.assertNumberOfObjectsChanged(new UnitApplication((InterpreterEngine)engine, tu));
    }

    public static void assertNumberOfObjectsChanged(UnitApplication ua) throws AssertionError {
        int[] sizes = GraphTransformations.getGraphSizes(ua);
        if (sizes[0] == sizes[1]) {
            throw new AssertionError((Object)("expected: Number of elements before and after execution of " + ua.getTransformationUnit().getName() + " different. Values: <" + sizes[0] + "> -> <" + sizes[1] + ">"));
        }
    }

    public static void assertGraphIsNotChanged(Rule r, EmfGraph graph, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertGraphIsNotChanged(GraphTransformations.createTUFromRule(r), new EmfEngine(graph), matchSimilarityThreshold);
    }

    public static void assertGraphIsNotChanged(Rule r, EmfEngine engine, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertGraphIsNotChanged(GraphTransformations.createTUFromRule(r), engine, matchSimilarityThreshold);
    }

    public static void assertGraphIsNotChanged(TransformationUnit tu, EmfEngine engine, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertGraphIsNotChanged(new UnitApplication((InterpreterEngine)engine, tu), matchSimilarityThreshold);
    }

    public static void assertGraphIsNotChanged(UnitApplication ua, double matchSimilarityThreshold) throws AssertionError {
        MatchModel matchM;
        if (((EmfEngine)ua.getInterpreterEngine()).getEmfGraph().getRootObjects().size() != 1) {
            throw new AssertionError((Object)"!!!! graphs with multiple root objects not supported yet.");
        }
        EmfGraph graph = ((EmfEngine)ua.getInterpreterEngine()).getEmfGraph();
        Collection rootObjects = graph.getRootObjects();
        EObject[] rootObjectArr = rootObjects.toArray(new EObject[1]);
        EObject rootCopy = EcoreUtil.copy((EObject)rootObjectArr[0]);
        EObject rootOrig = rootObjectArr[0];
        ua.execute();
        try {
            matchM = MatchService.doMatch((EObject)rootCopy, (EObject)rootOrig, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            if (ma.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)("Could not match graphs. Threshold exceeded: (" + ma.getSimilarity() + "), threshold " + matchSimilarityThreshold + ". Quite possibly, graph was changed."));
            }
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        if (diffM.getDifferences().size() != 0) {
            throw new AssertionError((Object)("expected: Graph is not changed, but " + diffM.getDifferences().size() + " changes occured."));
        }
    }

    public static void assertTransformsGraph(Rule r, EmfEngine engine, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsGraph(GraphTransformations.createTUFromRule(r), engine, graph2, matchSimilarityThreshold);
    }

    public static void assertTransformsGraph(Rule r, EmfGraph graph, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsGraph(GraphTransformations.createTUFromRule(r), graph, graph2, matchSimilarityThreshold);
    }

    public static void assertTransformsGraph(TransformationUnit tu, EmfGraph graph, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsGraph(tu, new EmfEngine(graph), graph2, matchSimilarityThreshold);
    }

    public static void assertTransformsGraph(TransformationUnit tu, EmfEngine engine, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsGraph(new UnitApplication((InterpreterEngine)engine, tu), graph2, matchSimilarityThreshold);
    }

    public static void assertTransformsGraph(UnitApplication ua, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        ua.execute();
        if (!GraphTransformations.graphsEqual(((EmfEngine)ua.getInterpreterEngine()).getEmfGraph(), graph2, matchSimilarityThreshold)) {
            Tools.printGraph(((EmfEngine)ua.getInterpreterEngine()).getEmfGraph());
            throw new AssertionError((Object)("expected: Execution of " + ua.getTransformationUnit().getName() + " transforms graph into specified graph, but doesn't."));
        }
    }

    public static void assertTransformsGraph(RuleApplication ra, EmfGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        ra.apply();
        if (!GraphTransformations.graphsEqual(((EmfEngine)ra.getInterpreterEngine()).getEmfGraph(), graph2, matchSimilarityThreshold)) {
            Tools.printGraph(((EmfEngine)ra.getInterpreterEngine()).getEmfGraph());
            throw new AssertionError((Object)("expected: Execution of " + ra.getRule().getName() + " transforms graph into specified graph, but doesn't."));
        }
    }

    public static void assertNObjectsDeleted(Rule r, EmfGraph graph, int n) throws AssertionError {
        GraphTransformations.assertNObjectsDeleted(r, new EmfEngine(graph), n);
    }

    public static void assertNObjectsDeleted(Rule r, EmfEngine engine, int n) throws AssertionError {
        GraphTransformations.assertNObjectsDeleted(GraphTransformations.createTUFromRule(r), engine, n);
    }

    public static void assertNObjectsDeleted(TransformationUnit tu, EmfGraph graph, int n) throws AssertionError {
        GraphTransformations.assertNObjectsDeleted(tu, new EmfEngine(graph), n);
    }

    public static void assertNObjectsDeleted(TransformationUnit tu, EmfEngine engine, int n) throws AssertionError {
        GraphTransformations.assertNObjectsDeleted(new UnitApplication((InterpreterEngine)engine, tu), n);
    }

    public static void assertNObjectsDeleted(UnitApplication ua, int n) throws AssertionError {
        MatchModel matchM;
        if (((EmfEngine)ua.getInterpreterEngine()).getEmfGraph().getRootObjects().size() != 1) {
            throw new AssertionError((Object)"!!!! graphs with multiple root objects not supported yet.");
        }
        EmfGraph graph = ((EmfEngine)ua.getInterpreterEngine()).getEmfGraph();
        Collection rootObjects = graph.getRootObjects();
        EObject[] rootObjectArr = rootObjects.toArray(new EObject[1]);
        EObject rootCopy = EcoreUtil.copy((EObject)rootObjectArr[0]);
        EObject rootOrig = rootObjectArr[0];
        ua.execute();
        try {
            matchM = MatchService.doMatch((EObject)rootOrig, (EObject)rootCopy, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        int dcount = 0;
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        for (DiffElement di : diffM.getDifferences()) {
            if (!di.getKind().equals((Object)DifferenceKind.DELETION)) continue;
            ++dcount;
        }
        if (dcount != n) {
            throw new AssertionError((Object)("expected: <" + n + "> elements deleted, but <" + dcount + "> elements were deleted."));
        }
    }

    public static void assertNObjectsCreated(Rule r, EmfGraph graph, int n) throws AssertionError {
        GraphTransformations.assertNObjectsCreated(r, new EmfEngine(graph), n);
    }

    public static void assertNObjectsCreated(Rule r, EmfEngine engine, int n) throws AssertionError {
        GraphTransformations.assertNObjectsCreated(GraphTransformations.createTUFromRule(r), engine, n);
    }

    public static void assertNObjectsCreated(TransformationUnit tu, EmfGraph graph, int n) throws AssertionError {
        GraphTransformations.assertNObjectsCreated(tu, new EmfEngine(graph), n);
    }

    public static void assertNObjectsCreated(TransformationUnit tu, EmfEngine engine, int n) throws AssertionError {
        GraphTransformations.assertNObjectsCreated(new UnitApplication((InterpreterEngine)engine, tu), n);
    }

    public static void assertNObjectsCreated(UnitApplication ua, int n) throws AssertionError {
        MatchModel matchM;
        if (((EmfEngine)ua.getInterpreterEngine()).getEmfGraph().getRootObjects().size() != 1) {
            throw new AssertionError((Object)"!!!! graphs with multiple root objects not supported yet.");
        }
        EmfGraph graph = ((EmfEngine)ua.getInterpreterEngine()).getEmfGraph();
        Collection rootObjects = graph.getRootObjects();
        EObject[] rootObjectArr = rootObjects.toArray(new EObject[1]);
        EObject rootCopy = EcoreUtil.copy((EObject)rootObjectArr[0]);
        EObject rootOrig = rootObjectArr[0];
        ua.execute();
        try {
            matchM = MatchService.doMatch((EObject)rootOrig, (EObject)rootCopy, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        int ccount = 0;
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        for (DiffElement di : diffM.getDifferences()) {
            if (!di.getKind().equals((Object)DifferenceKind.ADDITION)) continue;
            ++ccount;
        }
        if (ccount != n) {
            throw new AssertionError((Object)("expected: <" + n + "> elements created, but <" + ccount + "> elements were created."));
        }
    }

    public static void assertTransformsSubgraph(Rule r, EmfGraph graph, EmfGraph subgraphBefore, EmfGraph subgraphAfter, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsSubgraph(GraphTransformations.createTUFromRule(r), graph, subgraphBefore, subgraphAfter, ignoreChanges, matchSimilarityThreshold);
    }

    public static void assertTransformsSubgraph(Rule r, EmfEngine engine, EmfGraph subgraphBefore, EmfGraph subgraphAfter, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsSubgraph(GraphTransformations.createTUFromRule(r), engine, subgraphBefore, subgraphAfter, ignoreChanges, matchSimilarityThreshold);
    }

    public static void assertTransformsSubgraph(TransformationUnit tu, EmfGraph graph, EmfGraph subgraphBefore, EmfGraph subgraphAfter, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsSubgraph(tu, new EmfEngine(graph), subgraphBefore, subgraphAfter, ignoreChanges, matchSimilarityThreshold);
    }

    public static void assertTransformsSubgraph(TransformationUnit tu, EmfEngine engine, EmfGraph subgraphBefore, EmfGraph subgraphAfter, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        GraphTransformations.assertTransformsSubgraph(new UnitApplication((InterpreterEngine)engine, tu), subgraphBefore, subgraphAfter, ignoreChanges, matchSimilarityThreshold);
    }

    public static void assertTransformsSubgraph(UnitApplication ua, EmfGraph subgraphBefore, EmfGraph subgraphAfter, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        MatchModel match2M;
        MatchModel matchM;
        EmfGraph mainGraph = ((EmfEngine)ua.getInterpreterEngine()).getEmfGraph();
        HashMap<String, Boolean> matchOptions = new HashMap<String, Boolean>();
        matchOptions.put("IGNORE_ID", true);
        matchOptions.put("IGNORE_XMI_ID", true);
        try {
            matchM = MatchService.doMatch((EObject)GraphTransformations.getGraphRoot(subgraphBefore), (EObject)GraphTransformations.getGraphRoot(mainGraph), matchOptions);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"interrupted.");
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            System.out.println(ma);
            if (ma.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but graph can't be matched to subgraphBefore");
            }
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM, (boolean)true);
        for (DiffElement di : diffM.getDifferences()) {
            System.out.println(di);
        }
        if (!ua.execute()) {
            throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but execution of UnitApplication failed.");
        }
        try {
            match2M = MatchService.doMatch((EObject)GraphTransformations.getGraphRoot(subgraphAfter), (EObject)GraphTransformations.getGraphRoot(mainGraph), null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"interrupted.");
        }
        for (MatchElement me : match2M.getMatchedElements()) {
            if (me.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but subgraphAfter could not be matched.");
            }
        }
        DiffModel diff2M = DiffService.doDiff((MatchModel)match2M);
        for (DiffElement di : diff2M.getDifferences()) {
            if (di.getKind().equals((Object)DifferenceKind.ADDITION)) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but subgraphAfter contains elements not contained in UnitApplication's graph.");
            }
            if (!ignoreChanges && di.getKind().equals((Object)DifferenceKind.CHANGE)) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but subgraphAfter contains elements with differing values from matched elements contained in UnitApplication's graph.");
            }
        }
    }

    private static TransformationUnit createTUFromRule(Rule r) {
        return Tools.createTUFromRule(r);
    }

    private static int[] getGraphSizes(UnitApplication ua) {
        return Tools.getGraphSizes(ua);
    }

    private static boolean graphsEqual(EmfGraph graph1, EmfGraph graph2, double matchSimilarityThreshold) {
        return Graphs.graphsEqual(graph1, graph2, matchSimilarityThreshold);
    }

    private static EObject getGraphRoot(EmfGraph graph) {
        return Tools.getGraphRoot(graph);
    }
}

