/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.prism.AbstractPRISMTool;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class PRISMSteadyStateTool
extends AbstractPRISMTool {
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String line;
        monitor.beginTask("Computing steady-state probabilities...", -1);
        monitor.subTask("Invoking PRISM...");
        Process process = this.invokePRISM(stateSpace, null, new String[]{"-steadystate"}, false, monitor);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<Integer> states = new ArrayList<Integer>();
        ArrayList<Double> probabilities = new ArrayList<Double>();
        String time = null;
        String error = null;
        boolean parseProbabilities = false;
        boolean parseError = false;
        MessageFormat format = new MessageFormat("{0,number,integer}:({1,number,integer})={2,number}", Locale.ENGLISH);
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            System.out.println(line);
            if (line.length() == 0) {
                parseProbabilities = false;
                parseError = false;
                continue;
            }
            if (parseProbabilities) {
                Object[] parsed = format.parse(line);
                states.add(((Number)parsed[0]).intValue());
                probabilities.add(((Number)parsed[2]).doubleValue());
            } else if (parseError) {
                error = String.valueOf(error) + "\n" + line;
            } else if (line.startsWith("Probabilities:") || line.startsWith("Printing steady-state probabilities in plain text format below:")) {
                parseProbabilities = true;
            } else if (line.startsWith("Error")) {
                error = line;
                parseError = true;
                parseProbabilities = false;
            } else if (line.startsWith("Time")) {
                time = line;
            }
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        if (error != null) {
            throw new RuntimeException(error);
        }
        StringBuffer result = new StringBuffer("Computed steady-state probabilities:\n\n");
        int i = 0;
        while (i < states.size()) {
            result.append("   State " + states.get(i) + ":\t" + probabilities.get(i) + "\n");
            ++i;
        }
        if (time != null) {
            result.append("\n" + time);
        }
        monitor.done();
        return new ValidationResult(true, result.toString());
    }

    public String getName() {
        return "PRISM (steady-states)";
    }

    public boolean usesProperty() {
        return false;
    }
}

