/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.sierpinski;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class SierpinskiBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/sierpinski";

    public static void run(String path, int iterations) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        TransformationSystem trasys = resourceSet.getTransformationSystem("sierpinski.henshin");
        Rule rule = trasys.findRuleByName("AddTriangle");
        Resource resource = resourceSet.getResource("sierpinski-start.xmi");
        EObject container = (EObject)resource.getContents().get(0);
        EGraph graph = InterpreterFactory.INSTANCE.createEGraph();
        graph.addTree(container);
        graph.remove((Object)container);
        Engine engine = InterpreterFactory.INSTANCE.createEngine();
        RuleApplication application = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        application.setRule(rule);
        application.setEGraph(graph);
        System.out.println("Starting Sierpinski benchmark...");
        System.out.println(String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L) + "MB available memory\n");
        System.out.println("Level\tMatches\tNodes\tMatTime\tAppTime\tTotTime");
        int expectedNodes = 3;
        int expectedMatches = 1;
        ArrayList<Match> matches = new ArrayList<Match>();
        int i = 0;
        while (i < iterations) {
            matches.clear();
            System.gc();
            long startTime = System.currentTimeMillis();
            for (Match match : engine.findMatches(rule, graph, null)) {
                matches.add(match);
            }
            long matchingTime = System.currentTimeMillis() - startTime;
            ApplicationMonitor monitor = InterpreterFactory.INSTANCE.createApplicationMonitor();
            System.gc();
            startTime = System.currentTimeMillis();
            for (Match match : matches) {
                application.setCompleteMatch(match);
                if (application.execute(monitor)) continue;
                throw new RuntimeException("Error transforming Sierpinski model");
            }
            long runtime = System.currentTimeMillis() - startTime;
            System.out.println(String.valueOf(i + 1) + "\t" + matches.size() + "\t" + graph.size() + "\t" + matchingTime + "\t" + runtime + "\t" + (matchingTime + runtime));
            if (matches.size() != expectedMatches) {
                throw new RuntimeException("Expected " + expectedMatches + " matches instead of " + matches.size());
            }
            if (graph.size() != (expectedNodes += (expectedMatches *= 3))) {
                throw new RuntimeException("Expected " + expectedNodes + " nodes instead of " + graph.size());
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        SierpinskiBenchmark.run(PATH, 15);
    }
}

