/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions.internal;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.internal.MapEditor;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public abstract class AbstractMapEditor<E>
implements MapEditor<E> {
    private Graph source;
    private Graph target;
    private List<Mapping> mappings;

    public AbstractMapEditor(Graph source, Graph target, List<Mapping> mappings) {
        this.setSourceAndTarget(source, target);
        this.mappings = mappings;
    }

    public AbstractMapEditor(Graph target) {
        Rule rule = target.getContainerRule();
        if (rule == null) {
            throw new IllegalArgumentException("Source graph not contained in a rule");
        }
        this.setSourceAndTarget(rule.getLhs(), target);
        if (target == rule.getRhs()) {
            this.mappings = rule.getMappings();
        } else if (target.eContainer() instanceof NestedCondition) {
            this.mappings = ((NestedCondition)target.eContainer()).getMappings();
        } else {
            throw new IllegalArgumentException("Target graph must be either the RHS or contained in a NestedCondition");
        }
    }

    public AbstractMapEditor(MapEditor<?> mapEditor) {
        this(mapEditor.getSource(), mapEditor.getTarget(), mapEditor.getMappings());
    }

    private void setSourceAndTarget(Graph source, Graph target) {
        if (source == null || target == null || source == target) {
            throw new IllegalArgumentException("Source and target graph cannot be the same or null");
        }
        this.source = source;
        this.target = target;
    }

    @Override
    public final Graph getSource() {
        return this.source;
    }

    @Override
    public final Graph getTarget() {
        return this.target;
    }

    @Override
    public final List<Mapping> getMappings() {
        return this.mappings;
    }

    @Override
    public final E getOpposite(E e) {
        if (this.mappings == null) {
            return null;
        }
        Graph graph = this.getContainer(e);
        if (graph == null || graph != this.source && graph != this.target) {
            throw new IllegalArgumentException("Illegal element container: " + graph);
        }
        if (graph == this.source) {
            return HenshinMappingUtil.getImage(e, this.target, this.mappings);
        }
        return HenshinMappingUtil.getOrigin(e, this.mappings);
    }

    @Override
    protected final Graph getOpposite(Graph graph) {
        if (graph == this.source) {
            return this.target;
        }
        if (graph == this.target) {
            return this.source;
        }
        return null;
    }

    protected Graph getContainer(E e) {
        EObject current = ((EObject)e).eContainer();
        while (current != null) {
            if (current instanceof Graph) {
                return (Graph)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    @Override
    public final void move(E e) {
        E opposite = this.getOpposite(e);
        if (opposite != null) {
            this.replace(opposite);
        } else {
            this.doMove(e);
        }
    }

    protected abstract void doMove(E var1);

    @Override
    public final void remove(E e) {
        Graph container = this.getContainer(e);
        if (container != this.source && container != this.target) {
            throw new IllegalArgumentException();
        }
        E opposite = this.getOpposite(e);
        if (opposite != null) {
            this.removeMapping(e, opposite);
        }
        this.doRemove(e);
    }

    protected abstract void doRemove(E var1);

    @Override
    public final E replace(E e) {
        if (this.getOpposite(e) == null) {
            throw new IllegalArgumentException("Cannot replace an element that is not mapped: " + e);
        }
        return this.doReplace(e);
    }

    protected abstract E doReplace(E var1);

    @Override
    public final E copy(E e) {
        return this.doCopy(e);
    }

    protected abstract E doCopy(E var1);

    protected final void removeMapping(E e1, E e2) {
        if (this.mappings == null) {
            return;
        }
        Graph g1 = this.getContainer(e1);
        Graph g2 = this.getContainer(e2);
        if (g1 == this.source && g2 == this.target) {
            this.doRemoveMapping(e1, e2);
        } else if (g1 == this.target && g2 == this.source) {
            this.doRemoveMapping(e2, e1);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doRemoveMapping(E origin, E image) {
    }

    protected final void createMapping(E e1, E e2) {
        if (this.mappings == null) {
            return;
        }
        Graph g1 = this.getContainer(e1);
        Graph g2 = this.getContainer(e2);
        if (g1 == this.source && g2 == this.target) {
            this.doCreateMapping(e1, e2);
        } else if (g1 == this.target && g2 == this.source) {
            this.doCreateMapping(e2, e1);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void doCreateMapping(E origin, E image) {
    }
}

