/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.diagram.edit.helpers.RootObjectEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinLinkDescriptor;
import org.eclipse.emf.henshin.diagram.part.HenshinNodeDescriptor;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.actions.HenshinActionHelper;
import org.eclipse.gmf.runtime.notation.View;

public class HenshinDiagramUpdater {
    public static List<HenshinNodeDescriptor> getSemanticChildren(View view) {
        switch (HenshinVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return HenshinDiagramUpdater.getTransformationSystem_1000SemanticChildren(view);
            }
            case 7001: {
                return HenshinDiagramUpdater.getRuleRuleCompartment_7001SemanticChildren(view);
            }
            case 7002: {
                return HenshinDiagramUpdater.getNodeNodeCompartment_7002SemanticChildren(view);
            }
            case 7003: {
                return HenshinDiagramUpdater.getTransformationUnitUnitCompartment_7003SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<HenshinNodeDescriptor> getRuleRuleCompartment_7001SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Rule rule = (Rule)containerView.getElement();
        List actionNodes = HenshinActionHelper.getActionNodes((Rule)rule, null);
        Node root = RootObjectEditHelper.getRootObject(containerView);
        if (root != null) {
            actionNodes.remove(root);
        }
        LinkedList<HenshinNodeDescriptor> result = new LinkedList<HenshinNodeDescriptor>();
        for (Node node : actionNodes) {
            int visualID = HenshinVisualIDRegistry.getNodeVisualID(view, (EObject)node);
            if (visualID != 3001) continue;
            result.add(new HenshinNodeDescriptor((EObject)node, visualID));
        }
        return result;
    }

    public static List<HenshinNodeDescriptor> getNodeNodeCompartment_7002SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Node node = (Node)containerView.getElement();
        List attributes = HenshinActionHelper.getActionAttributes((Node)node, null);
        LinkedList<HenshinNodeDescriptor> result = new LinkedList<HenshinNodeDescriptor>();
        for (Attribute attribute : attributes) {
            int visualID = HenshinVisualIDRegistry.getNodeVisualID(view, (EObject)attribute);
            if (visualID != 3002) continue;
            result.add(new HenshinNodeDescriptor((EObject)attribute, visualID));
        }
        return result;
    }

    public static List<HenshinNodeDescriptor> getTransformationUnitUnitCompartment_7003SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        TransformationUnit unit = (TransformationUnit)containerView.getElement();
        LinkedList<HenshinNodeDescriptor> result = new LinkedList<HenshinNodeDescriptor>();
        for (TransformationUnit subUnit : unit.getSubUnits(false)) {
            int visualID = HenshinVisualIDRegistry.getNodeVisualID(view, (EObject)subUnit);
            if (visualID != 3003) continue;
            result.add(new HenshinNodeDescriptor((EObject)subUnit, visualID));
        }
        return result;
    }

    public static List<HenshinNodeDescriptor> getTransformationSystem_1000SemanticChildren(View view) {
        int visualID;
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        TransformationSystem system = (TransformationSystem)view.getElement();
        LinkedList<HenshinNodeDescriptor> result = new LinkedList<HenshinNodeDescriptor>();
        for (Rule rule : system.getRules()) {
            visualID = HenshinVisualIDRegistry.getNodeVisualID(view, (EObject)rule);
            if (visualID != 2001) continue;
            result.add(new HenshinNodeDescriptor((EObject)rule, visualID));
        }
        for (TransformationUnit unit : system.getTransformationUnits()) {
            visualID = HenshinVisualIDRegistry.getNodeVisualID(view, (EObject)unit);
            if (visualID != 2002 && visualID != 2001) continue;
            result.add(new HenshinNodeDescriptor((EObject)unit, visualID));
        }
        return result;
    }

    public static List<HenshinLinkDescriptor> getContainedLinks(View view) {
        switch (HenshinVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return HenshinDiagramUpdater.getTransformationSystem_1000ContainedLinks(view);
            }
            case 2001: {
                return HenshinDiagramUpdater.getRule_2001ContainedLinks(view);
            }
            case 2002: {
                return HenshinDiagramUpdater.getTransformationUnit_2002ContainedLinks(view);
            }
            case 3001: {
                return HenshinDiagramUpdater.getNode_3001ContainedLinks(view);
            }
            case 3002: {
                return HenshinDiagramUpdater.getAttribute_3002ContainedLinks(view);
            }
            case 3003: {
                return HenshinDiagramUpdater.getTransformationUnit_3003ContainedLinks(view);
            }
            case 4001: {
                return HenshinDiagramUpdater.getEdge_4001ContainedLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getIncomingLinks(View view) {
        switch (HenshinVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                return HenshinDiagramUpdater.getRule_2001IncomingLinks(view);
            }
            case 2002: {
                return HenshinDiagramUpdater.getTransformationUnit_2002IncomingLinks(view);
            }
            case 3001: {
                return HenshinDiagramUpdater.getNode_3001IncomingLinks(view);
            }
            case 3002: {
                return HenshinDiagramUpdater.getAttribute_3002IncomingLinks(view);
            }
            case 3003: {
                return HenshinDiagramUpdater.getTransformationUnit_3003IncomingLinks(view);
            }
            case 4001: {
                return HenshinDiagramUpdater.getEdge_4001IncomingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getOutgoingLinks(View view) {
        switch (HenshinVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                return HenshinDiagramUpdater.getRule_2001OutgoingLinks(view);
            }
            case 2002: {
                return HenshinDiagramUpdater.getTransformationUnit_2002OutgoingLinks(view);
            }
            case 3001: {
                return HenshinDiagramUpdater.getNode_3001OutgoingLinks(view);
            }
            case 3002: {
                return HenshinDiagramUpdater.getAttribute_3002OutgoingLinks(view);
            }
            case 3003: {
                return HenshinDiagramUpdater.getTransformationUnit_3003OutgoingLinks(view);
            }
            case 4001: {
                return HenshinDiagramUpdater.getEdge_4001OutgoingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getTransformationSystem_1000ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getRule_2001ContainedLinks(View view) {
        Rule rule = (Rule)view.getElement();
        List edges = HenshinActionHelper.getActionEdges((Rule)rule, null);
        Node root = RootObjectEditHelper.getRootObject(view);
        ArrayList<HenshinLinkDescriptor> result = new ArrayList<HenshinLinkDescriptor>();
        for (Edge edge : edges) {
            Node source = HenshinActionHelper.getActionNode((Node)edge.getSource());
            Node target = HenshinActionHelper.getActionNode((Node)edge.getTarget());
            if (source == root || target == root) continue;
            result.add(new HenshinLinkDescriptor((EObject)source, (EObject)target, (EObject)edge, HenshinElementTypes.Edge_4001, 4001));
        }
        return result;
    }

    public static List<HenshinLinkDescriptor> getTransformationUnit_2002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getNode_3001ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getAttribute_3002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getTransformationUnit_3003ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getEdge_4001ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getRule_2001IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getTransformationUnit_2002IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getNode_3001IncomingLinks(View view) {
        Node modelElement = (Node)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<HenshinLinkDescriptor> result = new LinkedList<HenshinLinkDescriptor>();
        result.addAll(HenshinDiagramUpdater.getIncomingTypeModelFacetLinks_Edge_4001(modelElement, crossReferences));
        return result;
    }

    public static List<HenshinLinkDescriptor> getAttribute_3002IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getTransformationUnit_3003IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getNode_3001OutgoingLinks(View view) {
        Node modelElement = (Node)view.getElement();
        LinkedList<HenshinLinkDescriptor> result = new LinkedList<HenshinLinkDescriptor>();
        result.addAll(HenshinDiagramUpdater.getOutgoingTypeModelFacetLinks_Edge_4001(modelElement));
        return result;
    }

    public static List<HenshinLinkDescriptor> getAttribute_3002OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getTransformationUnit_3003OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getEdge_4001IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getRule_2001OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getTransformationUnit_2002OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<HenshinLinkDescriptor> getEdge_4001OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    private static Collection<HenshinLinkDescriptor> getIncomingTypeModelFacetLinks_Edge_4001(Node target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<HenshinLinkDescriptor> result = new LinkedList<HenshinLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Edge link;
            if (setting.getEStructuralFeature() != HenshinPackage.eINSTANCE.getEdge_Target() || !(setting.getEObject() instanceof Edge) || 4001 != HenshinVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Edge)setting.getEObject()))) continue;
            Node src = link.getSource();
            result.add(new HenshinLinkDescriptor((EObject)src, (EObject)target, (EObject)link, HenshinElementTypes.Edge_4001, 4001));
        }
        return result;
    }

    private static Collection<HenshinLinkDescriptor> getOutgoingTypeModelFacetLinks_Edge_4001(Node source) {
        Graph container = null;
        Node element = source;
        while (element != null && container == null) {
            if (element instanceof Graph) {
                container = (Graph)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<HenshinLinkDescriptor> result = new LinkedList<HenshinLinkDescriptor>();
        for (EObject linkObject : container.getEdges()) {
            Edge link;
            if (!(linkObject instanceof Edge) || 4001 != HenshinVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Edge)linkObject))) continue;
            Node dst = link.getTarget();
            Node src = link.getSource();
            if (src != source) continue;
            result.add(new HenshinLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, HenshinElementTypes.Edge_4001, 4001));
        }
        return result;
    }
}

