/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.StateValidator;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.Validator;
import org.eclipse.emf.henshin.statespace.hashcodes.StateSpaceHashCodeUtil;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;

public class StateExplorer {
    private static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private final StateSpaceIndex index;
    private final StateSpace stateSpace;
    private final EqualityHelper equalityHelper;
    private Engine engine;
    private final List<Transition> result;
    private final boolean useObjectKeys;
    private final Rule[] rules;
    private final Map<Rule, List<Node>> ruleParameters;
    private final RuleApplication application;
    private final EList<EClass> identityTypes;
    private final ModelPostProcessor postProcessor;
    private StateValidator goalStateValidator;
    private final boolean collectMissingRoots;

    public StateExplorer(StateSpaceIndex index) {
        String collect;
        this.index = index;
        this.stateSpace = index.getStateSpace();
        this.equalityHelper = this.stateSpace.getEqualityHelper();
        this.result = new ArrayList<Transition>();
        this.identityTypes = this.equalityHelper.getIdentityTypes();
        this.useObjectKeys = !this.identityTypes.isEmpty();
        this.rules = (Rule[])this.stateSpace.getRules().toArray((Object[])new Rule[0]);
        this.ruleParameters = new HashMap<Rule, List<Node>>();
        if (this.useObjectKeys) {
            Rule[] ruleArray = this.rules;
            int n = this.rules.length;
            int n2 = 0;
            while (n2 < n) {
                Rule rule = ruleArray[n2];
                this.ruleParameters.put(rule, (List<Node>)rule.getParameterNodes());
                ++n2;
            }
        }
        this.collectMissingRoots = (collect = (String)this.stateSpace.getProperties().get((Object)"collectMissingRoots")) != null && ("true".equalsIgnoreCase(collect) || "yes".equalsIgnoreCase(collect));
        this.engine = InterpreterFactory.INSTANCE.createEngine();
        this.engine.getOptions().put("DETERMINISTIC", Boolean.TRUE);
        this.application = InterpreterFactory.INSTANCE.createRuleApplication(this.engine);
        this.goalStateValidator = null;
        String goalProperty = (String)this.stateSpace.getProperties().get((Object)"goalProperty");
        if (goalProperty != null && goalProperty.trim().length() > 0) {
            String type = null;
            if (goalProperty.indexOf(58) > 0) {
                type = goalProperty.substring(0, goalProperty.indexOf(58)).trim();
                goalProperty = goalProperty.substring(goalProperty.indexOf(58) + 1).trim();
            }
            for (Validator validator : StateSpacePlugin.INSTANCE.getValidators().values()) {
                if (!(validator instanceof StateValidator) || type != null && !type.equalsIgnoreCase(validator.getName())) continue;
                try {
                    this.goalStateValidator = (StateValidator)validator.getClass().newInstance();
                    this.goalStateValidator.setStateSpaceIndex(index);
                    this.goalStateValidator.setProperty(goalProperty);
                    break;
                }
                catch (Exception exception) {}
            }
            if (this.goalStateValidator == null) {
                StateSpacePlugin.INSTANCE.logError("Error loading goal state validator: " + type, null);
            }
        }
        this.postProcessor = new ModelPostProcessor(this.stateSpace);
    }

    public List<Transition> doExplore(State state) throws StateSpaceException {
        this.result.clear();
        Model model = this.index.getModel(state);
        EGraph graph = model.getEGraph();
        int i = 0;
        while (i < this.rules.length) {
            List<Node> parameters = this.ruleParameters.get(this.rules[i]);
            int matchIndex = 0;
            for (Match match : this.engine.findMatches(this.rules[i], graph, null)) {
                Model transformed = model.getCopy(match);
                this.application.setRule(this.rules[i]);
                this.application.setEGraph(transformed.getEGraph());
                this.application.setCompleteMatch(match);
                if (!this.application.execute(null)) {
                    throw new StateSpaceException("Error applying rule \"" + this.rules[i].getName() + "\" to found match in state " + state.getIndex());
                }
                this.postProcessor.process(transformed);
                if (this.collectMissingRoots) {
                    transformed.collectMissingRootObjects();
                }
                State newState = StateSpaceFactory.eINSTANCE.createState();
                newState.setModel(transformed);
                if (this.useObjectKeys) {
                    transformed.updateObjectKeys(this.identityTypes);
                    int[] objectKeys = transformed.getObjectKeys();
                    newState.setObjectKeys(objectKeys);
                    newState.setObjectCount(objectKeys.length);
                }
                int newHashCode = this.equalityHelper.hashCode(transformed);
                newState.setHashCode(newHashCode);
                newState.setDerivedFrom(state.getIndex());
                Transition newTransition = StateSpaceFactory.eINSTANCE.createTransition();
                newTransition.setRule(this.rules[i]);
                newTransition.setMatch(matchIndex);
                newTransition.setTarget(newState);
                if (this.useObjectKeys) {
                    int[] params = new int[parameters.size()];
                    int p = 0;
                    while (p < params.length) {
                        Node node = parameters.get(p);
                        EObject matched = match.getNodeTarget(node);
                        if (matched == null) {
                            matched = this.application.getResultMatch().getNodeTarget(node);
                        }
                        int objectKey = (Integer)transformed.getObjectKeysMap().get((Object)matched);
                        params[p] = ObjectKeyHelper.createObjectKey(matched.eClass(), objectKey, this.identityTypes);
                        ++p;
                    }
                    newTransition.setParameterKeys(params);
                    newTransition.setParameterCount(params.length);
                }
                this.result.add(newTransition);
                ++matchIndex;
            }
            ++i;
        }
        return this.result;
    }

    public boolean isGoalState(State state) throws StateSpaceException {
        if (this.goalStateValidator == null) {
            return false;
        }
        try {
            return this.goalStateValidator.validate(state, (IProgressMonitor)NULL_PROGRESS_MONITOR).isValid();
        }
        catch (Throwable e) {
            throw new StateSpaceException(e);
        }
    }

    public Model deriveModel(State state, boolean fromInitial) throws StateSpaceException {
        Path trace = new Path();
        State source = state;
        Model start = null;
        EList<State> states = this.index.getStateSpace().getStates();
        try {
            while (start == null) {
                State target = source;
                source = (State)states.get(target.getDerivedFrom());
                trace.addFirst(source.getOutgoing(target, null, -1, null));
                start = this.index.getCachedModel(source);
                if (!fromInitial || source.isInitial()) continue;
                start = null;
            }
        }
        catch (Throwable t) {
            throw new StateSpaceException("Error deriving model for " + state, t);
        }
        return this.deriveModel(trace, start);
    }

    public Model deriveModel(Path path, Model sourceModel) throws StateSpaceException {
        sourceModel = sourceModel.getCopy(null);
        this.application.setEGraph(sourceModel.getEGraph());
        for (Transition transition : path) {
            Match match = this.getMatch(transition, sourceModel);
            this.application.setCompleteMatch(match);
            if (!this.application.execute(null)) {
                throw new StateSpaceException("Error deriving model");
            }
            this.postProcessor.process(sourceModel);
            if (this.collectMissingRoots) {
                sourceModel.collectMissingRootObjects();
            }
            if (!this.useObjectKeys) continue;
            sourceModel.updateObjectKeys(this.identityTypes);
        }
        StateSpaceHashCodeUtil.computeHashCode(sourceModel, this.equalityHelper);
        return sourceModel;
    }

    public Match getMatch(Transition transition, Model sourceModel) throws StateSpaceException {
        EGraph graph = sourceModel.getEGraph();
        this.application.setEGraph(graph);
        this.application.setRule(transition.getRule());
        int targetMatch = transition.getMatch();
        int currentMatch = 0;
        for (Match foundMatch : this.engine.findMatches(transition.getRule(), graph, null)) {
            if (currentMatch++ != targetMatch) continue;
            return foundMatch;
        }
        throw new StateSpaceException("Illegal transition in state " + transition.getSource());
    }

    public Match getLastResultMatch() {
        return this.application.getResultMatch();
    }

    class ModelPostProcessor {
        private ScriptEngine engine;
        private String script;

        public ModelPostProcessor(StateSpace stateSpace) {
            ScriptEngineManager manager = new ScriptEngineManager();
            this.engine = manager.getEngineByName("JavaScript");
            this.script = (String)stateSpace.getProperties().get((Object)"postProcessor");
            if (this.script != null && this.script.trim().length() == 0) {
                this.script = null;
            }
            if (this.script != null) {
                String imports = "importPackage(java.lang);\nimportPackage(java.util);\nimportPackage(org.eclipse.emf.ecore);\n";
                this.script = String.valueOf(imports) + this.script;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Model model) throws StateSpaceException {
            if (this.script != null) {
                EObject root = (EObject)model.getResource().getContents().get(0);
                ScriptEngine scriptEngine = this.engine;
                synchronized (scriptEngine) {
                    this.engine.put("model", root);
                    try {
                        this.engine.eval(this.script);
                    }
                    catch (ScriptException e) {
                        throw new StateSpaceException(e);
                    }
                }
            }
        }
    }
}

