/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.AttributeMapEditor;
import org.eclipse.emf.henshin.model.actions.GenericActionHelper;
import org.eclipse.emf.henshin.model.actions.MapEditor;

public class AttributeActionHelper
extends GenericActionHelper<Attribute, Node> {
    public static final AttributeActionHelper INSTANCE = new AttributeActionHelper();

    @Override
    public List<Attribute> getActionElements(Node node, Action action) {
        boolean changed;
        Rule rule = node.getGraph().getRule();
        if (rule.getKernelRule() != null) {
            rule = rule.getKernelRule();
        }
        LinkedHashSet<Node> mappedNodes = new LinkedHashSet<Node>();
        mappedNodes.add(node);
        do {
            changed = false;
            TreeIterator it = rule.eAllContents();
            while (it.hasNext()) {
                Mapping m;
                EObject next = (EObject)it.next();
                if (!(next instanceof Mapping) || (m = (Mapping)next).getImage() == null || m.getOrigin() == null) continue;
                if (mappedNodes.contains(m.getOrigin())) {
                    if (!mappedNodes.add(m.getImage())) continue;
                    changed = true;
                    continue;
                }
                if (!mappedNodes.contains(m.getImage()) || !mappedNodes.add(m.getOrigin())) continue;
                changed = true;
            }
        } while (changed);
        ArrayList<Attribute> candidates = new ArrayList<Attribute>();
        for (Node n : mappedNodes) {
            candidates.addAll((Collection<Attribute>)n.getAttributes());
        }
        List<Attribute> result = this.filterElementsByAction(candidates, action);
        Collections.sort(result, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute a1, Attribute a2) {
                if (a1.getType() == null) {
                    return -1;
                }
                if (a2.getType() == null) {
                    return 1;
                }
                String n1 = a1.getType().getName();
                String n2 = a2.getType().getName();
                if (n1 == null) {
                    return -1;
                }
                return n1.compareTo(n2);
            }
        });
        return result;
    }

    @Override
    protected MapEditor<Attribute> getMapEditor(Graph target) {
        return new AttributeMapEditor(target);
    }

    @Override
    protected MapEditor<Attribute> getMapEditor(Graph source, Graph target, MappingList mappings) {
        return new AttributeMapEditor(source, target, mappings);
    }
}

