/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.migration.wizard;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.migration.Transformation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class MigrateHenshinAction
implements IObjectActionDelegate {
    private Shell shell;
    private IFile file = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null) {
            this.shell = targetPart.getSite().getShell();
        }
    }

    public void run(IAction action) {
        if (this.file != null) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                ps.busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) {
                        try {
                            Transformation tr = new Transformation();
                            pm.worked(100);
                            tr.migrate(MigrateHenshinAction.this.file.getLocationURI(), false, true, pm);
                            pm.done();
                            try {
                                MigrateHenshinAction.this.file.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException coreException) {}
                            return;
                        }
                        catch (ClassNotFoundException e) {
                            MessageDialog.openError((Shell)MigrateHenshinAction.this.shell, (String)"Error", (String)("Error during conversion: Class not found:\n" + e.getMessage()));
                            e.printStackTrace();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            MessageDialog.openError((Shell)MigrateHenshinAction.this.shell, (String)"Error", (String)"Error during conversion: Could not backup old file. Conversion aborted.");
                        }
                        catch (IOException e) {
                            MessageDialog.openError((Shell)MigrateHenshinAction.this.shell, (String)"Error", (String)("Error during conversion: IOException:\n" + e.getMessage()));
                            e.printStackTrace();
                        }
                        pm.done();
                        MessageDialog.openError((Shell)MigrateHenshinAction.this.shell, (String)"Error", (String)"Error during conversion.");
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IFile myFile;
        this.file = null;
        if (selection != null && (myFile = (IFile)((IStructuredSelection)selection).getFirstElement()) != null) {
            this.file = myFile;
        }
        action.setEnabled(this.file != null);
    }
}

