/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.henshin.diagram.edit.commands.EdgeCreateCommand;
import org.eclipse.emf.henshin.diagram.edit.commands.EdgeDeleteCommand;
import org.eclipse.emf.henshin.diagram.edit.commands.NodeDeleteCommand;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;

public class RootObjectEditHelper {
    public static final String ROOT_OBJECT_EANNOTATION_KEY = "rootObject";

    public static Node getRootObject(View ruleView) {
        if (!RuleEditHelper.isRuleView(ruleView)) {
            return null;
        }
        EAnnotation annotation = ruleView.getEAnnotation(ROOT_OBJECT_EANNOTATION_KEY);
        if (annotation == null) {
            return null;
        }
        Node root = null;
        Graph lhs = ((Rule)ruleView.getElement()).getLhs();
        for (EObject current : annotation.getReferences()) {
            if (!(current instanceof Node) || !lhs.getNodes().contains((Object)current)) continue;
            root = (Node)current;
            break;
        }
        return root;
    }

    public static void setRootObject(View ruleView, Node newRoot) throws ExecutionException {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ruleView.getElement());
        if (domain == null) {
            throw new RuntimeException();
        }
        Rule rule = (Rule)ruleView.getElement();
        EAnnotation annotation = ruleView.getEAnnotation(ROOT_OBJECT_EANNOTATION_KEY);
        Node oldRoot = RootObjectEditHelper.getRootObject(ruleView);
        if (oldRoot != null) {
            if (oldRoot == newRoot) {
                return;
            }
            NodeDeleteCommand delete = new NodeDeleteCommand(domain, oldRoot);
            delete.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        if (newRoot != null) {
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource(ROOT_OBJECT_EANNOTATION_KEY);
                annotation.setEModelElement((EModelElement)ruleView);
            }
            annotation.getReferences().clear();
            annotation.getReferences().add((Object)newRoot);
            if (!rule.getLhs().getNodes().contains((Object)newRoot)) {
                rule.getLhs().getNodes().add(0, (Object)newRoot);
                newRoot.setAction(new Action(Action.Type.PRESERVE));
            }
            for (Node node : rule.getActionNodes(null)) {
                RootObjectEditHelper.updateRootContainment(ruleView, node);
            }
        } else if (annotation != null) {
            annotation.setEModelElement(null);
        }
    }

    public static void setRootObjectType(View ruleView, EClass type) throws ExecutionException {
        if (type == null) {
            RootObjectEditHelper.setRootObject(ruleView, null);
        } else {
            Node oldRoot = RootObjectEditHelper.getRootObject(ruleView);
            if (oldRoot == null || !type.equals(oldRoot.getType().getName())) {
                Node newRoot = HenshinFactory.eINSTANCE.createNode();
                newRoot.setName("root");
                newRoot.setType(type);
                RootObjectEditHelper.setRootObject(ruleView, newRoot);
            }
        }
    }

    public static EReference getRootContainment(EClass rootType, EClass childType) {
        for (EReference reference : rootType.getEAllContainments()) {
            if (reference.getUpperBound() >= 0 || !reference.getEReferenceType().isSuperTypeOf(childType)) continue;
            return reference;
        }
        return null;
    }

    public static void updateRootContainment(View ruleView, Node node) throws ExecutionException {
        if (node == null || node.getGraph() == null || node.getGraph().getRule() == null) {
            return;
        }
        if ((node = node.getActionNode()) == null) {
            return;
        }
        Node root = RootObjectEditHelper.getRootObject(ruleView);
        if (root == null) {
            return;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)ruleView.getElement());
        if (domain == null) {
            throw new RuntimeException();
        }
        if (node == root) {
            for (Edge edge : root.getAllEdges()) {
                if (RootObjectEditHelper.isContainmentEdge(root, edge)) continue;
                new EdgeDeleteCommand(domain, edge).execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
        } else {
            ArrayList<Edge> normalContainments = new ArrayList<Edge>();
            ArrayList<Edge> rootContainments = new ArrayList<Edge>();
            for (Edge edge : node.getAllEdges()) {
                Node opposite;
                Node node2 = opposite = node == edge.getSource() ? edge.getTarget() : edge.getSource();
                if (!RootObjectEditHelper.isContainmentEdge(opposite, edge)) continue;
                if (opposite == root) {
                    rootContainments.add(edge);
                    continue;
                }
                normalContainments.add(edge);
            }
            if (!normalContainments.isEmpty()) {
                for (Edge edge : rootContainments) {
                    new EdgeDeleteCommand(domain, edge).execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
            } else if (rootContainments.isEmpty()) {
                EReference containment = RootObjectEditHelper.getRootContainment(root.getType(), node.getType());
                if (containment == null) {
                    throw new ExecutionException("No containment reference for " + node.getType().getName() + " found in root object type " + root.getType().getName());
                }
                CreateRelationshipRequest request = new CreateRelationshipRequest((EObject)root, (EObject)node, HenshinElementTypes.Edge_4001);
                request.setParameter("henshin_edge_type", (Object)containment);
                new EdgeCreateCommand(request, (EObject)root, (EObject)node).execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            int i = 1;
            while (i < rootContainments.size()) {
                new EdgeDeleteCommand(domain, (Edge)rootContainments.get(i)).execute((IProgressMonitor)new NullProgressMonitor(), null);
                ++i;
            }
        }
    }

    private static boolean isContainmentEdge(Node container, Edge edge) {
        if (edge.getSource() == container) {
            if (edge.getSource().getType().getEAllReferences().contains((Object)edge.getType())) {
                return edge.getType().isContainment();
            }
            return edge.getType().isContainer();
        }
        if (edge.getTarget() == container) {
            if (edge.getSource().getType().getEAllReferences().contains((Object)edge.getType())) {
                return edge.getType().isContainer();
            }
            return edge.getType().isContainment();
        }
        return false;
    }
}

