/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class HenshinVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.emf.henshin.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Henshin".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return HenshinVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                HenshinDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (HenshinPackage.eINSTANCE.getModule().isSuperTypeOf(domainElement.eClass()) && HenshinVisualIDRegistry.isDiagram((Module)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = HenshinVisualIDRegistry.getModelID(containerView);
        if (!"Henshin".equals(containerModelID)) {
            return -1;
        }
        if ("Henshin".equals(containerModelID)) {
            containerVisualID = HenshinVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (HenshinPackage.eINSTANCE.getRule().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (!HenshinPackage.eINSTANCE.getUnit().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 7001: {
                if (!HenshinPackage.eINSTANCE.getNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!HenshinPackage.eINSTANCE.getAttribute().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (!HenshinPackage.eINSTANCE.getUnit().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = HenshinVisualIDRegistry.getModelID(containerView);
        if (!"Henshin".equals(containerModelID)) {
            return false;
        }
        if ("Henshin".equals(containerModelID)) {
            containerVisualID = HenshinVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7003 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 3003: {
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (HenshinPackage.eINSTANCE.getEdge().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(Module element) {
        return true;
    }
}

