/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.ruleappl;

import agg.editor.impl.EdGraGra;
import agg.gui.AGGAppl;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.ruleappl.ApplRuleSequenceDialog;
import agg.gui.ruleappl.ApplRuleSequenceSaveLoad;
import agg.gui.ruleappl.ApplicabilityAtGraphResultTable;
import agg.gui.ruleappl.ApplicabilityWithoutGraphResultTable;
import agg.gui.saveload.AGGFileFilter;
import agg.gui.treeview.GraGraTreeView;
import agg.parser.CriticalPairOption;
import agg.ruleappl.ApplRuleSequence;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class ApplicabilityRuleSequence
implements TreeViewEventListener {
    private static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private Vector<JMenu> menus;
    private JMenu arsMenu;
    private JMenuItem validateARS;
    private JMenuItem loadARS;
    protected ApplRuleSequence ars;
    protected ApplRuleSequenceDialog arsGUI;
    protected ApplicabilityAtGraphResultTable arsAtGraphResultTable;
    protected ApplicabilityWithoutGraphResultTable arsWioGraphResultTable;
    protected GraGraTreeView gragraTree;
    protected EdGraGra gragra;
    protected CriticalPairOption cpOption;
    protected String graphName = "NULL";
    protected JFileChooser chooser;
    protected String dirName = "";
    protected String fileName;
    private int d = -50;

    public ApplicabilityRuleSequence(AGGAppl appl, GraGraTreeView graTreeView, CriticalPairOption cpOption) {
        this.gragraTree = graTreeView;
        this.cpOption = cpOption;
        this.menus = new Vector(2);
        this.createApplRuleSequnceMenu();
        this.ars = new ApplRuleSequence(this.cpOption);
        this.arsGUI = new ApplRuleSequenceDialog(appl, this, new Point(100, 10));
        this.arsAtGraphResultTable = new ApplicabilityAtGraphResultTable(this.ars);
        this.arsWioGraphResultTable = new ApplicabilityWithoutGraphResultTable(this.ars);
    }

    public void dispose() {
        this.gragra = null;
        this.arsGUI.dispose();
        this.ars.dispose();
        this.arsAtGraphResultTable.clear();
        this.arsWioGraphResultTable.clear();
    }

    public boolean isEmpty() {
        return this.ars.getRuleSequences().isEmpty();
    }

    public ApplRuleSequence getApplRuleSequence() {
        return this.ars;
    }

    public void clear() {
        this.arsAtGraphResultTable.clear();
        this.arsWioGraphResultTable.clear();
        this.ars.clear();
    }

    public boolean hasChecked(int seqIndx) {
        return this.ars.hasChecked(seqIndx);
    }

    public Enumeration<JMenu> getMenus() {
        return this.menus.elements();
    }

    public RuleSequence createRuleSequence() {
        RuleSequence sequence = new RuleSequence(this.gragra.getBasisGraGra(), "RuleSequence", this.cpOption);
        if (!"NULL".equals(this.graphName)) {
            sequence.setGraph(this.gragra.getBasisGraGra().getGraph(this.graphName));
        }
        this.ars.addRuleSequence(sequence);
        return sequence;
    }

    public EdGraGra getGraGra() {
        if (this.gragra == null) {
            this.gragra = this.gragraTree.getGraGra();
        }
        return this.gragra;
    }

    public boolean isGraGraLayered() {
        return this.gragra.getBasisGraGra().isLayered();
    }

    public Graph getGraph() {
        return this.gragra.getBasisGraGra().getGraph();
    }

    public String getGraphName() {
        return this.gragra.getBasisGraGra().getGraph().getName();
    }

    public RuleSequence getRuleSequence(int indx) {
        return this.ars.getRuleSequence(indx);
    }

    public Pair<Boolean, String> getApplicabilityResultOfRulesequence(int indx) {
        return this.ars.getApplicabilityResult(indx);
    }

    public Pair<Boolean, String> getNonApplicabilityResultOfRulesequence(int indx) {
        return this.ars.getNonApplicabilityResult(indx);
    }

    public boolean removeRuleSequence(int indx) {
        return this.ars.removeRuleSequence(indx);
    }

    public RuleSequence copyRuleSequence(int seqIndx) {
        return this.ars.copyRuleSequence(seqIndx);
    }

    public void moveRuleSequence(int from, int to) {
        this.ars.moveRuleSequence(from, to);
    }

    public void moveRuleInsideSequence(int seqIndx, int from, int to) {
        this.ars.moveRuleInsideSequence(seqIndx, from, to);
    }

    public boolean removeResultOfSequence(int indx) {
        if (this.ars.getRuleSequence(indx).getGraph() == null) {
            return this.removeResultOfSequenceWioGraph(indx);
        }
        return this.removeResultOfSequenceAtGraph(indx);
    }

    public boolean removeResultOfSequenceAtGraph(int indx) {
        int nb = this.arsAtGraphResultTable.closeResultTables(this.ars.getRuleSequence(indx));
        if (nb == 1) {
            this.d -= 50;
        } else if (nb == 2) {
            this.d -= 100;
        }
        return this.ars.removeResult(indx);
    }

    public boolean removeResultOfSequenceWioGraph(int indx) {
        int nb = this.arsWioGraphResultTable.closeResultTables(this.ars.getRuleSequence(indx));
        if (nb == 1) {
            this.d -= 50;
        } else if (nb == 2) {
            this.d -= 100;
        }
        return this.ars.removeResult(indx);
    }

    protected void createApplRuleSequnceMenu() {
        this.arsMenu = new JMenu("Applicability of Rule Sequence");
        this.makeValidateMenu();
        this.makeLoadMenu();
        this.menus.addElement(this.arsMenu);
    }

    private void makeValidateMenu() {
        this.validateARS = new JMenuItem("Validate");
        this.validateARS.setEnabled(true);
        this.arsMenu.add(this.validateARS);
        this.validateARS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ApplicabilityRuleSequence.this.gragraTree.getCurrentGraGra() != null) {
                    if (ApplicabilityRuleSequence.this.ars.getGraGra() != null && ApplicabilityRuleSequence.this.gragraTree.getCurrentGraGra().getBasisGraGra() != ApplicabilityRuleSequence.this.ars.getGraGra()) {
                        ApplicabilityRuleSequence.this.arsGUI.loadWarning();
                    }
                    if (ApplicabilityRuleSequence.this.gragraTree.getCurrentGraGra().getBasisGraGra() != ApplicabilityRuleSequence.this.ars.getGraGra()) {
                        ApplicabilityRuleSequence.this.arsGUI.clear();
                        ApplicabilityRuleSequence.this.gragra = ApplicabilityRuleSequence.this.gragraTree.getGraGra();
                        ApplicabilityRuleSequence.this.ars.setGraGra(ApplicabilityRuleSequence.this.gragra.getBasisGraGra());
                    } else if (ApplicabilityRuleSequence.this.arsGUI.isVisible()) {
                        ApplicabilityRuleSequence.this.arsGUI.clear();
                    }
                    ApplicabilityRuleSequence.this.ars.setRuleSequences(ApplicabilityRuleSequence.this.gragra.getBasisGraGra().getRuleSequences());
                    ApplicabilityRuleSequence.this.graphName = ApplicabilityRuleSequence.this.gragra.getBasisGraGra().getGraph().getName();
                    ApplicabilityRuleSequence.this.arsGUI.updateRuleSequences(ApplicabilityRuleSequence.this.gragra.getBasisGraGra().getRuleSequences());
                    ApplicabilityRuleSequence.this.arsGUI.extendTitle(ApplicabilityRuleSequence.this.gragra.getName());
                    int indx = ApplicabilityRuleSequence.this.gragra.getBasisGraGra().getIndexOfCurrentRuleSequence();
                    if (indx >= 0) {
                        ApplicabilityRuleSequence.this.arsGUI.selectRuleSequence(indx);
                    }
                }
                ApplicabilityRuleSequence.this.arsGUI.setVisible(true);
            }
        });
    }

    private void makeLoadMenu() {
        this.loadARS = new JMenuItem("Load");
        this.arsMenu.add(this.loadARS);
        this.loadARS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block2: {
                    try {
                        ApplicabilityRuleSequence.this.arsGUI.loadWarning();
                        ApplRuleSequenceSaveLoad arsLoad = new ApplRuleSequenceSaveLoad();
                        arsLoad.load(ApplicabilityRuleSequence.this.ars);
                        ApplicabilityRuleSequence.this.gragra = arsLoad.layout;
                        GraGra basegra = ApplicabilityRuleSequence.this.gragra.getBasisGraGra();
                        basegra.setDirName(arsLoad.dirName);
                        basegra.setFileName(arsLoad.fname);
                        ApplicabilityRuleSequence.this.gragra.getTypeSet().setResourcesPath(arsLoad.dirName);
                        ApplicabilityRuleSequence.this.gragraTree.addGraGra(ApplicabilityRuleSequence.this.gragra);
                        ApplicabilityRuleSequence.this.gragra.setChanged(false);
                        ApplicabilityRuleSequence.this.arsGUI.extendTitle(arsLoad.fname);
                        ApplicabilityRuleSequence.this.arsGUI.loadRuleSequences(basegra.getEnabledRules(), ApplicabilityRuleSequence.this.ars.getRuleSequences());
                        ApplicabilityRuleSequence.this.graphName = basegra.getGraph().getName();
                        ApplicabilityRuleSequence.this.arsGUI.setVisible(true);
                    }
                    catch (Exception ex) {
                        if (ex.getMessage() == null || "".equals(ex.getMessage())) break block2;
                        JOptionPane.showMessageDialog(ApplicabilityRuleSequence.this.arsGUI, ex.getMessage(), "", 0);
                    }
                }
            }
        });
    }

    @Override
    public void treeViewEventOccurred(TreeViewEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 61) {
            if (this.arsGUI.isVisible() && e.getData().isGraGra()) {
                if (this.arsGUI.isEmpty()) {
                    this.gragra = e.getData().getGraGra();
                    this.arsGUI.extendTitle(this.gragra.getName());
                    this.arsGUI.updateGraphName();
                } else if (this.gragra != e.getData().getGraGra()) {
                    this.arsGUI.close();
                }
            } else if (e.getData().isGraph() && !e.getData().isTypeGraph() && this.gragra == e.getData().getGraph().getGraGra() && this.arsGUI.isVisible()) {
                this.graphName = this.gragra.getGraph().getName();
            }
        }
        if (this.arsGUI.isVisible() && msgkey == 7 && e.getData().isGraGra() && this.gragra == e.getData().getGraGra()) {
            this.dispose();
        }
    }

    public boolean check(int seqIndx) {
        boolean result = this.ars.check(seqIndx);
        return result;
    }

    public boolean check(RuleSequence sequence) {
        return this.ars.check(sequence);
    }

    public void save() {
        this.chooser = this.dirName.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.dirName);
        this.chooser.setFileFilter(new AGGFileFilter("rsx", "AGG Files (.rsx)"));
        int returnVal = this.chooser.showSaveDialog(this.arsGUI);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0 && this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
            this.fileName = this.chooser.getSelectedFile().getName();
            this.ars.save(this.fileName);
        }
    }

    protected GraGra load() throws Exception {
        GraGra gra = null;
        this.chooser = this.dirName.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.dirName);
        this.chooser.setFileFilter(new AGGFileFilter("rsx", "AGG Files (.rsx)"));
        int returnVal = this.chooser.showOpenDialog(this.arsGUI);
        this.dirName = this.chooser.getCurrentDirectory().toString();
        if (returnVal == 0 && this.chooser.getSelectedFile() != null && !this.chooser.getSelectedFile().getName().equals("")) {
            this.fileName = this.chooser.getSelectedFile().getName();
            gra = this.ars.load(String.valueOf(this.dirName) + File.separator + this.fileName);
            if (gra != null) {
                gra.setDirName(this.dirName);
                gra.setFileName(this.fileName);
            }
        }
        return gra;
    }

    public void refreshGraGra() {
        this.gragraTree.fireTreeViewEvent(new TreeViewEvent(this, 29));
    }

    protected void closeGraGra() {
        if (this.gragra != null) {
            boolean grammarchanged = this.gragra.isChanged();
            this.gragra.setChanged(false);
            boolean answer = true;
            if (!answer) {
                this.gragra.setChanged(grammarchanged);
                this.gragraTree.deleteCurrentGraGra(this.gragra);
            } else {
                this.gragra.setChanged(grammarchanged);
            }
        }
    }

    public void showApplicabilityResult(int indx) {
        if (this.getRuleSequence(indx).getGraph() == null) {
            this.showApplicabilityResultWithoutGraph(indx);
        } else {
            this.showApplicabilityResultAtGraph(indx);
        }
    }

    public void showNonApplicabilityResult(int indx) {
        if (this.getRuleSequence(indx).getGraph() == null) {
            this.showNonApplicabilityResultWithoutGraph(indx);
        } else {
            this.showNonApplicabilityResultAtGraph(indx);
        }
    }

    public void showApplicabilityResultAtGraph(int indx) {
        if (this.d + 300 >= ApplicabilityRuleSequence.screenSize.width || this.d + 200 >= ApplicabilityRuleSequence.screenSize.height) {
            this.d = -50;
        }
        this.d += 50;
        Point location = new Point(50 + this.d, 100 + this.d);
        this.arsAtGraphResultTable.showApplicabilityResult(location, indx);
    }

    public void showNonApplicabilityResultAtGraph(int indx) {
        if (this.d + 300 >= ApplicabilityRuleSequence.screenSize.width || this.d + 200 >= ApplicabilityRuleSequence.screenSize.height) {
            this.d = -50;
        }
        this.d += 50;
        Point location = new Point(50 + this.d, 100 + this.d);
        this.arsAtGraphResultTable.showNonApplicabilityResult(location, indx);
    }

    public void closeAllResultTables() {
        this.arsAtGraphResultTable.closeAllResultTables();
        this.arsWioGraphResultTable.closeAllResultTables();
        this.d = -50;
    }

    public void showApplicabilityResultWithoutGraph(int indx) {
        if (this.d + 300 >= ApplicabilityRuleSequence.screenSize.width || this.d + 200 >= ApplicabilityRuleSequence.screenSize.height) {
            this.d = -50;
        }
        this.d += 50;
        Point location = new Point(50 + this.d, 100 + this.d);
        this.arsWioGraphResultTable.showApplicabilityResult(location, indx);
    }

    public void showNonApplicabilityResultWithoutGraph(int indx) {
        if (this.d + 300 >= ApplicabilityRuleSequence.screenSize.width || this.d + 200 >= ApplicabilityRuleSequence.screenSize.height) {
            this.d = -50;
        }
        this.d += 50;
        Point location = new Point(50 + this.d, 100 + this.d);
        this.arsWioGraphResultTable.showNonApplicabilityResult(location, indx);
    }
}

