/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.jface.contentassist.IContentAssistSubjectControl;
import org.eclipse.jface.contentassist.ISubjectControlContentAssistProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ActionCompletionProcessor
implements IContentAssistProcessor,
ISubjectControlContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'c', 'd', 'f', 'n', 'm'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private Rule rule;

    public ActionCompletionProcessor() {
    }

    public ActionCompletionProcessor(Rule rule) {
        this.rule = rule;
    }

    public ICompletionProposal[] computeCompletionProposals(IContentAssistSubjectControl control, int offset) {
        return this.computeCompletionProposals(control.getDocument(), offset);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return this.computeCompletionProposals(viewer.getDocument(), offset);
    }

    private ICompletionProposal[] computeCompletionProposals(IDocument document, int offset) {
        try {
            String edit = document.get(0, offset);
            Action.Type[] typeArray = Action.Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action.Type type = typeArray[n2];
                final String name = type.toString();
                if (name.startsWith(edit)) {
                    return new ICompletionProposal[]{new ICompletionProposal(){

                        public void apply(IDocument document) {
                            document.set(name);
                        }

                        public Point getSelection(IDocument document) {
                            return null;
                        }

                        public String getAdditionalProposalInfo() {
                            return null;
                        }

                        public String getDisplayString() {
                            return name;
                        }

                        public Image getImage() {
                            return null;
                        }

                        public IContextInformation getContextInformation() {
                            return null;
                        }
                    }};
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.NO_COMPLETIONS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public IContextInformation[] computeContextInformation(IContentAssistSubjectControl control, int offset) {
        return null;
    }
}

