/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.util;

import org.eclipse.emf.henshin.editor.util.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormText;

public class HtmlTipSupport {
    private TreeViewer viewer;
    private IToolTipProvider tipProvider;
    private boolean infoVisible = false;
    private TreeItem currentItem = null;
    Shell tipShell;
    FormText formText;
    private boolean hideOnMouseExitEnabled = true;
    private boolean shellManagesHiding = false;
    private static Point shift = new Point(10, 0);

    protected HtmlTipSupport(TreeViewer viewer) {
        this.viewer = viewer;
        this.tipProvider = (IToolTipProvider)viewer.getLabelProvider();
        viewer.getControl().setToolTipText("");
        this.viewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                HtmlTipSupport.this.showInfo(e);
            }
        });
        this.viewer.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (!HtmlTipSupport.this.infoVisible || !HtmlTipSupport.this.hideOnMouseExitEnabled) {
                    return;
                }
                if (HtmlTipSupport.this.getItem(e) == HtmlTipSupport.this.currentItem) {
                    return;
                }
                Rectangle bounds = HtmlTipSupport.this.tipShell.getBounds();
                bounds.x -= 5;
                bounds.y -= 5;
                bounds.width += 10;
                bounds.height += 10;
                Point position = HtmlTipSupport.this.toDisplay(new Point(e.x, e.y));
                if (bounds.contains(position)) {
                    return;
                }
                HtmlTipSupport.this.hideInfo();
            }
        });
        this.viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (HtmlTipSupport.this.shellManagesHiding) {
                    HtmlTipSupport.this.hideInfo();
                }
            }
        });
    }

    public static void enableFor(TreeViewer viewer) {
        if (!(viewer.getLabelProvider() instanceof IToolTipProvider)) {
            return;
        }
        new HtmlTipSupport(viewer);
    }

    protected TreeItem getItem(MouseEvent e) {
        return this.viewer.getTree().getItem(new Point(e.x, e.y));
    }

    protected void showInfo(MouseEvent e) {
        Point position = new Point(e.x, e.y);
        TreeItem item = this.viewer.getTree().getItem(position);
        if (item == null) {
            return;
        }
        if (this.infoVisible && item == this.currentItem) {
            return;
        }
        if (this.infoVisible) {
            this.hideInfo();
        }
        this.createInfo(position, item);
    }

    protected void hideInfo() {
        if (this.tipShell != null && !this.tipShell.isDisposed()) {
            this.tipShell.setVisible(false);
            this.currentItem = null;
            this.infoVisible = false;
        }
    }

    protected void createInfo(Point position, TreeItem item) {
        String tipText = this.getTipText(item);
        if (tipText == null) {
            return;
        }
        this.currentItem = item;
        this.infoVisible = true;
        this.setHideOnMouseExit(true);
        this.shellManagesHiding = false;
        if (this.tipShell == null || this.tipShell.isDisposed()) {
            this.createNewTipShell();
        }
        try {
            this.formText.setText("<form>" + tipText + "</form>", true, false);
        }
        catch (Exception exception) {
            return;
        }
        this.tipShell.pack();
        this.tipShell.setLocation(this.addPoints(this.viewer.getTree().toDisplay(position), shift));
        this.tipShell.setVisible(true);
    }

    protected void createNewTipShell() {
        this.tipShell = new Shell(this.viewer.getTree().getShell(), 16404);
        this.tipShell.setLayout((Layout)new FillLayout());
        this.formText = new FormText((Composite)this.tipShell, 0);
        this.formText.setBackground(Display.getDefault().getSystemColor(29));
        this.formText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                HtmlTipSupport.this.hideInfo();
            }

            public void focusGained(FocusEvent e) {
                HtmlTipSupport.this.setHideOnMouseExit(false);
            }
        });
    }

    protected String getTipText(TreeItem item) {
        Object tip = this.tipProvider.getToolTip(item.getData());
        return tip == null ? null : tip.toString();
    }

    private Point addPoints(Point p, Point q) {
        return new Point(p.x + q.x, p.y + q.y);
    }

    private Point toDisplay(Point p) {
        return this.viewer.getTree().toDisplay(p);
    }

    protected void setHideOnMouseExit(boolean enabled) {
        this.hideOnMouseExitEnabled = enabled;
    }
}

