/*
 * Decompiled with CFR 0.152.
 */
package graph.util;

import graph.Attribute;
import graph.Edge;
import graph.Graph;
import graph.GraphPackage;
import graph.Node;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class GraphValidator
extends EObjectValidator {
    public static final GraphValidator INSTANCE = new GraphValidator();
    public static final String DIAGNOSTIC_SOURCE = "graph";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String GRAPH__CORRECTLY_TYPED_NODES__EEXPRESSION = "self.nodes -> forAll(node | self.typegraph.eClassifiers -> includes(node.type))";
    protected static final String NODE__CORRECTLY_TYPED_ATTRIBUTES__EEXPRESSION = "self.attributes -> forAll(attr | self.type.eAllAttributes -> includes(attr.type))";
    protected static final String EDGE__CORRECTLY_TYPED_EDGES_SOURCE_NODE__EEXPRESSION = "self.source.type.eAllReferences -> includes(self.type)";
    protected static final String EDGE__CORRECTLY_TYPED_EDGES_TARGET_NODE__EEXPRESSION = "(self.target.type = self.type.eReferenceType) or (self.target.type.eAllSuperTypes -> includes(self.type.eReferenceType))";

    protected EPackage getEPackage() {
        return GraphPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateGraph((Graph)value, diagnostics, context);
            }
            case 1: {
                return this.validateNode((Node)value, diagnostics, context);
            }
            case 2: {
                return this.validateEdge((Edge)value, diagnostics, context);
            }
            case 3: {
                return this.validateAttribute((Attribute)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateGraph(Graph graph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(graph, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(graph, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraph_CorrectlyTypedNodes(graph, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraph_CorrectlyTypedNodes(Graph graph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.GRAPH, graph, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "CorrectlyTypedNodes", GRAPH__CORRECTLY_TYPED_NODES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNode(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(node, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(node, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_CorrectlyTypedAttributes(node, diagnostics, context);
        }
        return result;
    }

    public boolean validateNode_CorrectlyTypedAttributes(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.NODE, node, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "CorrectlyTypedAttributes", NODE__CORRECTLY_TYPED_ATTRIBUTES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEdge(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(edge, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(edge, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEdge_CorrectlyTypedEdgesSourceNode(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEdge_CorrectlyTypedEdgesTargetNode(edge, diagnostics, context);
        }
        return result;
    }

    public boolean validateEdge_CorrectlyTypedEdgesSourceNode(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.EDGE, edge, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "CorrectlyTypedEdgesSourceNode", EDGE__CORRECTLY_TYPED_EDGES_SOURCE_NODE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEdge_CorrectlyTypedEdgesTargetNode(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(GraphPackage.Literals.EDGE, edge, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "CorrectlyTypedEdgesTargetNode", EDGE__CORRECTLY_TYPED_EDGES_TARGET_NODE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attribute, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

