/*
 * Decompiled with CFR 0.152.
 */
package laxcondition.util.extensions;

import graph.Edge;
import graph.Graph;
import graph.Node;
import java.util.ArrayList;
import java.util.List;
import laxcondition.Condition;
import laxcondition.Formula;
import laxcondition.LaxCondition;
import laxcondition.LaxconditionFactory;
import laxcondition.Operator;
import laxcondition.QuantifiedLaxCondition;
import laxcondition.Quantifier;
import laxcondition.True;
import laxcondition.util.extensions.EdgeMapping;
import laxcondition.util.extensions.Intersection;
import laxcondition.util.extensions.NodeMapping;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class LaxConditionSimplifier {
    private Condition condition;
    private LaxconditionFactory factory;

    public LaxConditionSimplifier(Condition condition) {
        this.condition = condition;
        this.factory = LaxconditionFactory.eINSTANCE;
    }

    public boolean simplify() {
        if (this.simplifyNames()) {
            return this.simplify();
        }
        if (this.simplifyTrueOrFalseInFormula()) {
            return this.simplify();
        }
        if (this.simplifyNotNot()) {
            return this.simplify();
        }
        if (this.simplifyExists()) {
            return this.simplify();
        }
        return true;
    }

    private boolean insert(EObject container, LaxCondition oldContent, LaxCondition newContent) {
        if (container instanceof Condition) {
            Condition constraint = (Condition)container;
            constraint.setLaxCondition(newContent);
            return true;
        }
        if (container instanceof QuantifiedLaxCondition) {
            QuantifiedLaxCondition qlc = (QuantifiedLaxCondition)container;
            qlc.setCondition(newContent);
            return true;
        }
        if (container instanceof Formula) {
            Formula f = (Formula)container;
            int index = f.getArguments().indexOf((Object)oldContent);
            f.getArguments().set(index, (Object)newContent);
            return true;
        }
        return false;
    }

    private boolean simplifyNames() {
        TreeIterator iter1 = this.condition.eAllContents();
        while (iter1.hasNext()) {
            Node node1;
            EObject eObject1 = (EObject)iter1.next();
            if (!(eObject1 instanceof Node) || (node1 = (Node)eObject1).getNames().size() <= 1) continue;
            for (String name : node1.getNames()) {
                boolean onlyOnce = true;
                TreeIterator iter2 = this.condition.eAllContents();
                while (iter2.hasNext()) {
                    Node node2;
                    EObject eObject2 = (EObject)iter2.next();
                    if (!(eObject2 instanceof Node) || node1 == (node2 = (Node)eObject2) || !node2.getNames().contains(name)) continue;
                    onlyOnce = false;
                    break;
                }
                if (!onlyOnce) continue;
                node1.removeName(name);
                System.out.println("Removing name: " + name);
                return true;
            }
        }
        return false;
    }

    private boolean simplifyExists() {
        TreeIterator iter = this.condition.eAllContents();
        while (iter.hasNext()) {
            Graph gr2;
            Graph gr1;
            Formula andFormula;
            EObject eObject = (EObject)iter.next();
            if (this.isExistsCondition(eObject)) {
                Formula andFormula2;
                QuantifiedLaxCondition innerCondition;
                QuantifiedLaxCondition outerCondition = (QuantifiedLaxCondition)eObject;
                LaxCondition cond = outerCondition.getCondition();
                if (this.isExistsCondition(cond) && this.isTrue((innerCondition = (QuantifiedLaxCondition)cond).getCondition())) {
                    String name2;
                    String name1;
                    Node innerNode;
                    Graph innerGraph;
                    Graph outerGraph = outerCondition.getGraph();
                    if (this.isSubGraph(outerGraph, innerGraph = innerCondition.getGraph())) {
                        outerCondition.setGraph(innerGraph);
                        outerCondition.setCondition(this.factory.createTrue());
                        System.out.println("Equivalence E1.c");
                        return true;
                    }
                    if (this.isSubGraph(innerGraph, outerGraph)) {
                        outerCondition.setCondition(this.factory.createTrue());
                        System.out.println("Equivalence E1.c");
                        return true;
                    }
                    if (this.areClanDisjoint(innerGraph, outerGraph)) {
                        EList<Node> innerNodes = innerGraph.getNodes();
                        innerGraph.getNodes().clear();
                        outerGraph.getNodes().addAll(innerNodes);
                        EList<Edge> innerEdges = innerGraph.getEdges();
                        innerGraph.getEdges().clear();
                        outerGraph.getEdges().addAll(innerEdges);
                        outerCondition.setCondition(this.factory.createTrue());
                        System.out.println("Equivalence E1.b");
                        return true;
                    }
                    if (this.haveIntersection(innerGraph, outerGraph)) {
                        EList<Intersection> intersections = this.getIntersections(outerGraph, innerGraph);
                        EObject container = outerCondition.eContainer();
                        if (intersections.size() == 1) {
                            QuantifiedLaxCondition condition = this.factory.createQuantifiedLaxCondition();
                            condition.setQuantifier(Quantifier.EXISTS);
                            condition.setGraph(this.glue(outerGraph, (Intersection)intersections.get(0), innerGraph));
                            condition.setCondition(this.factory.createTrue());
                            this.insert(container, outerCondition, condition);
                            System.out.println("Equivalence E1.a");
                            return true;
                        }
                        Formula formula = this.factory.createFormula();
                        formula.setOp(Operator.OR);
                        for (Intersection intersection : intersections) {
                            QuantifiedLaxCondition condition = this.factory.createQuantifiedLaxCondition();
                            condition.setQuantifier(Quantifier.EXISTS);
                            condition.setGraph(this.glue(outerCondition.getGraph(), intersection, innerCondition.getGraph()));
                            condition.setCondition(this.factory.createTrue());
                            formula.getArguments().add((Object)condition);
                        }
                        this.insert(container, outerCondition, formula);
                        System.out.println("Equivalence E1.a");
                        return true;
                    }
                    if (this.hasOnlyOneNode(innerGraph) && this.hasTwoNames(innerNode = (Node)innerGraph.getNodes().get(0)) && this.containsExactlyOne(outerGraph, name1 = innerNode.getNames().get(0), name2 = innerNode.getNames().get(1))) {
                        this.rename(outerGraph, name1, name2);
                        outerCondition.setCondition(this.factory.createTrue());
                        System.out.println("Equivalence E3'");
                        return true;
                    }
                }
                if (this.isAndFormula(cond) && (andFormula2 = (Formula)cond).getArguments().size() == 2 && this.isExistsCondition((EObject)andFormula2.getArguments().get(0)) && this.isExistsCondition((EObject)andFormula2.getArguments().get(1))) {
                    QuantifiedLaxCondition cond1 = (QuantifiedLaxCondition)andFormula2.getArguments().get(0);
                    QuantifiedLaxCondition cond2 = (QuantifiedLaxCondition)andFormula2.getArguments().get(1);
                    if (cond1.getCondition() instanceof True && cond2.getCondition() instanceof True) {
                        Node node1;
                        String name2;
                        String name1;
                        String name;
                        Node node2;
                        Node node;
                        Graph gr = outerCondition.getGraph();
                        Graph gr12 = cond1.getGraph();
                        Graph gr22 = cond2.getGraph();
                        if (this.hasOnlyOneNode(gr) && this.hasOnlyOneNode(gr22) && this.haveSameTypes(node = (Node)gr.getNodes().get(0), node2 = (Node)gr22.getNodes().get(0)) && this.hasOneName(node) && this.hasTwoNames(node2)) {
                            name = node.getName();
                            name1 = node2.getName().split("=")[0];
                            name2 = node2.getName().split("=")[1];
                            if ((name.equals(name1) || name.equals(name2)) && this.containsExactlyOne(gr12, name1, name2)) {
                                this.rename(gr12, name1, name2);
                                outerCondition.setCondition(cond1);
                                System.out.println("Equivalence E3");
                                return true;
                            }
                        }
                        if (this.hasOnlyOneNode(gr) && this.hasOnlyOneNode(gr12) && this.haveSameTypes(node = (Node)gr.getNodes().get(0), node1 = (Node)gr12.getNodes().get(0)) && this.hasOneName(node) && this.hasTwoNames(node1)) {
                            name = node.getName();
                            name1 = node1.getName().split("=")[0];
                            name2 = node1.getName().split("=")[1];
                            if ((name.equals(name1) || name.equals(name2)) && this.containsExactlyOne(gr22, name1, name2)) {
                                this.rename(gr22, name1, name2);
                                outerCondition.setCondition(cond2);
                                System.out.println("Equivalence E3");
                                return true;
                            }
                        }
                        System.out.println("=> haveRecurringNodes: " + this.haveRecurringNodes(gr12, gr22));
                        System.out.println("=> containsEachRecurringNode: " + this.containsEachRecurringNode(gr, gr12, gr22));
                        if (this.haveRecurringNodes(gr12, gr22) && (this.containsEachRecurringNode(gr, gr12, gr22) || this.containsNoRecurringNodeType(gr, gr12, gr22)) && this.haveIntersection(gr12, gr22)) {
                            EList<Intersection> intersections = this.getIntersections(gr12, gr22);
                            if (intersections.size() == 1) {
                                QuantifiedLaxCondition condition = this.factory.createQuantifiedLaxCondition();
                                condition.setQuantifier(Quantifier.EXISTS);
                                condition.setGraph(this.glue(gr12, (Intersection)intersections.get(0), gr22));
                                condition.setCondition(this.factory.createTrue());
                                outerCondition.setCondition(condition);
                                System.out.println("Equivalence E2.a");
                                return true;
                            }
                            Formula formula = this.factory.createFormula();
                            formula.setOp(Operator.OR);
                            for (Intersection intersection : intersections) {
                                QuantifiedLaxCondition condition = this.factory.createQuantifiedLaxCondition();
                                condition.setQuantifier(Quantifier.EXISTS);
                                condition.setGraph(this.glue(gr12, intersection, gr22));
                                condition.setCondition(this.factory.createTrue());
                                formula.getArguments().add((Object)condition);
                            }
                            outerCondition.setCondition(formula);
                            System.out.println("Equivalence E2.a");
                            return true;
                        }
                    }
                }
            }
            if (!this.isAndFormula(eObject) || (andFormula = (Formula)eObject).getArguments().size() != 2 || !this.isExistsCondition((EObject)andFormula.getArguments().get(0)) || !this.isExistsCondition((EObject)andFormula.getArguments().get(1))) continue;
            QuantifiedLaxCondition cond1 = (QuantifiedLaxCondition)andFormula.getArguments().get(0);
            QuantifiedLaxCondition cond2 = (QuantifiedLaxCondition)andFormula.getArguments().get(1);
            if (!(cond1.getCondition() instanceof True) || !(cond2.getCondition() instanceof True) || !this.areClanDisjoint(gr1 = cond1.getGraph(), gr2 = cond2.getGraph()) || !this.areNodeNameDisjoint(gr1, gr2)) continue;
            EList<Node> nodes = gr2.getNodes();
            gr2.getNodes().clear();
            gr1.getNodes().addAll(nodes);
            EList<Edge> edges = gr2.getEdges();
            gr2.getEdges().clear();
            gr1.getEdges().addAll(edges);
            EObject container = andFormula.eContainer();
            this.insert(container, andFormula, cond1);
            System.out.println("Equivalence E2.b");
            return true;
        }
        return false;
    }

    private boolean haveRecurringNodes(Graph gr1, Graph gr2) {
        EList<Node> recurringNodes = this.collectRecurringNodes(gr1, gr2);
        return !recurringNodes.isEmpty();
    }

    private boolean containsEachRecurringNode(Graph gr, Graph gr1, Graph gr2) {
        EList<Node> recurringNodes = this.collectRecurringNodes(gr1, gr2);
        for (Node recurringNode : recurringNodes) {
            boolean occurs = false;
            String nodeName = recurringNode.getName();
            EClass type = recurringNode.getType();
            for (Node node : gr.getNodes()) {
                if (!node.getName().equals(nodeName) || node.getType() != type) continue;
                occurs = true;
                break;
            }
            if (occurs) continue;
            return false;
        }
        return true;
    }

    private boolean containsNoRecurringNodeType(Graph gr, Graph gr1, Graph gr2) {
        EList<Node> recurringNodes = this.collectRecurringNodes(gr1, gr2);
        boolean occurs = false;
        block0: for (Node recurringNode : recurringNodes) {
            EClass type = recurringNode.getType();
            for (Node node : gr.getNodes()) {
                if (node.getType() != type) continue;
                occurs = true;
                continue block0;
            }
        }
        return !occurs;
    }

    private EList<Node> collectRecurringNodes(Graph gr1, Graph gr2) {
        BasicEList recurringNodes = new BasicEList();
        block0: for (Node node1 : gr1.getNodes()) {
            String nodeName = node1.getName();
            EClass type = node1.getType();
            for (Node node2 : gr2.getNodes()) {
                if (!node2.getName().equals(nodeName) || node2.getType() != type) continue;
                recurringNodes.add((Object)node1);
                continue block0;
            }
        }
        return recurringNodes;
    }

    private void rename(Graph graph, String name1, String name2) {
        String newName = String.valueOf(name1) + "=" + name2;
        for (Node node : graph.getNodes()) {
            if (!node.getName().equals(name1) && !node.getName().equals(name2)) continue;
            node.setName(newName);
        }
    }

    private boolean containsExactlyOne(Graph graph, String name1, String name2) {
        boolean exists1 = false;
        boolean exists2 = false;
        for (Node node : graph.getNodes()) {
            if (node.getName().equals(name1)) {
                exists1 = true;
            }
            if (!node.getName().equals(name2)) continue;
            exists2 = true;
        }
        return exists1 && !exists2 || !exists1 && exists2;
    }

    private boolean hasTwoNames(Node node) {
        return node.getName().split("=").length == 2;
    }

    private boolean hasOneName(Node node) {
        return node.getName().split("=").length == 1;
    }

    private boolean haveSameTypes(Node node1, Node node2) {
        return node1.getType() == node2.getType();
    }

    private boolean hasOnlyOneNode(Graph graph) {
        return graph.getNodes().size() == 1 && graph.getEdges().isEmpty();
    }

    private Graph glue(Graph gr1, Intersection intersection, Graph gr2) {
        Edge edgeCopy;
        Node nodeCopy;
        Graph graph = intersection.getSourceGraph();
        for (Node node : gr1.getNodes()) {
            if (intersection.containsSource(node)) continue;
            nodeCopy = (Node)EcoreUtil.copy((EObject)node);
            intersection.addNodeMapping(new NodeMapping(nodeCopy, node));
            graph.getNodes().add((Object)nodeCopy);
        }
        for (Node node : gr2.getNodes()) {
            if (intersection.containsTarget(node)) continue;
            nodeCopy = (Node)EcoreUtil.copy((EObject)node);
            intersection.addNodeMapping(new NodeMapping(nodeCopy, node));
            graph.getNodes().add((Object)nodeCopy);
        }
        for (Edge edge : gr1.getEdges()) {
            if (intersection.containsTarget(edge)) continue;
            edgeCopy = (Edge)EcoreUtil.copy((EObject)edge);
            edgeCopy.setSource(intersection.getSourceNode1(edge.getSource()));
            edgeCopy.setTarget(intersection.getSourceNode1(edge.getTarget()));
            graph.getEdges().add((Object)edgeCopy);
        }
        for (Edge edge : gr2.getEdges()) {
            if (intersection.containsTarget(edge)) continue;
            edgeCopy = (Edge)EcoreUtil.copy((EObject)edge);
            edgeCopy.setSource(intersection.getSourceNode(edge.getSource()));
            edgeCopy.setTarget(intersection.getSourceNode(edge.getTarget()));
            graph.getEdges().add((Object)edgeCopy);
        }
        graph.setTypegraph(gr1.getTypegraph());
        return graph;
    }

    private EList<Intersection> getIntersections(Graph gr1, Graph gr2) {
        BasicEList intersections = new BasicEList();
        BasicEList subGraphs = new BasicEList();
        this.fillSubGraphs((EList<Graph>)subGraphs, gr1);
        for (Graph graph : subGraphs) {
            if (!this.isSubGraph(graph, gr2)) continue;
            intersections.add((Object)this.getIntersection(graph, gr2));
        }
        return intersections;
    }

    private Intersection getIntersection(Graph subGraph, Graph graph) {
        Intersection intersection = new Intersection();
        for (Node n1 : subGraph.getNodes()) {
            for (Node n2 : graph.getNodes()) {
                if (n1.getType() != n2.getType() || !n1.getName().equals(n2.getName())) continue;
                intersection.addNodeMapping(new NodeMapping(n1, n2));
            }
        }
        block2: for (Edge e1 : subGraph.getEdges()) {
            Node src1 = e1.getSource();
            NodeMapping srcMapping = this.getMapping(intersection.getNodeMappings(), src1);
            Node tgt1 = e1.getTarget();
            NodeMapping tgtMapping = this.getMapping(intersection.getNodeMappings(), tgt1);
            for (Edge e2 : graph.getEdges()) {
                Node src2 = e2.getSource();
                Node tgt2 = e2.getTarget();
                if (e1.getType() != e2.getType() || srcMapping.getTargetNode() != src2 || tgtMapping.getTargetNode() != tgt2) continue;
                intersection.addEdgeMapping(new EdgeMapping(e1, e2));
                continue block2;
            }
        }
        return intersection;
    }

    private void fillSubGraphs(EList<Graph> subGraphs, Graph graph) {
        EList<Edge> edges = this.cloneEdges(graph);
        for (Edge edge : edges) {
            graph.getEdges().remove((Object)edge);
            Graph gr = (Graph)EcoreUtil.copy((EObject)graph);
            graph.getEdges().add((Object)edge);
            this.testAndFill(subGraphs, gr);
        }
        EList<Node> nodes = this.cloneNodes(graph);
        for (Node node : nodes) {
            if (this.isConnected(node, graph)) continue;
            graph.getNodes().remove((Object)node);
            Graph gr = (Graph)EcoreUtil.copy((EObject)graph);
            graph.getNodes().add((Object)node);
            if (this.isEmptyGraph(gr)) continue;
            this.testAndFill(subGraphs, gr);
        }
    }

    private boolean isEmptyGraph(Graph graph) {
        return graph.getNodes().isEmpty() && graph.getEdges().isEmpty();
    }

    private boolean isConnected(Node node, Graph graph) {
        for (Edge edge : graph.getEdges()) {
            if (edge.getSource() == node) {
                return true;
            }
            if (edge.getTarget() != node) continue;
            return true;
        }
        return false;
    }

    private void testAndFill(EList<Graph> graphs, Graph graph) {
        if (!this.contains(graphs, graph)) {
            graphs.add((Object)graph);
            this.fillSubGraphs(graphs, graph);
        }
    }

    private boolean contains(EList<Graph> graphs, Graph graph) {
        for (Graph gr : graphs) {
            if (!this.isSameGraph(gr, graph)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameGraph(Graph gr1, Graph gr2) {
        return this.isSubGraph(gr1, gr2) && this.isSubGraph(gr2, gr1);
    }

    private EList<Node> cloneNodes(Graph graph) {
        BasicEList nodes = new BasicEList();
        for (Node node : graph.getNodes()) {
            nodes.add((Object)node);
        }
        return nodes;
    }

    private EList<Edge> cloneEdges(Graph graph) {
        BasicEList edges = new BasicEList();
        for (Edge edge : graph.getEdges()) {
            edges.add((Object)edge);
        }
        return edges;
    }

    private boolean areNodeNameDisjoint(Graph gr1, Graph gr2) {
        List<String> names1 = this.getNodeNames(gr1);
        List<String> names2 = this.getNodeNames(gr2);
        for (String str1 : names1) {
            for (String str2 : names2) {
                if (!str1.equals(str2)) continue;
                return false;
            }
        }
        return true;
    }

    private List<String> getNodeNames(Graph graph) {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : graph.getNodes()) {
            names.addAll(node.getNames());
        }
        return names;
    }

    private boolean haveIntersection(Graph gr1, Graph gr2) {
        EList<Intersection> intersections = this.getIntersections(gr1, gr2);
        return !intersections.isEmpty();
    }

    private boolean areClanDisjoint(Graph gr1, Graph gr2) {
        for (Node n1 : gr1.getNodes()) {
            EList<EClass> clan1 = this.getClan(n1.getType());
            for (Node n2 : gr2.getNodes()) {
                if (!clan1.contains((Object)n2.getType())) continue;
                return false;
            }
        }
        for (Node n2 : gr2.getNodes()) {
            EList<EClass> clan2 = this.getClan(n2.getType());
            for (Node n1 : gr1.getNodes()) {
                if (!clan2.contains((Object)n1.getType())) continue;
                return false;
            }
        }
        return true;
    }

    private EList<EClass> getClan(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        eClasses.add((Object)eClass);
        eClasses.addAll(this.getAllSubclasses(eClass));
        return eClasses;
    }

    private EList<EClass> getAllSubclasses(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        EPackage ePackage = eClass.getEPackage();
        TreeIterator iter = ePackage.eAllContents();
        while (iter.hasNext()) {
            EClass clazz;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof EClass) || !(clazz = (EClass)eObject).getEAllSuperTypes().contains((Object)eClass)) continue;
            eClasses.add((Object)clazz);
        }
        return eClasses;
    }

    private boolean isSubGraph(Graph gr1, Graph gr2) {
        BasicEList nodeMappings = new BasicEList();
        for (Node n1 : gr1.getNodes()) {
            for (Node n2 : gr2.getNodes()) {
                if (n1.getType() != n2.getType() || !n2.getNames().containsAll(n1.getNames())) continue;
                nodeMappings.add((Object)new NodeMapping(n1, n2));
            }
        }
        if (gr1.getNodes().size() != nodeMappings.size()) {
            return false;
        }
        for (Edge e1 : gr1.getEdges()) {
            Node src1 = e1.getSource();
            NodeMapping srcMapping = this.getMapping((EList<NodeMapping>)nodeMappings, src1);
            Node tgt1 = e1.getTarget();
            NodeMapping tgtMapping = this.getMapping((EList<NodeMapping>)nodeMappings, tgt1);
            boolean hasTarget = false;
            for (Edge e2 : gr2.getEdges()) {
                Node src2 = e2.getSource();
                Node tgt2 = e2.getTarget();
                if (e1.getType() != e2.getType() || srcMapping.getTargetNode() != src2 || tgtMapping.getTargetNode() != tgt2) continue;
                hasTarget = true;
                break;
            }
            if (hasTarget) continue;
            return false;
        }
        return true;
    }

    private NodeMapping getMapping(EList<NodeMapping> nodeMappings, Node node) {
        for (NodeMapping nm : nodeMappings) {
            if (nm.getSourceNode() != node) continue;
            return nm;
        }
        return null;
    }

    private boolean simplifyTrueOrFalseInFormula() {
        TreeIterator iter = this.condition.eAllContents();
        while (iter.hasNext()) {
            LaxCondition arg2;
            LaxCondition arg1;
            EObject container;
            Formula formula;
            EObject eObject = (EObject)iter.next();
            if (this.isAndFormula(eObject)) {
                formula = (Formula)eObject;
                container = formula.eContainer();
                arg1 = (LaxCondition)formula.getArguments().get(0);
                arg2 = (LaxCondition)formula.getArguments().get(1);
                if (this.isTrue(arg1)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg2);
                    }
                    return this.removeArgument(formula, arg1);
                }
                if (this.isTrue(arg2)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg1);
                    }
                    return this.removeArgument(formula, arg2);
                }
                if (this.isFalse(arg1)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg1);
                    }
                    return this.removeArgument(formula, arg2);
                }
                if (this.isFalse(arg2)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg2);
                    }
                    return this.removeArgument(formula, arg1);
                }
            }
            if (!this.isOrFormula(eObject)) continue;
            formula = (Formula)eObject;
            container = formula.eContainer();
            arg1 = (LaxCondition)formula.getArguments().get(0);
            arg2 = (LaxCondition)formula.getArguments().get(1);
            if (this.isTrue(arg1)) {
                if (this.twoArguments(formula)) {
                    return this.insert(container, formula, arg1);
                }
                return this.removeArgument(formula, arg2);
            }
            if (this.isTrue(arg2)) {
                if (this.twoArguments(formula)) {
                    return this.insert(container, formula, arg2);
                }
                return this.removeArgument(formula, arg1);
            }
            if (this.isFalse(arg1)) {
                if (this.twoArguments(formula)) {
                    return this.insert(container, formula, arg2);
                }
                return this.removeArgument(formula, arg1);
            }
            if (!this.isFalse(arg2)) continue;
            if (this.twoArguments(formula)) {
                return this.insert(container, formula, arg1);
            }
            return this.removeArgument(formula, arg2);
        }
        return false;
    }

    private boolean removeArgument(Formula formula, LaxCondition cond) {
        return formula.getArguments().remove((Object)cond);
    }

    private boolean twoArguments(Formula formula) {
        return formula.getArguments().size() == 2;
    }

    private boolean isFalse(LaxCondition cond) {
        if (this.isNotFormula(cond)) {
            Formula formula = (Formula)cond;
            return this.isTrue((LaxCondition)formula.getArguments().get(0));
        }
        return false;
    }

    private boolean isTrue(LaxCondition cond) {
        return cond instanceof True;
    }

    private boolean simplifyNotNot() {
        TreeIterator iter = this.condition.eAllContents();
        while (iter.hasNext()) {
            Formula formula;
            EObject eObject = (EObject)iter.next();
            if (!this.isNotFormula(eObject) || !this.isNotFormula((EObject)(formula = (Formula)eObject).getArguments().get(0))) continue;
            Formula innerFormula = (Formula)formula.getArguments().get(0);
            LaxCondition innerCondition = (LaxCondition)innerFormula.getArguments().get(0);
            EObject container = formula.eContainer();
            return this.insert(container, formula, innerCondition);
        }
        return false;
    }

    private boolean isNotFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOp().equals((Object)Operator.NOT);
        }
        return false;
    }

    private boolean isAndFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOp().equals((Object)Operator.AND);
        }
        return false;
    }

    private boolean isOrFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOp().equals((Object)Operator.OR);
        }
        return false;
    }

    private boolean isExistsCondition(EObject eObject) {
        if (eObject instanceof QuantifiedLaxCondition) {
            QuantifiedLaxCondition cond = (QuantifiedLaxCondition)eObject;
            return cond.getQuantifier().equals((Object)Quantifier.EXISTS);
        }
        return false;
    }
}

