/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.mining.core;

import de.parsemis.graph.Graph;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.IEdgeLabel;
import org.eclipse.emf.henshin.variability.mergein.mining.labels.INodeLabel;
import org.eclipse.emf.henshin.variability.mergein.normalize.HenshinGraph;

public class HenshinGraphToParsemisGraphMap {
    private Map<HenshinGraph, Graph<INodeLabel, IEdgeLabel>> henshinToParsemisGraphMap = new LinkedHashMap<HenshinGraph, Graph<INodeLabel, IEdgeLabel>>();
    private Map<Graph<INodeLabel, IEdgeLabel>, HenshinGraph> parsemisToHenshinGraphMap = new LinkedHashMap<Graph<INodeLabel, IEdgeLabel>, HenshinGraph>();

    public void put(HenshinGraph henshinGraph, Graph<INodeLabel, IEdgeLabel> graph) {
        this.henshinToParsemisGraphMap.put(henshinGraph, graph);
        this.parsemisToHenshinGraphMap.put(graph, henshinGraph);
    }

    public void put(Graph<INodeLabel, IEdgeLabel> graph, HenshinGraph henshinGraph) {
        this.henshinToParsemisGraphMap.put(henshinGraph, graph);
        this.parsemisToHenshinGraphMap.put(graph, henshinGraph);
    }

    public HenshinGraph get(Graph<INodeLabel, IEdgeLabel> graph) {
        return this.parsemisToHenshinGraphMap.get(graph);
    }

    public Graph<INodeLabel, IEdgeLabel> get(HenshinGraph henshinGraph) {
        return this.henshinToParsemisGraphMap.get((Object)henshinGraph);
    }

    public boolean contains(HenshinGraph henshinGraph) {
        return this.henshinToParsemisGraphMap.containsKey((Object)henshinGraph);
    }

    public boolean contains(Graph<INodeLabel, IEdgeLabel> graph) {
        return this.parsemisToHenshinGraphMap.containsKey(graph);
    }

    public List<HenshinGraph> getHenshinGraphs() {
        ArrayList<HenshinGraph> result = new ArrayList<HenshinGraph>();
        result.addAll(this.henshinToParsemisGraphMap.keySet());
        return result;
    }

    public List<Graph<INodeLabel, IEdgeLabel>> getMinableGraphs() {
        ArrayList<Graph<INodeLabel, IEdgeLabel>> result = new ArrayList<Graph<INodeLabel, IEdgeLabel>>();
        result.addAll(this.parsemisToHenshinGraphMap.keySet());
        return result;
    }
}

