/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.external.AbstractStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.MDPLabel;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;
import org.eclipse.emf.henshin.statespace.impl.StateExplorer;
import org.eclipse.emf.henshin.statespace.info.StateInfo;
import org.eclipse.emf.henshin.statespace.info.StateSpaceTimeInfo;
import org.eclipse.emf.henshin.statespace.info.TransitionInfo;

public class MDPStateSpaceExporter
extends AbstractStateSpaceExporter {
    public static final String EXPORTER_ID = "org.eclipse.emf.henshin.statespace.external.export.prismmdp";
    private static final int CLEAN_UP_INTERVAL = 10000;

    public void doExport(StateSpace stateSpace, URI uri, String parameters, IProgressMonitor monitor) throws IOException, StateSpaceException {
        int steps;
        StateSpaceTimeInfo timeInfo;
        int stateCount = stateSpace.getStates().size();
        monitor.beginTask("Exporting state space...", 3 * stateCount);
        try {
            timeInfo = new StateSpaceTimeInfo(this.stateSpaceIndex);
        }
        catch (StateSpaceException e) {
            throw new IOException(e);
        }
        boolean timed = timeInfo.isTimed();
        StateExplorer explorer = null;
        if (timed) {
            explorer = new StateExplorer(this.stateSpaceIndex);
        }
        if (timed && !"nm".equalsIgnoreCase(uri.fileExtension())) {
            throw new IOException("Explicit export for timed models not supported.");
        }
        boolean explicit = !timed && "tra".equalsIgnoreCase(uri.fileExtension());
        Map<String, List<Rule>> probRules = PRISMUtil.getProbabilisticRules(stateSpace);
        File file = new File(uri.toFileString());
        OutputStreamWriter writer = MDPStateSpaceExporter.createWriter(file);
        Map<String, String> probs = PRISMUtil.getAllProbs(stateSpace, explicit);
        if (!explicit) {
            writer.write(PRISMUtil.getModelHeader(timed ? "pta" : "mdp"));
            for (String ruleName : probRules.keySet()) {
                List<Rule> rules = probRules.get(ruleName);
                if (rules.size() <= 1) continue;
                int i = 0;
                while (i < rules.size()) {
                    String string = PRISMUtil.getProbKey(rules.get(i), i);
                    String value = probs.get(string);
                    writer.write("const double " + string);
                    if (value != null && !PRISMUtil.Range.isRange(value)) {
                        writer.write(" = " + value);
                    }
                    writer.write(";\n");
                    writer.write("const double " + PRISMUtil.getProbVar(i) + " = " + string + ";\n");
                    ++i;
                }
            }
            writer.write(PRISMUtil.getConstants(stateSpace));
            writer.write("\nmodule " + uri.trimFileExtension().lastSegment() + "\n\n");
        }
        int[] invariants = null;
        if (explicit) {
            writer.write(String.valueOf(stateCount) + " " + stateSpace.getTransitionCount() + "\n");
        } else {
            writer.write(PRISMUtil.getVariableDeclarations(stateSpace.getStateCount(), false));
            if (timed) {
                LinkedHashMap<String, Integer> invariantIndizes = new LinkedHashMap<String, Integer>();
                invariants = new int[stateSpace.getStateCount()];
                steps = 0;
                int lastIndex = 0;
                for (State s : stateSpace.getStates()) {
                    Integer invIndex;
                    StateInfo info = new StateInfo(s, this.stateSpaceIndex.getModel(s), explorer);
                    String inv = timeInfo.getInvariant(info);
                    if (inv == null) {
                        inv = "true";
                    }
                    if ((invIndex = (Integer)invariantIndizes.get(inv)) == null) {
                        invIndex = lastIndex++;
                        invariantIndizes.put(inv, invIndex);
                    }
                    invariants[s.getIndex()] = invIndex;
                    if (steps++ % 10000 != 0) continue;
                    this.stateSpaceIndex.clearCache();
                }
                writer.write("\ti : [0.." + Math.max(lastIndex - 1, 0) + "];\n");
                for (String clock : timeInfo.getClocks()) {
                    writer.write("\t" + clock + " : clock;\n");
                }
                if (!invariantIndizes.isEmpty()) {
                    writer.write("\n\tinvariant\n");
                    boolean first = true;
                    for (Map.Entry entry : invariantIndizes.entrySet()) {
                        writer.write(first ? "\t\t  (i=" : "\t\t& (i=");
                        writer.write(entry.getValue() + " => " + (String)entry.getKey() + ")\n");
                        first = false;
                    }
                    writer.write("\tendinvariant\n\n");
                }
            }
        }
        int removedIllegal = 0;
        steps = 0;
        for (State s : stateSpace.getStates()) {
            Map<MDPLabel, List<Transition>> map = MDPLabel.getTransitionsByLabel(s);
            int transitionIndex = 0;
            for (MDPLabel l : map.keySet()) {
                List<Transition> ts = map.get(l);
                if (ts.isEmpty()) continue;
                String label = l.getTransition().getRule().getName();
                List<Rule> rules = probRules.get(label);
                boolean allEnabled = true;
                for (Rule r : rules) {
                    boolean enabled = false;
                    for (Transition t : ts) {
                        if (t.getRule() != r) continue;
                        enabled = true;
                        break;
                    }
                    if (enabled) continue;
                    allEnabled = false;
                    break;
                }
                if (!allEnabled) {
                    ++removedIllegal;
                    continue;
                }
                if (!explicit) {
                    String guard = null;
                    if (timed) {
                        TransitionInfo info = new TransitionInfo(l.getTransition(), this.stateSpaceIndex.getModel(l.getTransition().getSource()), explorer);
                        guard = timeInfo.getGuard(info);
                    }
                    writer.write("\t[" + label + "] " + PRISMUtil.getPRISMState(s.getIndex(), guard, false) + " -> ");
                }
                boolean first = true;
                for (Transition t : ts) {
                    String prob;
                    if (!first) {
                        writer.write(explicit ? "\n" : " + ");
                    }
                    String probKey = PRISMUtil.getProbVar(rules.indexOf(t.getRule()));
                    if (explicit) {
                        prob = rules.size() > 1 ? probs.get(probKey) : "1";
                        writer.write(String.valueOf(s.getIndex()) + " " + transitionIndex + " " + t.getTarget().getIndex() + " " + prob);
                    } else {
                        prob = rules.size() > 1 ? String.valueOf(probKey) + ":" : "";
                        String extra = null;
                        if (timed) {
                            TransitionInfo info = new TransitionInfo(t, this.stateSpaceIndex.getModel(t.getSource()), explorer);
                            extra = "(i'=" + invariants[t.getTarget().getIndex()] + ")";
                            String resets = timeInfo.getResets(info);
                            if (resets != null) {
                                extra = String.valueOf(extra) + "&" + resets;
                            }
                        }
                        writer.write(String.valueOf(prob) + PRISMUtil.getPRISMState(t.getTarget().getIndex(), extra, true));
                    }
                    first = false;
                }
                if (explicit) {
                    writer.write("\n");
                    ++transitionIndex;
                    continue;
                }
                writer.write(";\n");
            }
            if (steps++ % 10000 == 0) {
                this.stateSpaceIndex.clearCache();
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        if (removedIllegal > 0) {
            StateSpacePlugin.INSTANCE.logWarning("Removed " + removedIllegal + " illegal probabilistic transitions");
        }
        if (!explicit) {
            writer.write("\nendmodule\n\n");
            if (!timed) {
                writer.write("init\n\t");
                writer.write(PRISMUtil.getPRISMStates((List<State>)stateSpace.getInitialStates()));
                writer.write("\nendinit\n");
            }
        }
        if (parameters != null) {
            try {
                String expanded = PRISMUtil.expandLabels(parameters, this.stateSpaceIndex, (IProgressMonitor)new SubProgressMonitor(monitor, stateCount));
                if (explicit) {
                    OutputStreamWriter labelsWriter = MDPStateSpaceExporter.createWriter(new File(uri.toFileString().replaceAll(".tra", ".lab")));
                    labelsWriter.write(expanded);
                    labelsWriter.close();
                } else {
                    writer.write("\n" + expanded + "\n");
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (explicit) {
            OutputStreamWriter statesWriter = MDPStateSpaceExporter.createWriter(new File(uri.toFileString().replaceAll(".tra", ".sta")));
            statesWriter.write(String.valueOf(PRISMUtil.getVariableDeclarations(stateSpace.getStateCount(), true)) + "\n");
            int i = 0;
            while (i < stateCount) {
                statesWriter.write(String.valueOf(i) + ":(" + i + ")\n");
                ++i;
            }
            statesWriter.close();
        }
        writer.close();
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    public String getName() {
        return "PRISM MDP/PTA";
    }

    public String[] getFileExtensions() {
        return new String[]{"nm", "tra"};
    }
}

