/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.parser;

import agg.attribute.AttrContext;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class JavaClassCreation {
    private static String s1 = "public class ";
    private static String s2 = " {";
    private static String s3 = "}";
    private String name;
    private Vector<String> classPackages;
    private AttrContext attrContext;
    private ValueMember member;
    private String expr;

    public JavaClassCreation() {
        InformationFacade info = DefaultInformationFacade.self();
        AttrHandler javaHandler = info.getJavaHandler();
        this.classPackages = ((JexHandler)javaHandler).getClassResolver().getPackages();
    }

    public File createClass(String className, AttrContext attrCntxt, ValueMember vmember, String vexpr, boolean addMethodCall) {
        this.attrContext = attrCntxt;
        this.member = vmember;
        this.expr = vexpr;
        this.name = className;
        boolean fileExists = true;
        int i = 0;
        while (fileExists) {
            File f = new File(this.name);
            f.deleteOnExit();
            if (f.exists()) {
                this.name = String.valueOf(this.name) + i;
                ++i;
                continue;
            }
            fileExists = false;
        }
        File file = new File(String.valueOf(this.name) + ".java");
        System.out.println("Output file:  " + file);
        String b = new String();
        b = String.valueOf(b) + this.createImports() + "\n";
        b = String.valueOf(b) + s1 + this.name + s2 + "\n";
        b = String.valueOf(b) + this.createFields() + "\n";
        b = !addMethodCall ? String.valueOf(b) + this.createGetMethod() + "\n" : String.valueOf(b) + this.createAddMethod() + "\n";
        b = String.valueOf(b) + s3;
        System.out.println("\n" + b + "\n");
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(b.getBytes());
                fos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return file;
    }

    private String createImports() {
        String b = new String();
        int i = 0;
        while (i < this.classPackages.size()) {
            String p = this.classPackages.get(i);
            b = String.valueOf(b) + "import " + p + ".*;\n";
            ++i;
        }
        return b;
    }

    private String createFields() {
        String b = "";
        VarTuple vars = (VarTuple)this.attrContext.getVariables();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember v = vars.getVarMemberAt(i);
            b = String.valueOf(b) + "private " + v.getDeclaration().getTypeName() + " " + v.getName() + ";\n";
            ++i;
        }
        return b;
    }

    private String createGetMethod() {
        String b = new String();
        String typeName = this.member.getDeclaration().getTypeName();
        b = "public " + typeName + " get" + this.member.getName() + "(){ \n";
        b = String.valueOf(b) + "return " + this.expr + ";\n";
        b = String.valueOf(b) + "}\n";
        return b;
    }

    private String createAddMethod() {
        String b = new String();
        String typeName = "void";
        b = "public " + typeName + " addItem" + "(){ \n";
        b = String.valueOf(b) + this.expr + ";\n";
        b = String.valueOf(b) + "}\n";
        return b;
    }
}

