/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.cons.Formula;
import agg.gui.help.HtmlBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GraGraConstraintPriorityDialog
extends JDialog
implements ActionListener {
    private JPanel contentPane;
    private JPanel constraintPanel;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private JTable constraintTable;
    private JButton closeButton;
    private JButton cancelButton;
    private JButton helpButton;
    private boolean isCancelled;
    private Vector<Formula> constraints;
    private Vector<String> priorities;
    private HtmlBrowser helpBrowser;

    public GraGraConstraintPriorityDialog(JFrame parent, Vector<Formula> constraints, Vector<String> prioritiesAsString) {
        super((Frame)parent, true);
        this.setTitle("Select Rule Priority");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GraGraConstraintPriorityDialog.this.exitForm(evt);
            }
        });
        this.constraints = constraints;
        this.priorities = new Vector(prioritiesAsString.size());
        int i = 0;
        while (i < prioritiesAsString.size()) {
            this.priorities.add(prioritiesAsString.get(i));
            ++i;
        }
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        } else {
            this.setLocation(300, 100);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBackground(Color.lightGray);
        this.constraintPanel = new JPanel(new BorderLayout());
        this.constraintPanel.setBackground(Color.orange);
        this.constraintPanel.setBorder(new TitledBorder("Select Rule Priority for Graph Constraint"));
        this.constraintTable = new JTable(new HashTableModel(this.constraints, this.priorities));
        this.constraintTable.setRowSelectionAllowed(true);
        this.constraintTable.setColumnSelectionAllowed(true);
        Color sbgColor = this.constraintTable.getSelectionBackground();
        this.constraintTable.setSelectionBackground(Color.WHITE);
        int i = 1;
        while (i < this.constraintTable.getColumnCount()) {
            TableColumn column = this.constraintTable.getColumn(this.constraintTable.getColumnName(i));
            column.setMaxWidth(30);
            PriorityCellRenderer lcr = new PriorityCellRenderer(i, this.constraintTable.getRowCount(), this.constraintTable, sbgColor);
            column.setCellRenderer(lcr);
            ++i;
        }
        this.constraintTable.getSelectionModel().setSelectionMode(2);
        int hght = this.getHeight(this.constraintTable.getRowCount(), this.constraintTable.getRowHeight()) + 10;
        this.constraintTable.doLayout();
        this.scrollPane = new JScrollPane(this.constraintTable);
        this.scrollPane.setPreferredSize(new Dimension(300, hght));
        this.constraintPanel.add(this.scrollPane);
        this.buttonPanel = new JPanel(new GridLayout(0, 3, 5, 5));
        this.closeButton = new JButton();
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept entries and close dialog.");
        this.closeButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.isCancelled = false;
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.closeButton.setToolTipText("Reject entries and close dialog.");
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton();
        this.helpButton.setActionCommand("help");
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.helpButton);
        this.contentPane.add((Component)this.constraintPanel, "Center");
        this.contentPane.add((Component)this.buttonPanel, "South");
        this.contentPane.revalidate();
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(0);
        this.validate();
        this.pack();
    }

    void exitForm(WindowEvent evt) {
        if (this.helpBrowser != null) {
            this.helpBrowser.setVisible(false);
            this.helpBrowser.dispose();
        }
        this.setVisible(false);
        this.dispose();
    }

    public void showGUI() {
        this.setVisible(true);
    }

    private void acceptValues() {
        Hashtable<Object, Vector<Object>> table = ((HashTableModel)this.constraintTable.getModel()).getTable();
        Enumeration<Object> e = table.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector<Object> p = table.get(key);
            Vector<Integer> v = new Vector<Integer>(p.size());
            int i = 0;
            while (i < p.size()) {
                String s = (String)p.get(i);
                if (!s.equals("")) {
                    v.add(Integer.valueOf(s));
                }
                ++i;
            }
            ((Formula)key).setPriority(v);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.acceptValues();
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isCancelled = true;
            this.setVisible(false);
            if (this.helpBrowser != null) {
                this.helpBrowser.setVisible(false);
                this.helpBrowser.dispose();
            }
            this.dispose();
        } else if (source == this.helpButton) {
            if (this.helpBrowser != null) {
                this.helpBrowser.dispose();
                this.helpBrowser = null;
            }
            if (this.helpBrowser == null) {
                this.helpBrowser = new HtmlBrowser("ConstraintForPriorityHelp.html");
                this.helpBrowser.setSize(500, 350);
                this.helpBrowser.setLocation(50, 50);
                this.helpBrowser.setVisible(true);
            }
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    private int getHeight(int rowCount, int rowHeight) {
        int h = (rowCount + 1) * rowHeight;
        if (rowCount > 10) {
            h = 12 * rowHeight;
        }
        return h;
    }

    public class HashTableModel
    extends DefaultTableModel {
        Hashtable<Object, Vector<Object>> table;

        public HashTableModel(Vector<Formula> constraints, Vector<String> priorities) {
            priorities.add(0, "Constraint / Rule Priority");
            int i = 0;
            while (i < priorities.size()) {
                this.addColumn(priorities.get(i));
                ++i;
            }
            this.table = new Hashtable(constraints.size());
            i = 0;
            while (i < constraints.size()) {
                Formula f = constraints.get(i);
                Vector<Integer> priors = f.getPriority();
                Vector<Object> tmpVector = new Vector<Object>();
                int k = 1;
                while (k < priorities.size()) {
                    String p = priorities.get(k);
                    boolean found = false;
                    int j = 0;
                    while (j < priors.size()) {
                        Integer v = priors.get(j);
                        if (v.intValue() == Integer.valueOf(p).intValue()) {
                            tmpVector.addElement(p);
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        tmpVector.addElement("");
                    }
                    ++k;
                }
                Vector<Object> value = new Vector<Object>();
                value.addAll(tmpVector);
                this.table.put(f, value);
                tmpVector.add(0, f);
                this.addRow(tmpVector);
                ++i;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result = super.getValueAt(row, column);
            if (result instanceof Formula) {
                result = ((Formula)result).getName();
            } else {
                Object key = super.getValueAt(row, 0);
                if (key instanceof Formula) {
                    Vector<Object> v = this.table.get(key);
                    result = column - 1 < v.size() ? v.get(column - 1) : "";
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            Object key = super.getValueAt(row, 0);
            try {
                super.setValueAt(aValue, row, column);
                Vector<Object> v = this.table.get(key);
                v.remove(column - 1);
                v.add(column - 1, aValue);
                this.table.put(key, v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public Hashtable<Object, Vector<Object>> getTable() {
            return this.table;
        }

        public Formula getConstraint(String name) {
            Enumeration<Object> e = this.table.keys();
            while (e.hasMoreElements()) {
                Formula key = (Formula)e.nextElement();
                if (!key.getName().equals(name)) continue;
                return key;
            }
            return null;
        }

        public int getRow(Formula constraint) {
            int i = 0;
            while (i < this.getRowCount()) {
                String rname = (String)this.getValueAt(i, 0);
                Formula f = this.getConstraint(rname);
                if (f != null && f.equals(constraint)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    public class PriorityCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer,
    MouseListener {
        Vector<JCheckBox> checks;
        int clmn;
        Color selColor = Color.WHITE;
        public final JTable jtable;

        public PriorityCellRenderer(int indx, int size, JTable table, Color selColor) {
            this.addMouseListener(this);
            this.jtable = table;
            this.jtable.addMouseListener(this);
            this.checks = new Vector(size);
            this.clmn = indx;
            this.initPriorities(indx, size);
            this.setEnabled(false);
        }

        private void initPriorities(int indx, int size) {
            int i = 0;
            while (i < size) {
                JCheckBox cb = new JCheckBox("", false);
                cb.setBackground(Color.WHITE);
                this.checks.addElement(cb);
                Object value = ((DefaultTableModel)this.jtable.getModel()).getValueAt(i, indx);
                if (!((String)value).equals("")) {
                    cb.setSelected(true);
                }
                ++i;
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JCheckBox jcb = this.checks.get(row);
            return jcb;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i = 0;
            while (i < this.checks.size()) {
                JCheckBox cb = this.checks.get(i);
                if (this.jtable.isCellSelected(i, this.clmn)) {
                    cb.setSelected(!cb.isSelected());
                    if (cb.isSelected()) {
                        cb.setBackground(this.selColor);
                        ((DefaultTableModel)this.jtable.getModel()).setValueAt(this.jtable.getColumnName(this.clmn), i, this.clmn);
                    } else {
                        cb.setBackground(Color.WHITE);
                        ((DefaultTableModel)this.jtable.getModel()).setValueAt("", i, this.clmn);
                    }
                }
                ++i;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public Vector<JCheckBox> getChecks() {
            return this.checks;
        }
    }
}

