/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.CriticalPairEvent;
import agg.parser.DependencyPair;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.Report;
import agg.parser.SimpleDependencyPair;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.ConcurrentRule;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class DependencyPairContainer
extends ExcludePairContainer {
    protected boolean switchDependency;
    protected boolean makeConcurrentRules;
    protected boolean completeConcurrency = true;
    protected List<ConcurrentRule> concurrentRules;

    public DependencyPairContainer(GraGra gragra) {
        super(gragra);
        this.conflictKind = 1;
        this.completeConcurrency = true;
    }

    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getDependencyContainer() {
        return super.getExcludeContainer();
    }

    @Override
    public Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalPair(Rule r1, Rule r2, int kind, boolean local) throws InvalidAlgorithmException {
        if (local) {
            ExcludePairContainer.Entry e = this.getEntry(r1, r2);
            if (e.isProgressIndexSet()) {
                return this.continueComputeCriticalPair(r1, r2, this.getContainer(kind, r1, r2));
            }
            return this.getCriticalPair(r1, r2, this.getContainer(kind, r1, r2));
        }
        return this.getCriticalPair(r1, r2, this.getContainer(kind));
    }

    public void enableSwitchDependency(boolean b) {
        this.switchDependency = b;
        if (this.conflictKind == 1 && this.switchDependency) {
            this.conflictKind = 2;
        } else if (this.conflictKind == 2 && !this.switchDependency) {
            this.conflictKind = 1;
        }
    }

    public void enableProduceConcurrentRule(boolean b) {
        this.makeConcurrentRules = b;
    }

    public void setCompleteConcurrency(boolean b) {
        this.completeConcurrency = b;
    }

    public List<ConcurrentRule> getConcurrentRules() {
        return this.concurrentRules;
    }

    public DependencyPair getCurrentDependencyPair() {
        return (DependencyPair)this.excludePair;
    }

    @Override
    protected synchronized void computeCritical(Rule r1, Rule r2) {
        Report.trace("ExcludePairContainer: starte computeCritical" + this.getEntry((Rule)r1, (Rule)r2).state + "   " + r1.getName() + "    " + r2.getName(), 2);
        ExcludePairContainer.Entry e = this.getEntry(r1, r2);
        if (!r1.isEnabled() || !r2.isEnabled()) {
            e.state = 5;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  should not be computed."));
            return;
        }
        if (e.state == 1 || e.state == 0) {
            e.state = 2;
            this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            if (!this.complete) {
                this.excludePair = new SimpleDependencyPair();
            } else {
                this.excludePair = new DependencyPair();
                this.excludePair.setGraGra(this.grammar);
            }
            this.setOptionsOfExcludePair();
            ((DependencyPair)this.excludePair).enableSwitchDependency(this.switchDependency);
            ((DependencyPair)this.excludePair).enableProduceConcurrentRule(this.makeConcurrentRules);
            ((DependencyPair)this.excludePair).setCompleteConcurrency(this.completeConcurrency);
            Object overlapping = null;
            try {
                overlapping = this.excludePair.isCritical(0, r1, r2);
                e = this.getEntry(r1, r2, true);
                e.setProgressIndx(this.excludePair);
                if (!this.excludePair.computable) {
                    e.setStatus(7);
                } else if (overlapping != null) {
                    this.concurrentRules = ((DependencyPair)this.excludePair).getConcurrentRules();
                }
            }
            catch (InvalidAlgorithmException invalidAlgorithmException) {
                // empty catch block
            }
            boolean critic = overlapping != null;
            this.addEntry(r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
            if (critic) {
                if (!this.excludePair.dependencyCond1 && this.excludePair.dependencyCond2) {
                    e.setState(31);
                } else if (this.excludePair.dependencyCond1 && this.excludePair.dependencyCond2) {
                    e.setState(32);
                } else {
                    e.setState(3);
                }
            }
            this.usedM += this.excludePair.usedM;
            this.excludePair.dispose();
            this.excludePair = null;
            this.addQuadruple(this.excludeContainer, r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
            if (overlapping != null) {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, 1, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
            } else {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have not any critical pairs"));
            }
        }
    }

    @Override
    protected synchronized Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> continueComputeCriticalPair(Rule r1, Rule r2, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container) {
        ExcludePairContainer.Entry e = this.getEntry(r1, r2, true);
        if (!e.isProgressIndexSet()) {
            return null;
        }
        e.state = 2;
        this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
        this.excludePair = !this.complete ? new SimpleDependencyPair() : new DependencyPair();
        this.excludePair.setProgressIndx(e);
        this.setOptionsOfExcludePair();
        ((DependencyPair)this.excludePair).enableSwitchDependency(this.switchDependency);
        ((DependencyPair)this.excludePair).enableProduceConcurrentRule(this.makeConcurrentRules);
        ((DependencyPair)this.excludePair).setCompleteConcurrency(this.completeConcurrency);
        Object overlapping = null;
        try {
            overlapping = this.excludePair.isCritical(0, r1, r2);
            e = this.getEntry(r1, r2, true);
            e.setProgressIndx(this.excludePair);
            if (!this.excludePair.computable) {
                e.setStatus(7);
            } else if (overlapping != null) {
                this.concurrentRules = ((DependencyPair)this.excludePair).getConcurrentRules();
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
        boolean critic = overlapping != null;
        ExcludePairContainer.Entry entry = this.addEntry(r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
        if (critic) {
            if (!this.excludePair.dependencyCond1 && this.excludePair.dependencyCond2) {
                entry.setState(31);
            } else if (this.excludePair.dependencyCond1 && this.excludePair.dependencyCond2) {
                entry.setState(32);
            } else {
                entry.setState(3);
            }
        }
        this.excludePair.dispose();
        this.excludePair = null;
        this.addQuadruple(this.excludeContainer, r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
        this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
        if (overlapping != null) {
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, 1, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
        } else {
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have not any critical pairs"));
        }
        this.firePairEvent(new CriticalPairEvent((ExcludePairContainer)this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
        return this.getCriticalPair(r1, r2, container);
    }

    @Override
    protected Pair<OrdinaryMorphism, OrdinaryMorphism> readOldOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, String firstName, Graph overlapGraph) {
        OrdinaryMorphism first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
        OrdinaryMorphism second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
        first.setName(firstName.replaceAll(" ", ""));
        while (h.readSubTag("Mapping")) {
            GraphObject o = (GraphObject)h.getObject("orig", null, false);
            GraphObject i = (GraphObject)h.getObject("image", null, false);
            if (o != null && i != null) {
                first.addMapping(o, i);
            }
            h.close();
        }
        h.close();
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            second.setName(name.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    second.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(first, second);
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        Rule r2;
        Enumeration k2;
        Hashtable secondPart;
        Rule r1;
        h.openNewElem("CriticalPairs", this);
        h.addObject("GraGra", this.getGrammar(), true);
        h.openSubTag("dependenciesContainer");
        String kind = "trigger_dependency";
        if (this.switchDependency) {
            kind = "trigger_switch_dependency";
        }
        h.addAttr("kind", kind);
        Enumeration keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = (Rule)keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = (Hashtable)this.excludeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = (Rule)k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                Pair p = (Pair)secondPart.get(r2);
                Boolean b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                if (b.booleanValue()) {
                    Vector v = (Vector)p.second;
                    int i = 0;
                    while (i < v.size()) {
                        Pair p2i = (Pair)v.elementAt(i);
                        Pair p2 = (Pair)p2i.first;
                        h.openSubTag("Overlapping_Pair");
                        OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                        Graph overlapping = first.getImage();
                        h.addObject("", overlapping, true);
                        for (GraphObject graphObject : overlapping.getNodesSet()) {
                            if (!graphObject.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", graphObject, false);
                            h.close();
                        }
                        for (GraphObject graphObject : overlapping.getArcsSet()) {
                            if (!graphObject.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", graphObject, false);
                            h.close();
                        }
                        this.writeOverlapMorphisms(h, r1, r2, p2i);
                        h.close();
                        ++i;
                    }
                }
                h.close();
            }
            h.close();
        }
        h.close();
        if (this.conflictFreeContainer != null) {
            h.openSubTag("conflictFreeContainer");
            keys = this.excludeContainer.keys();
            while (keys.hasMoreElements()) {
                r1 = (Rule)keys.nextElement();
                h.openSubTag("Rule");
                h.addObject("R1", r1, false);
                secondPart = (Hashtable)this.conflictFreeContainer.get(r1);
                k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    r2 = (Rule)k2.nextElement();
                    h.openSubTag("Rule");
                    h.addObject("R2", r2, false);
                    Boolean b = (Boolean)((Pair)secondPart.get((Object)r2)).first;
                    h.addAttr("bool", b.toString());
                    h.close();
                }
                h.close();
            }
            h.close();
        }
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("CriticalPairs", this)) {
            String bool;
            Enumeration<Element> r2s;
            Enumeration<Element> r1s;
            Rule r1 = null;
            Rule r2 = null;
            boolean b = false;
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> allOverlappings = null;
            Vector<String> tagnames = new Vector<String>(1);
            Vector<String> tagnames2 = new Vector<String>(1);
            this.grammar = BaseFactory.theFactory().createGraGra();
            h.getObject("", this.grammar, true);
            tagnames.add("conflictContainer");
            tagnames.add("conflictsContainer");
            tagnames.add("excludeContainer");
            tagnames2.add("dependencyContainer");
            tagnames2.add("dependenciesContainer");
            this.switchDependency = false;
            if (h.readSubTag(tagnames2)) {
                this.conflictKind = 1;
                if (h.readAttr("kind").equals("trigger_switch_dependency")) {
                    this.switchDependency = true;
                    this.conflictKind = 2;
                }
            } else if (h.readSubTag(tagnames)) {
                this.conflictKind = 0;
            }
            if (this.conflictKind == 1 || this.conflictKind == 2 || this.conflictKind == 0) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        allOverlappings = null;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                            Enumeration<Element> overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                h.peekElement(overlappings.nextElement());
                                Graph g = (Graph)h.getObject("", BaseFactory.theFactory().createGraph(this.grammar.getTypeSet()), true);
                                while (h.readSubTag("Critical")) {
                                    GraphObject o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = this.readOverlappingMorphisms(h, r1, r2, g);
                                allOverlappings.addElement(p);
                                h.close();
                            }
                        }
                        this.addQuadruple(this.excludeContainer, r1, r2, b, allOverlappings);
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            if (h.readSubTag("conflictFreeContainer")) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        this.addQuadruple(this.conflictFreeContainer, r1, r2, b, null);
                        if (!r1.isEnabled()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 5;
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        h.close();
    }

    @Override
    public String toString() {
        String result = String.valueOf(super.toString()) + "\n" + this.getGrammar().toString() + "\n";
        result = String.valueOf(result) + "dependenciesContainer " + this.excludeContainer + "\n\n";
        result = String.valueOf(result) + "conflictFreeContainer " + this.conflictFreeContainer + "\n";
        return result;
    }
}

