/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.AbstractParser;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ExcludeParser
extends AbstractParser
implements Runnable {
    protected Stack<Object> stack = new Stack();
    protected boolean stop = false;
    protected boolean correct;

    public ExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, ExcludePairContainer excludeContainer) {
        super(grammar, hostGraph, stopGraph, excludeContainer);
    }

    @Override
    public boolean parse() {
        System.out.println("Starting exclude parser with CPA ... ");
        this.correct = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting exclude parser ..."));
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFree = null;
        try {
            this.fireParserEvent(new ParserMessageEvent(this, "Computting conflict free pairs. Please wait ..."));
            conflictFree = this.pairContainer.getContainer(3);
            this.fireParserEvent(new ParserMessageEvent(this, "Computting conflict free pairs done"));
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> exclude = null;
        try {
            this.fireParserEvent(new ParserMessageEvent(this, "Computting exclude pairs. Please wait ..."));
            exclude = this.pairContainer.getContainer(0);
            this.fireParserEvent(new ParserMessageEvent(this, "Computting exclude pairs done"));
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFreeLight = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeLight = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
        this.makeLightContainer(exclude, excludeLight);
        this.makeLightContainer(conflictFree, conflictFreeLight);
        Enumeration<Rule> keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            if (!excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        RuleInstances eri = new RuleInstances();
        this.fireParserEvent(new ParserMessageEvent(this, "Parser initialized"));
        while (!this.stop && !this.graph.isIsomorphicTo(this.stopGraph) && this.correct) {
            OrdinaryMorphism copyMorph;
            boolean ruleApplied = false;
            Enumeration<Rule> keys2 = conflictFreeLight.keys();
            while (keys2.hasMoreElements() && !ruleApplied) {
                Rule r = keys2.nextElement();
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for simple match"));
                Match m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                m.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                while (!ruleApplied && m.nextCompletion()) {
                    if (!m.isValid() || !this.applyRule(m)) continue;
                    ruleApplied = true;
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                m.dispose();
            }
            if (ruleApplied || this.stop) continue;
            OrdinaryMorphism savedMatch = null;
            Enumeration<Rule> keys3 = excludeLight.keys();
            while (keys3.hasMoreElements() && !ruleApplied && !this.stop) {
                Rule r = keys3.nextElement();
                Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> inclusions = this.findInclusions(r, 0);
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match"));
                Match m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                m.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                boolean validMatch = false;
                while (!ruleApplied && m.nextCompletion()) {
                    if (!m.isValid()) continue;
                    if (!this.isMatchCritic(m, inclusions)) {
                        if (!this.applyRule(m)) continue;
                        ruleApplied = true;
                        try {
                            Thread.sleep(this.delay);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    if (validMatch || savedMatch != null || eri.isIn(m)) continue;
                    validMatch = true;
                    savedMatch = m;
                }
                if (validMatch) continue;
                BaseFactory.theFactory().destroyMatch(m);
            }
            if (!ruleApplied && savedMatch != null && !this.stop && (copyMorph = this.getHostGraph().isomorphicCopy()) != null) {
                this.fireParserEvent(new ParserMessageEvent(copyMorph, "IsoCopy"));
                eri.add((Match)savedMatch);
                Pair<Graph, RuleInstances> tmpPair = new Pair<Graph, RuleInstances>(this.getHostGraph(), eri);
                this.stack.push(tmpPair);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                OrdinaryMorphism tmpMorph = savedMatch.compose(copyMorph);
                Match n = tmpMorph.makeMatch(((Match)savedMatch).getRule());
                n.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                boolean notFound = false;
                while (!n.isValid() && !notFound) {
                    if (n.nextCompletion()) continue;
                    notFound = true;
                }
                if (!notFound && this.applyRule(n)) {
                    ruleApplied = true;
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (ruleApplied) continue;
            try {
                Pair tmpPair = (Pair)this.stack.pop();
                this.setHostGraph((Graph)tmpPair.first);
                eri = (RuleInstances)tmpPair.second;
            }
            catch (EmptyStackException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!this.stack.empty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                Pair tmpPair = (Pair)this.stack.pop();
                Graph g = (Graph)tmpPair.first;
                g.dispose();
                tmpPair.second = null;
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }

    @Override
    protected void finalize() {
        this.getHostGraph().dispose();
    }

    protected void makeLightContainer(Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> in, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> out) {
        Enumeration<Rule> keys = in.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            if (key == null) continue;
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> value = in.get(key);
            boolean allTrue = true;
            Enumeration<Rule> keys2 = value.keys();
            while (keys2.hasMoreElements() && allTrue) {
                Hashtable<Object, Object> secondPart;
                Rule key2 = keys2.nextElement();
                if (key == key2) continue;
                Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = value.get(key2);
                Boolean first = (Boolean)p.first;
                if (!first.booleanValue()) continue;
                if (out.containsKey(key)) {
                    secondPart = out.get(key);
                    secondPart.put(key2, p);
                    continue;
                }
                secondPart = new Hashtable();
                secondPart.put(key2, p);
                out.put(key, secondPart);
            }
        }
    }

    protected Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> findInclusions(Rule r1, int kind) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> resultVector = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticVector = null;
        try {
            criticVector = this.pairContainer.getCriticalSet(kind, r1);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(this, "Cannot get Container"));
            return resultVector;
        }
        int i = 0;
        while (i < criticVector.size()) {
            Graph overlap;
            OrdinaryMorphism overlapIso;
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = criticVector.elementAt(i);
            Pair morphisms = (Pair)p.first;
            if (p.second != null && ((OrdinaryMorphism)morphisms.first).getSource() == r1.getRight() && (overlapIso = (overlap = ((OrdinaryMorphism)morphisms.first).getImage()).isomorphicCopy()) != null) {
                for (Arc arc : ((OrdinaryMorphism)morphisms.first).getSource().getArcsSet()) {
                    if (r1.getInverseImage(arc).hasMoreElements()) continue;
                    try {
                        overlapIso.getTarget().destroyObject(overlapIso.getImage(((OrdinaryMorphism)morphisms.first).getImage(arc)));
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                for (Node node : ((OrdinaryMorphism)morphisms.first).getSource().getNodesSet()) {
                    if (r1.getInverseImage(node).hasMoreElements()) continue;
                    try {
                        overlapIso.getTarget().destroyObject(overlapIso.getImage(((OrdinaryMorphism)morphisms.first).getImage(node)));
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                OrdinaryMorphism ordinaryMorphism = r1.compose((OrdinaryMorphism)morphisms.first).compose(overlapIso);
                Match match1 = BaseFactory.theFactory().makeMatch(r1, ordinaryMorphism);
                morphisms.first = match1;
            }
            Graph overlapGraph = ((OrdinaryMorphism)morphisms.first).getImage();
            OrdinaryMorphism inclusion = BaseFactory.theFactory().createMorphism(overlapGraph, this.getHostGraph());
            boolean graphOk = false;
            while (inclusion.nextCompletion() && !graphOk) {
                if (!inclusion.isTotal() || !inclusion.isInjective()) continue;
                graphOk = true;
                resultVector.addElement(morphisms);
            }
            BaseFactory.theFactory().destroyMorphism(inclusion);
            ++i;
        }
        return resultVector;
    }

    protected boolean isMatchCritic(Match m, Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> inclusions) {
        boolean critic = false;
        OrdinaryMorphism o = null;
        OrdinaryMorphism composed = null;
        int i = 0;
        while (i < inclusions.size()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> morphisms = inclusions.elementAt(i);
            Graph overlapGraph = ((OrdinaryMorphism)morphisms.first).getImage();
            o = BaseFactory.theFactory().createMorphism(overlapGraph, this.getHostGraph());
            OrdinaryMorphism overlapMorph = (OrdinaryMorphism)morphisms.first;
            OrdinaryMorphism inverted = overlapMorph.invert();
            composed = inverted.compose(m);
            while (composed.nextCompletion() && !critic) {
                Vector<GraphObject> leftNodes = new Vector<GraphObject>();
                Enumeration<GraphObject> en = m.getDomain();
                while (en.hasMoreElements()) {
                    GraphObject grob = en.nextElement();
                    if (!grob.isNode()) continue;
                    leftNodes.addElement(grob);
                }
                int k = 0;
                while (k < leftNodes.size()) {
                    Node n = (Node)leftNodes.elementAt(k);
                    try {
                        o.addMapping(overlapMorph.getImage(n), m.getImage(n));
                    }
                    catch (BadMappingException badMappingException) {
                        // empty catch block
                    }
                    ++k;
                }
                while (o.nextCompletion() && !critic) {
                    if (!o.isIsomorphicTo(composed)) continue;
                    critic = true;
                }
            }
            BaseFactory.theFactory().destroyMorphism(composed);
            BaseFactory.theFactory().destroyMorphism(o);
            ++i;
        }
        return critic;
    }

    @Override
    public void run() {
        this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  runs ..."));
        this.parse();
        if (this.stop) {
            this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
            this.stop = false;
        } else {
            this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  finished. Result is " + this.correct + "."));
        }
    }

    public void stop() {
        this.stop = true;
    }

    public boolean wasStopped() {
        return this.stop;
    }
}

