/*
 * Decompiled with CFR 0.152.
 */
package agg.util.csp;

import agg.util.csp.SolutionStrategy;
import agg.util.csp.Variable;
import agg.xt_basis.GraphObject;
import java.util.Enumeration;

public abstract class CSP {
    protected Object itsDomain = null;
    protected Object itsRequester;
    protected SolutionStrategy itsSolver;
    protected boolean itsTouchedFlag;

    public CSP(SolutionStrategy solver) {
        this.setSolutionStrategy(solver);
    }

    public SolutionStrategy getSolutionSolver() {
        return this.itsSolver;
    }

    public abstract Enumeration<Variable> getVariables();

    public abstract Variable getVariable(GraphObject var1);

    public abstract void addObjectNameConstraint(GraphObject var1);

    public abstract void removeObjectNameConstraint(GraphObject var1);

    public abstract int getSize();

    public final void setDomain(Object domain) {
        Enumeration<Variable> en = this.getVariables();
        while (en.hasMoreElements()) {
            en.nextElement().setInstance(null);
        }
        this.itsTouchedFlag = true;
        this.itsDomain = domain;
        this.preprocessDomain(domain);
    }

    public final void setRequester(Object requester) {
        this.itsRequester = requester;
    }

    public final Object getRequester() {
        return this.itsRequester;
    }

    protected abstract void preprocessDomain(Object var1);

    public final Object getDomain() {
        return this.itsDomain;
    }

    public final boolean nextSolution() {
        if (this.itsTouchedFlag) {
            this.itsSolver.reset();
            this.itsTouchedFlag = false;
        }
        return this.itsSolver.next(this);
    }

    public final void setSolutionStrategy(SolutionStrategy solver) {
        this.itsSolver = solver;
        this.itsTouchedFlag = true;
    }

    public boolean hasSolution() {
        return this.itsSolver.hasSolution();
    }

    public boolean hasQueries() {
        return this.itsSolver.hasQueries();
    }

    public final void reset() {
        this.itsSolver.reset();
        this.itsTouchedFlag = false;
    }

    public final void resetQuery_Type() {
        this.itsSolver.resetQuery_Type();
    }

    public final void reinitialize(boolean doUpdateQueries) {
        this.itsSolver.reinitialize(doUpdateQueries);
        this.itsTouchedFlag = false;
    }
}

