/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.convert.ConverterXML;
import agg.util.XMLHelper;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.DefaultGraTraImpl;
import agg.xt_basis.GraGra;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.Graph;
import agg.xt_basis.LayeredGraTraImpl;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.PriorityGraTraImpl;
import agg.xt_basis.RuleSequencesGraTraImpl;
import agg.xt_basis.Version;
import java.io.File;

public class AGGBasicAppl
implements GraTraEventListener {
    private static GraGra gragra;
    private static Graph impGraph;
    private static GraTra gratra;
    static int NN;
    private int msgGraTra;
    private static boolean layered;
    private static boolean ruleSequence;
    private static boolean priority;
    private static boolean didTransformation;
    private static String fileName;
    private static String impFileName;
    private static String outputFileName;
    private static String error;
    private static boolean writeLogFile;
    static XMLHelper h;

    static {
        layered = false;
        ruleSequence = false;
        priority = false;
        didTransformation = false;
        writeLogFile = false;
    }

    public AGGBasicAppl() {
    }

    public AGGBasicAppl(String filename) {
        fileName = filename;
        System.out.println("File name:  " + fileName);
        gragra = AGGBasicAppl.load(fileName);
        if (gragra != null) {
            gragra.getLevelOfTypeGraphCheck();
            AGGBasicAppl.transform(gragra, this);
            if (didTransformation) {
                String out = "_out.ggx";
                AGGBasicAppl.save(gragra, out);
                System.out.println("Output file:  " + outputFileName);
                if (writeLogFile) {
                    if (gratra instanceof DefaultGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((DefaultGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof PriorityGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((PriorityGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof LayeredGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((LayeredGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof RuleSequencesGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((RuleSequencesGraTraImpl)gratra).getProtocolName());
                    }
                }
            } else {
                System.out.println("Grammar:  " + gragra.getName() + "   could not perform any transformations!");
            }
            gratra.dispose();
            BaseFactory.theFactory().destroyGraGra(gragra);
            gragra = null;
            gratra = null;
        } else {
            System.out.println("Grammar:  " + filename + "   FAILED!");
        }
    }

    public AGGBasicAppl(String filename, int nn) {
        NN = nn;
        fileName = filename;
        System.out.println("File name: " + fileName + "   iterations: " + NN);
        gragra = AGGBasicAppl.load(fileName);
        if (gragra != null) {
            gragra.getLevelOfTypeGraphCheck();
            AGGBasicAppl.transform(gragra, this);
            if (didTransformation) {
                String out = "_out.ggx";
                AGGBasicAppl.save(gragra, out);
                System.out.println("Output file:  " + outputFileName);
                if (writeLogFile) {
                    if (gratra instanceof DefaultGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((DefaultGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof PriorityGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((PriorityGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof LayeredGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((LayeredGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof RuleSequencesGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((RuleSequencesGraTraImpl)gratra).getProtocolName());
                    }
                }
            } else {
                System.out.println("Grammar:  " + gragra.getName() + "   could not perform any transformations!");
            }
            gratra.dispose();
            BaseFactory.theFactory().destroyGraGra(gragra);
            gragra = null;
            gratra = null;
        } else {
            System.out.println("Grammar:  " + filename + "   FAILED!");
        }
    }

    public AGGBasicAppl(String filename, String impFilename) {
        fileName = filename;
        impFileName = impFilename;
        System.out.println("File name:  " + fileName);
        gragra = AGGBasicAppl.load(fileName);
        if (gragra != null) {
            int levelOfTGcheck = gragra.getLevelOfTypeGraphCheck();
            System.out.println("Import file name:  " + impFileName);
            impGraph = AGGBasicAppl.importGraph(impFilename);
            if (impGraph != null) {
                gragra.setLevelOfTypeGraphCheck(0);
                if (!gragra.importGraph(impGraph)) {
                    System.out.println("Error:  Import graph has failed! Please check types of the import. ");
                    return;
                }
                System.out.println("Importing graph was successful.");
                if (gragra.getTypeSet().hasInheritance()) {
                    if (levelOfTGcheck != 0) {
                        gragra.setLevelOfTypeGraphCheck(levelOfTGcheck);
                    } else {
                        gragra.setLevelOfTypeGraphCheck(10);
                    }
                } else {
                    gragra.setLevelOfTypeGraphCheck(levelOfTGcheck);
                }
                AGGBasicAppl.save(gragra, "Impot_" + fileName);
                System.out.println("Import is written into:  Impot_" + fileName);
                AGGBasicAppl.transform(gragra, this);
                if (didTransformation) {
                    String out = "_out.ggx";
                    AGGBasicAppl.save(gragra, out);
                    System.out.println("Output file:  " + outputFileName);
                    if (gratra instanceof DefaultGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((DefaultGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof PriorityGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((PriorityGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof LayeredGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((LayeredGraTraImpl)gratra).getProtocolName());
                    } else if (gratra instanceof RuleSequencesGraTraImpl) {
                        System.out.println("Transformation protocol: " + ((RuleSequencesGraTraImpl)gratra).getProtocolName());
                    }
                } else {
                    System.out.println("Grammar:  " + gragra.getName() + "   could not perform any transformations!");
                }
                gratra.dispose();
                BaseFactory.theFactory().destroyGraGra(gragra);
                gragra = null;
                gratra = null;
            } else {
                System.out.println(String.valueOf(impFilename) + "   FAILED! " + error);
            }
        } else {
            System.out.println("Grammar:  " + filename + "   FAILED!");
        }
    }

    public static void main(String[] args) {
        String ver = Version.getID();
        System.out.println(">>> This AGG version 2.1 (and all future versions) \n    is made available under the terms of the Eclipse Public License v1.0 \n    which accompanies this distribution, and is available at \n    http://www.eclipse.org/legal/epl-v10.html.");
        System.out.println(">>> ");
        System.out.println(">>> Java Version " + System.getProperty("java.version"));
        System.out.println(">>> AGG Version " + ver + " runs under JVM 1.6 and higher.");
        if (args.length == 0) {
            AGGBasicAppl.warning();
            return;
        }
        if (args.length == 1) {
            if (args[0].compareToIgnoreCase("-logfile") != 0) {
                new AGGBasicAppl(args[0]);
                writeLogFile = false;
            }
        } else if (args.length == 2) {
            if (args[0].compareToIgnoreCase("-logfile") == 0) {
                writeLogFile = true;
                new AGGBasicAppl(args[1]);
            } else {
                int iters = 0;
                try {
                    iters = Integer.valueOf(args[0]);
                    new AGGBasicAppl(args[1], iters);
                }
                catch (NumberFormatException ex) {
                    try {
                        iters = Integer.valueOf(args[1]);
                        new AGGBasicAppl(args[0], iters);
                    }
                    catch (NumberFormatException ex1) {
                        iters = 0;
                    }
                }
                if (iters == 0) {
                    new AGGBasicAppl(args[0], args[1]);
                }
            }
        } else if (args.length == 3) {
            if (args[0].compareToIgnoreCase("-logfile") == 0) {
                writeLogFile = true;
                new AGGBasicAppl(args[1], args[2]);
            } else {
                AGGBasicAppl.warning();
            }
        }
    }

    static void warning() {
        System.out.println("Usage unaliased: java -oss3m -Xmx1000m agg.xt_basis.AGGBasicAppl [-logfile] grammar [import]");
        System.out.println("Usage aliased:");
        System.out.println("aggengine [-logfile] grammar [import]");
        System.out.println("(aggengine:     aliased to java -oss3m -Xmx1000m agg.xt_basis.AGGBasicAppl)");
        System.out.println("");
        System.out.println("  -logfile \twrite transformation logfile");
        System.out.println("  grammar \tfull file name of  '.ggx'  file in XML format");
        System.out.println("  import\t\tfull file name of a GXL file '.gxl' in XML format \n\t\tthat contains the graph to import.");
        System.out.println("also possible");
        System.out.println("  import\t\tfull file name of an OMONDO XMI file '.ecore' in XML format \n\t\tthat contains the graph to import.");
        System.out.println("");
    }

    public static GraGra load(String fName) {
        if (fName.endsWith(".ggx")) {
            h = new XMLHelper();
            if (h.read_from_xml(fName)) {
                GraGra gra = BaseFactory.theFactory().createGraGra(false);
                h.getTopObject(gra);
                gra.setFileName(fName);
                return gra;
            }
            return null;
        }
        return null;
    }

    public static Graph importGraph(String filename) {
        if (filename.endsWith(".ggx")) {
            return AGGBasicAppl.importGraphGGX(filename);
        }
        if (filename.endsWith(".gxl")) {
            return AGGBasicAppl.importGraphGXL(filename);
        }
        if (filename.endsWith(".gtxl")) {
            return AGGBasicAppl.importGraphGTXL(filename);
        }
        if (filename.endsWith(".ecore")) {
            return AGGBasicAppl.importGraphOMONDO_XMI(filename);
        }
        error = "Import failed!   < " + filename + " >  should be < .ggx > , < .gxl >  or  < .ecore >  file.";
        return null;
    }

    private static Graph importGraphGGX(String filename) {
        GraGra impGra = AGGBasicAppl.load(filename);
        if (impGra != null) {
            return impGra.getGraph();
        }
        return null;
    }

    private static Graph importGraphGTXL(String filename) {
        return null;
    }

    private static Graph importGraphGXL(String filename) {
        String fd = ".";
        String fn = filename;
        String fnOut = "";
        File gxldtd = null;
        File gtsdtd = null;
        File source = null;
        File layout = null;
        error = "";
        File f = new File(fn);
        if (f.exists() && f.isFile()) {
            fd = f.getParent();
        }
        fd = fd != null ? String.valueOf(fd) + File.separator : "." + File.separator;
        ConverterXML converter = new ConverterXML();
        fnOut = String.valueOf(fn.substring(0, fn.length() - 4)) + "_gxl.ggx";
        source = converter.copyFile(fd, "gxl2ggx.xsl");
        gxldtd = converter.copyFile(fd, "gxl.dtd");
        gtsdtd = converter.copyFile(fd, "gts.dtd");
        layout = converter.copyFile(fd, "agglayout.dtd");
        if (source == null) {
            error = "Import is failed! File   < gxl2ggx.xsl >  is not found.";
            return null;
        }
        if (gxldtd == null) {
            error = "Import is failed! File   < gxl.dtd >  is not found.";
            return null;
        }
        if (gtsdtd == null) {
            error = "Import is failed! File   < gts.dtd >  is not found.";
            return null;
        }
        if (layout == null) {
            error = "Import is failed! File   < agglayout.dtd >  is not found.";
            return null;
        }
        String in = fn;
        String out = fnOut;
        GraGra impGra = null;
        if (converter.gxl2ggx(in, out, String.valueOf(fd) + "gxl2ggx.xsl") && out.endsWith(".ggx")) {
            h = new XMLHelper();
            if (h.read_from_xml(out)) {
                impGra = (GraGra)h.getTopObject(BaseFactory.theFactory().createGraGra());
            }
            if (impGra != null) {
                return impGra.getGraph();
            }
        }
        error = "Import is failed! Please check format of the  GXL  file.";
        return null;
    }

    private static Graph importGraphOMONDO_XMI(String filename) {
        String fd = ".";
        String fn = filename;
        String fnOut = "";
        File gxldtd = null;
        File gtsdtd = null;
        File source = null;
        File layout = null;
        File omondo = null;
        error = "";
        File f = new File(fn);
        if (f.exists() && f.isFile()) {
            fd = f.getParent();
        }
        fd = fd != null ? String.valueOf(fd) + File.separator : "." + File.separator;
        ConverterXML converter = new ConverterXML();
        fnOut = String.valueOf(fn.substring(0, fn.length() - 6)) + "_ecore.ggx";
        source = converter.copyFile(fd, "gxl2ggx.xsl");
        gxldtd = converter.copyFile(fd, "gxl.dtd");
        gtsdtd = converter.copyFile(fd, "gts.dtd");
        layout = converter.copyFile(fd, "agglayout.dtd");
        omondo = converter.copyFile(fd, "omondoxmi2gxl.xsl");
        if (source == null) {
            error = "Import failed! File   < gxl2ggx.xsl >  is not found.";
            return null;
        }
        if (gxldtd == null) {
            error = "Import failed! File   < gxl.dtd >  is not found.";
            return null;
        }
        if (gtsdtd == null) {
            error = "Import failed! File   < gts.dtd >  is not found.";
            return null;
        }
        if (layout == null) {
            error = "Import failed! File   < agglayout.dtd >  is not found.";
            return null;
        }
        if (omondo == null) {
            error = "Import failed! File   < omondoxmi2gxl.xsl >  is not found.";
            return null;
        }
        String in = fn;
        String out = fnOut;
        GraGra impGra = null;
        if (converter.omondoxmi2ggx(in, out, String.valueOf(fd) + "omondoxmi2gxl.xsl", String.valueOf(fd) + "gxl2ggx.xsl") && out.endsWith(".ggx")) {
            h = new XMLHelper();
            if (h.read_from_xml(out)) {
                impGra = (GraGra)h.getTopObject(BaseFactory.theFactory().createGraGra());
            }
            if (impGra != null) {
                return impGra.getGraph();
            }
        }
        error = "Import failed! Please check format of the  GXL  file.";
        return null;
    }

    public static void transform(GraGra grammar, GraTraEventListener l) {
        if (grammar == null) {
            return;
        }
        if (grammar.getGraTraOptions().contains("priority")) {
            gratra = new PriorityGraTraImpl();
            priority = true;
            System.out.println("Transformation by rule priority ...");
        } else if (grammar.getGraTraOptions().contains("layered")) {
            gratra = new LayeredGraTraImpl();
            layered = true;
            System.out.println("Layered transformation ...");
        } else if (grammar.getGraTraOptions().contains("ruleSequence")) {
            gratra = new RuleSequencesGraTraImpl();
            ruleSequence = true;
            System.out.println("Transformation by rule sequences ...");
        } else {
            gratra = new DefaultGraTraImpl();
            ((DefaultGraTraImpl)gratra).setMaxOfCounter(NN);
            System.out.println("Transformation  non-deterministically ...");
        }
        gratra.addGraTraListener(l);
        gratra.setGraGra(grammar);
        gratra.setHostGraph(grammar.getGraph());
        gratra.enableWriteLogFile(writeLogFile);
        MorphCompletionStrategy strategy = CompletionStrategySelector.getDefault();
        if (grammar.getGraTraOptions().isEmpty()) {
            grammar.setGraTraOptions(strategy);
            gratra.setCompletionStrategy(strategy);
        } else {
            if (grammar.getGraTraOptions().contains("showGraphAfterStep")) {
                grammar.getGraTraOptions().remove("showGraphAfterStep");
            }
            gratra.setGraTraOptions(grammar.getGraTraOptions());
            System.out.println("Options:  " + grammar.getGraTraOptions());
            System.out.println();
        }
        grammar.destroyAllMatches();
        if (priority) {
            ((PriorityGraTraImpl)gratra).transform();
        } else if (layered) {
            ((LayeredGraTraImpl)gratra).transform();
        } else if (ruleSequence) {
            ((RuleSequencesGraTraImpl)gratra).transform();
        } else {
            ((DefaultGraTraImpl)gratra).transform();
        }
    }

    public static void save(GraGra gra, String outFileName) {
        outputFileName = outFileName.equals("") ? String.valueOf(gra.getName()) + "_out.ggx" : (outFileName.equals("_out.ggx") ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_out.ggx" : (outFileName.indexOf(".ggx") == -1 ? outFileName.concat(".ggx") : (outFileName.equals(fileName) ? String.valueOf(fileName.substring(0, fileName.length() - 4)) + "_out.ggx" : outFileName)));
        if (outputFileName.endsWith(".ggx")) {
            XMLHelper xmlh = new XMLHelper();
            xmlh.addTopObject(gra);
            xmlh.save_to_xml(outputFileName);
        }
    }

    @Override
    public void graTraEventOccurred(GraTraEvent event) {
        this.msgGraTra = event.getMessage();
        if (this.msgGraTra == 5) {
            gratra.stop();
            didTransformation = gratra.transformationDone();
        } else if (this.msgGraTra == 1) {
            System.out.println("GraTraEvent message : PARAMETER NOT SET!");
        }
    }
}

