/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.trans;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.provider.HenshinEditPlugin;

public class GenericReferenceContainerItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    protected boolean forceNoWrapping = false;
    protected EReference reference;
    protected String labelKey;
    protected String imagePath;
    protected EObject target;

    public GenericReferenceContainerItemProvider(AdapterFactory adapterFactory, EObject target, EReference reference, String labelKey, String imagePath) {
        super(adapterFactory);
        target.eAdapters().add((Object)this);
        this.target = target;
        this.reference = reference;
        this.labelKey = labelKey;
        this.imagePath = imagePath;
    }

    protected Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(this.reference);
        }
        return this.childrenFeatures;
    }

    public String getText(Object object) {
        return this.getString(this.labelKey);
    }

    public Object getImage(Object object) {
        return this.imagePath != null ? this.overlayImage(object, this.getResourceLocator().getImage(this.imagePath)) : null;
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        if (!this.reference.getEReferenceType().isAbstract() && !this.reference.getEReferenceType().isInterface()) {
            newChildDescriptors.add(this.createChildParameter(this.reference, this.reference.getEReferenceType().getEPackage().getEFactoryInstance().create(this.reference.getEReferenceType())));
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getFeatureID(this.reference.getEContainingClass().getInstanceClass()) == this.reference.getFeatureID()) {
            this.updateChildren(notification);
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)this, true, false));
            return;
        }
        super.notifyChanged(notification);
    }

    public Collection<?> getChildren(Object object) {
        return super.getChildren((Object)this.target);
    }

    public Object getParent(Object object) {
        return this.target;
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return super.getNewChildDescriptors((Object)this.target, editingDomain, sibling);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner);
    }

    protected Command createWrappedCommand(Command command, final EObject owner) {
        return new CommandWrapper(command){

            public Collection<?> getAffectedObjects() {
                Set<GenericReferenceContainerItemProvider> affected = super.getAffectedObjects();
                if (affected.contains(owner)) {
                    affected = Collections.singleton(GenericReferenceContainerItemProvider.this);
                }
                return affected;
            }
        };
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        if (commandClass != DragAndDropCommand.class) {
            commandParameter.setOwner((Object)this.target);
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinEditPlugin.INSTANCE;
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    public void setForceNoWrapping(boolean forceNoWrapping) {
        this.forceNoWrapping = forceNoWrapping;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (this.forceNoWrapping) {
            return value;
        }
        return new DelegatingWrapperItemProvider(value, (Object)this, feature, index, this.adapterFactory);
    }
}

