/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class RuleMinimizer {
    public static void reduceToMinimalRule(Rule rule) {
        ArrayList<Node> nonContextNodes = new ArrayList<Node>();
        ArrayList<Edge> preserveEdges = new ArrayList<Edge>();
        TreeIterator iterator = rule.eAllContents();
        while (iterator.hasNext()) {
            Edge edge;
            Node node;
            EObject element = (EObject)iterator.next();
            if (element instanceof Node && (node = (Node)element).getActionNode().getAction().getType().equals((Object)Action.Type.PRESERVE) && node.getActionNode() != node) {
                Node lhsNode = node.getActionNode();
                Node rhsNode = node;
                if (!(RuleMinimizer.isNodeWithActionEdges(rhsNode, Action.Type.CREATE) || RuleMinimizer.isNodeWithActionEdges(lhsNode, Action.Type.DELETE) || RuleMinimizer.isNodeWithChangingAttributes(lhsNode, rhsNode))) {
                    nonContextNodes.add(lhsNode);
                    nonContextNodes.add(rhsNode);
                }
            }
            if (!(element instanceof Edge) || !(edge = (Edge)element).getActionEdge().getAction().getType().equals((Object)Action.Type.PRESERVE) || edge.getActionEdge() == edge) continue;
            Edge lhsEdge = edge.getActionEdge();
            Edge rhsEdge = edge;
            preserveEdges.add(lhsEdge);
            preserveEdges.add(rhsEdge);
        }
        for (Edge edge : preserveEdges) {
            RuleMinimizer.deleteEdge(edge);
        }
        for (Node node : nonContextNodes) {
            RuleMinimizer.deleteNode(node);
        }
    }

    private static void deleteNode(Node node) {
        node.getGraph().getRule().getMappings().stream().filter(m -> m.getOrigin() == node || m.getImage() == node).findFirst().ifPresent(m -> EcoreUtil.remove((EObject)m));
        EcoreUtil.remove((EObject)node);
    }

    private static void deleteEdge(Edge edge) {
        EcoreUtil.remove((EObject)edge);
        edge.getSource().getOutgoing().remove((Object)edge);
        edge.getTarget().getIncoming().remove((Object)edge);
    }

    private static boolean isNodeWithActionEdges(Node node, Action.Type actionType) {
        for (Edge edge : node.getIncoming()) {
            if (!edge.getActionEdge().getAction().getType().equals((Object)actionType)) continue;
            return true;
        }
        for (Edge edge : node.getOutgoing()) {
            if (!edge.getActionEdge().getAction().getType().equals((Object)actionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNodeWithChangingAttributes(Node lhsNode, Node rhsNode) {
        for (Attribute lhsAttribute : lhsNode.getAttributes()) {
            Attribute rhsAttribute = rhsNode.getAttribute(lhsAttribute.getType());
            if (rhsAttribute != null && rhsAttribute.getValue().equals(lhsAttribute.getValue())) continue;
            return true;
        }
        for (Attribute rhsAttribute : rhsNode.getAttributes()) {
            Attribute lhsAttribute = lhsNode.getAttribute(rhsAttribute.getType());
            if (lhsAttribute != null && lhsAttribute.getValue().equals(rhsAttribute.getValue())) continue;
            return true;
        }
        return false;
    }
}

