/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.action;

import compactconditionmodel.CompactConditionModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import laxcondition.Condition;
import laxcondition.LaxconditionPackage;
import laxcondition.Variable;
import laxcondition.util.extensions.LaxConditionSimplifier;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.util.extensions.NestedConditionSimplifier;
import nestedconstraintmodel.NestedConstraintModel;
import nestedconstraintmodel.NestedconstraintmodelFactory;
import nestedconstraintmodel.NestedconstraintmodelPackage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.core.Completer;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.TranslatorResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LaxCond2AppCondAction
implements IObjectActionDelegate {
    private static final String COMPACTCONDITION = ".compactconditionmodel";
    private Shell shell;
    private IFile selectedFile = null;
    HashMap<Condition, List<String>> mapCon2Var = null;

    public void run(IAction action) {
        this.mapCon2Var = new HashMap();
        if (this.checkFile()) {
            Cursor oldCursor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getCursor();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setCursor(new Cursor(null, 1));
            URI uri = URI.createPlatformResourceURI((String)this.selectedFile.getFullPath().toString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            Resource resource = resourceSet.getResource(uri, true);
            EObject root = (EObject)resource.getContents().get(0);
            long start = System.currentTimeMillis();
            ArrayList<Condition> arrayListLaxConditions = new ArrayList<Condition>();
            if (root instanceof CompactConditionModel) {
                arrayListLaxConditions.addAll((Collection<Condition>)((CompactConditionModel)root).getCompactconditions());
            }
            System.out.println("arrayListLaxConditions size is: " + arrayListLaxConditions.size());
            for (Condition cond : arrayListLaxConditions) {
                this.mapCon2Var.put(cond, this.getDistinctVariableNames(cond));
            }
            this.simplifyLaxConditions(arrayListLaxConditions);
            List<NestedConstraint> arrayListNestedConstraints = this.completeLaxConditions(this.mapCon2Var, arrayListLaxConditions);
            this.simplifyNestedConstraints(arrayListNestedConstraints);
            long stop = System.currentTimeMillis();
            long translationTime = stop - start;
            System.out.println("[#" + translationTime + ")]");
            NestedconstraintmodelPackage.eINSTANCE.eClass();
            NestedConstraintModel constraintmodel = NestedconstraintmodelFactory.eINSTANCE.createNestedConstraintModel();
            constraintmodel.setName(String.valueOf(arrayListNestedConstraints.get(0).getTypeGraph().getName()) + "Constraints");
            constraintmodel.getNestedconstrainmodels().addAll(arrayListNestedConstraints);
            System.out.println("[# Resulted NGC is:(" + arrayListNestedConstraints.size() + ")]");
            Date date = new GregorianCalendar().getTime();
            this.persistNestedConstraintsModel(date, constraintmodel);
            this.shell.setCursor(oldCursor);
            MessageDialog.openInformation((Shell)this.shell, (String)"OCL2AC", (String)("The translation time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
        }
    }

    private List<String> getDistinctVariableNames(Condition cond) {
        ArrayList<String> varNames = new ArrayList<String>();
        HenshinFactory factory = HenshinFactory.eINSTANCE;
        Rule rule = factory.createRule();
        Parameter param = factory.createParameter("p");
        rule.getParameters().add((Object)param);
        Node sourceLHS = factory.createNode(rule.getLhs(), LaxconditionPackage.Literals.VARIABLE, "");
        sourceLHS.setName(param.getName());
        Node sourceRHS = factory.createNode(rule.getRhs(), LaxconditionPackage.Literals.VARIABLE, "");
        sourceRHS.setName(param.getName());
        Mapping sourceMapping = factory.createMapping(sourceLHS, sourceRHS);
        rule.getMappings().add((Object)sourceMapping);
        HenshinPackage.eINSTANCE.eClass();
        EGraphImpl graph = new EGraphImpl((EObject)cond);
        EngineImpl engine = new EngineImpl(new String[0]);
        List allMatches = InterpreterUtil.findAllMatches((Engine)engine, (Rule)rule, (EGraph)graph, null);
        for (Match m : allMatches) {
            Variable v;
            Object parameterValue = m.getParameterValue(param);
            if (!(parameterValue instanceof Variable) || (v = (Variable)parameterValue).getName() == null || varNames.contains(v.getName())) continue;
            varNames.add(v.getName());
        }
        return varNames;
    }

    private void simplifyNestedConstraints(List<NestedConstraint> arrayListNestedConstraints) {
        for (NestedConstraint nestedconstrain : arrayListNestedConstraints) {
            try {
                NestedConditionSimplifier simplifierNGC = new NestedConditionSimplifier(nestedconstrain);
                simplifierNGC.simplify();
            }
            catch (Exception exception) {
                System.err.println("The nestedconstrain " + nestedconstrain.getName() + " is not simplified well");
            }
        }
    }

    private List<NestedConstraint> completeLaxConditions(HashMap<Condition, List<String>> mapCon2Var, List<Condition> arrayListLaxConditions) {
        ArrayList<NestedConstraint> arrayListNestedConstraints = new ArrayList<NestedConstraint>();
        List<String> conditionVarNames = null;
        for (Condition condition : arrayListLaxConditions) {
            try {
                conditionVarNames = mapCon2Var.get(condition);
                Completer completer = new Completer(condition);
                completer.complete();
                NestedConstraint nestedConstraint = completer.getConstraint();
                NestedCondition nestedCondition = nestedConstraint.getCondition();
                if (conditionVarNames != null) {
                    this.addVariables2Condition(nestedCondition, conditionVarNames);
                }
                arrayListNestedConstraints.add(nestedConstraint);
            }
            catch (Exception exception) {
                System.err.println("The condition " + condition.getName() + " is not completed well");
            }
        }
        return arrayListNestedConstraints;
    }

    private void simplifyLaxConditions(List<Condition> arrayListLaxConditions) {
        for (Condition condition : arrayListLaxConditions) {
            try {
                LaxConditionSimplifier simplifier = new LaxConditionSimplifier(condition);
                simplifier.simplify();
            }
            catch (Exception exception) {
                System.err.println("The condition " + condition.getName() + " is not simplified well");
            }
        }
    }

    private void addVariables2Condition(NestedCondition nestedCondition, List<String> conditionVarNames) {
        for (String v : conditionVarNames) {
            nestedcondition.Variable conVar = NestedconditionFactory.eINSTANCE.createVariable();
            conVar.setName(v);
            if (nestedCondition.getVariables().contains((Object)conVar)) continue;
            nestedCondition.getVariables().add((Object)conVar);
        }
    }

    private void persistNestedConstraintsModel(Date date, NestedConstraintModel nestedConstraintModel) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String path = this.selectedFile.getParent().getLocation().toOSString();
        TranslatorResourceSet resourceSet = new TranslatorResourceSet(path);
        resourceSet.saveEObject((EObject)nestedConstraintModel, nestedConstraintModel.getName().concat("_" + sdf.format(date) + ".nestedconstraintmodel"));
        try {
            this.selectedFile.getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean checkFile() {
        return this.selectedFile.getName().endsWith(COMPACTCONDITION);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection ss;
        Object object;
        if (selection instanceof StructuredSelection && (object = (ss = (StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.selectedFile = (IFile)object;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }
}

