/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.source;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class GeneratedMethodPropertyTester
extends PropertyTester {
    private static final String GEN_SUFFIX = "Gen";
    private static final String PROP_IS_CUSTOMIZABLE_METHOD = "isCustomizableMethod";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IMethod && PROP_IS_CUSTOMIZABLE_METHOD.equals(property)) {
            return Boolean.valueOf(GeneratedMethodPropertyTester.isCustomizableMethod((IMethod)receiver)).equals(expectedValue);
        }
        return false;
    }

    public static boolean isCustomizableMethod(IMethod method) {
        if (method.isReadOnly()) {
            return false;
        }
        IType type = method.getDeclaringType();
        if (type == null) {
            return false;
        }
        String genMethodName = String.valueOf(method.getElementName()) + GEN_SUFFIX;
        IMethod genMethod = type.getMethod(genMethodName, method.getParameterTypes());
        if (genMethod.exists()) {
            return false;
        }
        IMemberAnnotationManager mgr = MintCore.getInstance().getMemberAnnotationManager();
        if (mgr.getCodeGenStatus((IMember)method) == CodeGenStatus.GENERATED) {
            try {
                return type.isClass();
            }
            catch (JavaModelException javaModelException) {}
        }
        return false;
    }
}

