/*******************************************************************************
 * Copyright (c) 2008 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;

public class GenPackageItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays.asList(
			GenModelPackage.Literals.GEN_PACKAGE__GEN_MODEL,
			GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_PACKAGE__PREFIX,
					GenModelPackage.Literals.GEN_PACKAGE__BASE_PACKAGE,
					GenModelPackage.Literals.GEN_PACKAGE__RESOURCE,
					GenModelPackage.Literals.GEN_PACKAGE__ADAPTER_FACTORY,
					GenModelPackage.Literals.GEN_PACKAGE__INTERFACE_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__META_DATA_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__CLASS_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__UTILITY_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__PROVIDER_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__PRESENTATION_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__TESTS_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__GENERATE_EXAMPLE_CLASS,
					GenModelPackage.Literals.GEN_PACKAGE__LITERALS_INTERFACE,
					GenModelPackage.Literals.GEN_PACKAGE__GENERATE_MODEL_WIZARD);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_MODEL = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_MODEL__MODEL_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__EDIT_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__EDITOR_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__TESTS_DIRECTORY);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__ECORE_PACKAGE = Arrays
			.asList((EStructuralFeature) EcorePackage.Literals.ENAMED_ELEMENT__NAME);

	public GenPackageItemProvider(
			GenModelJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenPackage genPackage = (GenPackage) object;
		if (!isFullyResolved(genPackage))
			return Collections.emptyList();

		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genPackage.getGenModel();
		String modelDir = genModel.getModelDirectory();
		String editDir = genModel.getEditDirectory();
		String editorDir = genModel.getEditorDirectory();
		String testsDir = genModel.getTestsDirectory();

		addPackage(modelDir, genPackage.getInterfacePackageName(),
				CAT_INTERFACE,
				Messages.GenPackageItemProvider_InterfacePackageLabel,
				Messages.GenPackageItemProvider_InterfacePackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__INTERFACE_PACKAGE_SUFFIX,
				true, list);
		addPackage(modelDir, genPackage.getReflectionPackageName(),
				CAT_META_DATA,
				Messages.GenPackageItemProvider_MetaDataPackageLabel,
				Messages.GenPackageItemProvider_MetaDataPackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__META_DATA_PACKAGE_SUFFIX,
				true, list);
		addPackage(modelDir, genPackage.getClassPackageName(),
				CAT_IMPLEMENTATION,
				Messages.GenPackageItemProvider_ClassPackageLabel,
				Messages.GenPackageItemProvider_ClassPackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__CLASS_PACKAGE_SUFFIX,
				true, list);
		addPackage(modelDir, genPackage.getUtilitiesPackageName(), CAT_UTILS,
				Messages.GenPackageItemProvider_UtilityPackageLabel,
				Messages.GenPackageItemProvider_UtilityPackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__UTILITY_PACKAGE_SUFFIX,
				true, list);
		if (genPackage.hasClassifiers() && genPackage.isAdapterFactory()
				&& !genPackage.getGenClasses().isEmpty())
			addType(modelDir, genPackage.getQualifiedAdapterFactoryClassName(),
					CAT_UTILS,
					Messages.GenPackageItemProvider_AdapterFactoryLabel,
					Messages.GenPackageItemProvider_AdapterFactoryDescription,
					GenModelPackage.Literals.GEN_PACKAGE__ADAPTER_FACTORY,
					true, list);

		addType(modelDir, genPackage.getQualifiedFactoryClassName(),
				CAT_IMPLEMENTATION,
				Messages.GenPackageItemProvider_FactoryClassLabel,
				Messages.GenPackageItemProvider_FactoryClassDescription, null,
				true, list);
		addType(modelDir, genPackage.getQualifiedFactoryInterfaceName(),
				CAT_INTERFACE,
				Messages.GenPackageItemProvider_FactoryInterfaceLabel,
				Messages.GenPackageItemProvider_FactoryInterfaceDescription,
				null, true, list);
		addType(modelDir, genPackage.getQualifiedPackageClassName(),
				CAT_IMPLEMENTATION,
				Messages.GenPackageItemProvider_PackageClassLabel,
				Messages.GenPackageItemProvider_PackageClassDescription,
				GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE, true, list);
		addType(modelDir, genPackage.getQualifiedPackageInterfaceName(),
				CAT_INTERFACE,
				Messages.GenPackageItemProvider_PackageInterfaceLabel,
				Messages.GenPackageItemProvider_PackageInterfaceDescription,
				GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE, true, list);
		if (genPackage.getResource() != GenResourceKind.NONE_LITERAL) {
			addType(modelDir, genPackage.getQualifiedResourceClassName(),
					CAT_UTILS,
					Messages.GenPackageItemProvider_ResourceClassLabel,
					Messages.GenPackageItemProvider_ResourceClassDescription,
					GenModelPackage.Literals.GEN_PACKAGE__RESOURCE, true, list);
			addType(modelDir,
					genPackage.getQualifiedResourceFactoryClassName(),
					CAT_UTILS,
					Messages.GenPackageItemProvider_ResourceFactoryLabel,
					Messages.GenPackageItemProvider_ResourceFactoryDescription,
					GenModelPackage.Literals.GEN_PACKAGE__RESOURCE, true, list);
		}

		if (genPackage.hasClassifiers() && genPackage.isAdapterFactory()
				&& !genPackage.getGenClasses().isEmpty())
			addType(modelDir, genPackage.getQualifiedSwitchClassName(),
					CAT_UTILS, Messages.GenPackageItemProvider_SwitchLabel,
					Messages.GenPackageItemProvider_SwitchDescription, null,
					true, list);

		if (genPackage.hasClassifiers() && genPackage.hasConstraints())
			addType(modelDir, genPackage.getQualifiedValidatorClassName(),
					CAT_UTILS,
					Messages.GenPackageItemProvider_ValidatorClassLabel,
					Messages.GenPackageItemProvider_ValidatorClassDescription,
					null, true, list);

		if (genPackage.hasClassifiers()
				&& genPackage.getResource().getValue() == GenResourceKind.XML)
			addType(modelDir, genPackage.getQualifiedXMLProcessorClassName(),
					CAT_UTILS,
					Messages.GenPackageItemProvider_XMLProcessorLabel,
					Messages.GenPackageItemProvider_XMLProcessorDescription,
					null, true, list);

		addPackage(editDir, genPackage.getProviderPackageName(), CAT_PROVIDER,
				Messages.GenPackageItemProvider_ProviderPackageLabel,
				Messages.GenPackageItemProvider_ProviderPackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__PROVIDER_PACKAGE_SUFFIX,
				true, list);
		addType(
				editDir,
				genPackage.getQualifiedItemProviderAdapterFactoryClassName(),
				CAT_PROVIDER,
				Messages.GenPackageItemProvider_ItemProviderAdapterFactoryLabel,
				Messages.GenPackageItemProvider_ItemProviderAdapterFactoryDescription,
				null, true, list);

		addPackage(
				editorDir,
				genPackage.getPresentationPackageName(),
				CAT_PRESENTATION,
				Messages.GenPackageItemProvider_PresentationPackageLabel,
				Messages.GenPackageItemProvider_PresentationPackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__PRESENTATION_PACKAGE_SUFFIX,
				true, list);
		addType(
				editorDir,
				genPackage.getQualifiedActionBarContributorClassName(),
				CAT_PRESENTATION,
				Messages.GenPackageItemProvider_ActionBarContributorLabel,
				Messages.GenPackageItemProvider_ActionBarContributorDescription,
				null, true, list);
		addType(editorDir, genPackage.getQualifiedEditorClassName(),
				CAT_PRESENTATION,
				Messages.GenPackageItemProvider_EditorClassLabel,
				Messages.GenPackageItemProvider_EditorClassDescription, null,
				true, list);
		if (genPackage.hasConcreteClasses()
				&& genPackage.isGenerateModelWizard())
			addType(editorDir, genPackage.getQualifiedModelWizardClassName(),
					CAT_PRESENTATION,
					Messages.GenPackageItemProvider_ModelWizardLabel,
					Messages.GenPackageItemProvider_ModelWizardDescription,
					null, true, list);

		addPackage(testsDir, genPackage.getTestsPackageName(), CAT_TEST,
				Messages.GenPackageItemProvider_TestsPackageLabel,
				Messages.GenPackageItemProvider_TestsPackageDescription,
				GenModelPackage.Literals.GEN_PACKAGE__TESTS_PACKAGE_SUFFIX,
				true, list);
		if (genPackage.hasClassifiers() && genPackage.isGenerateExampleClass())
			addType(
					testsDir,
					genPackage.getQualifiedExampleClassName(),
					CAT_TEST,
					Messages.GenPackageItemProvider_ExampleCassLabel,
					Messages.GenPackageItemProvider_ExampleClassDescription,
					GenModelPackage.Literals.GEN_PACKAGE__GENERATE_EXAMPLE_CLASS,
					true, list);

		addType(testsDir, genPackage.getQualifiedTestSuiteClassName(),
				CAT_TEST, Messages.GenPackageItemProvider_TestSuiteLabel,
				Messages.GenPackageItemProvider_TestSuiteDescription, null,
				true, list);

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenPackage(GenPackage object) {
				return GROUP_REFERENCES;
			}
		};
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {

			@Override
			public List<EStructuralFeature> caseGenPackage(GenPackage object) {
				return OBSERVED_FEATURES;
			}

			@Override
			public List<EStructuralFeature> caseGenModel(GenModel object) {
				return OBSERVED_FEATURES__GEN_MODEL;
			}

			@Override
			protected ObservedFeatureEcoreSwitch createObservedFeatureEcoreSwitch() {
				return new ObservedFeatureEcoreSwitch() {
					@Override
					public List<EStructuralFeature> caseEPackage(EPackage object) {
						return OBSERVED_FEATURES__ECORE_PACKAGE;
					}
				};
			}
		};
	}
}
