/*
 * Decompiled with CFR 0.152.
 */
package de.dhuebner.p2.category;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModifyCategory {
    public static final String CONTEN_METADATA_FILENAME = "content";
    public static final String CONTEN_METADATA_XML = "content.xml";
    private static final Map<String, String> idToNameMapping = new HashMap<String, String>();

    static {
        idToNameMapping.put("xtext", "Xtext");
        idToNameMapping.put("xtextHelios", "Xtext");
        idToNameMapping.put("xtend", "Xtend");
        idToNameMapping.put("xtend2", "Xtend");
        idToNameMapping.put("gwt-related", "Xtend");
        idToNameMapping.put("mweHelios-1.0.2", "MWE");
        idToNameMapping.put("mwe2rtHelios-1.0.2", "MWE");
        idToNameMapping.put("mwe2helios-1.0.2", "MWE");
        idToNameMapping.put("mwe", "MWE");
        idToNameMapping.put("mwe2rt", "MWE");
        idToNameMapping.put("mwe2lang", "MWE");
        idToNameMapping.put("Default", "MWE");
        idToNameMapping.put("xpand", "Xpand");
        idToNameMapping.put("file:", "Xpand");
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        if (args == null || args.length == 0) {
            ModifyCategory.exit("No arguments passed");
        }
        ModifyCategory self = new ModifyCategory();
        File folder = new File(args[0]);
        if (!folder.isDirectory()) {
            ModifyCategory.exit(folder + " is not a directory");
        }
        boolean dryRun = true;
        if (args.length > 1) {
            String dryRunArg = args[1];
            dryRun = Boolean.parseBoolean(dryRunArg);
        }
        System.out.println("Dryrun = " + dryRun);
        self.modify(folder, dryRun);
    }

    private static void exit(String string) {
        System.err.println("No arguments passed");
        System.exit(13);
    }

    private void modify(File workingDir, Boolean dryRun) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        File[] fileArray = workingDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                System.out.println("Working with: " + child);
                File contents = new File(child, "content.jar");
                if (!contents.isFile()) {
                    this.modify(child, dryRun);
                } else {
                    InputStream contentXml = this.contentXmlJarEntry(contents);
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    InputStreamReader characterStream = new InputStreamReader(contentXml);
                    InputSource is = new InputSource(characterStream);
                    Document document = documentBuilder.parse(is);
                    NodeList iuElements = document.getElementsByTagName("unit");
                    boolean changed = false;
                    int i = 0;
                    while (i < iuElements.getLength()) {
                        Node unitNode = iuElements.item(i);
                        if (unitNode instanceof Element) {
                            boolean modified = this.modifyCategory((Element)unitNode);
                            changed |= modified;
                        }
                        ++i;
                    }
                    if (changed && !dryRun.booleanValue()) {
                        File file = this.saveDocument(document, child);
                        this.jarFile(child, file);
                        this.deleteIfExists(new File(child, CONTEN_METADATA_XML));
                    }
                    this.deleteIfExists(new File(child, "content2.xml"));
                    this.deleteIfExists(new File(child, "content.xml_modified"));
                }
            }
            ++n2;
        }
    }

    private boolean modifyCategory(Element categoryUnitElement) {
        boolean changed = false;
        NodeList properties = categoryUnitElement.getElementsByTagName("property");
        boolean category = false;
        Node nameProperty = null;
        int j = 0;
        while (j < properties.getLength()) {
            Node property = properties.item(j);
            String name = this.getAttributeValue(property, "name");
            if ("org.eclipse.equinox.p2.type.category".equals(name) && Boolean.parseBoolean(this.getAttributeValue(property, "value"))) {
                category = true;
            } else if ("org.eclipse.equinox.p2.name".equals(name)) {
                nameProperty = property;
            }
            ++j;
        }
        if (category && nameProperty != null) {
            String unitId = this.getAttributeValue(categoryUnitElement, "id");
            System.out.println("Checking category id=" + unitId);
            String newName = null;
            if (idToNameMapping.containsKey(unitId)) {
                newName = idToNameMapping.get(unitId);
            } else {
                for (String key : idToNameMapping.keySet()) {
                    if (!unitId.startsWith(key)) continue;
                    newName = idToNameMapping.get(key);
                }
            }
            if (newName != null) {
                if (!newName.equals(this.getAttributeValue(nameProperty, "value"))) {
                    System.out.println("Setting category name to '" + newName + "'. Old name was '" + this.getAttributeValue(nameProperty, "value") + "'");
                    nameProperty.getAttributes().getNamedItem("value").setNodeValue(newName);
                    this.changeCategoryRequirements(categoryUnitElement);
                    changed = true;
                } else {
                    System.out.println("The category '" + this.getAttributeValue(nameProperty, "value") + "' already has the right name");
                }
            } else {
                System.err.println("No mapping found for category " + unitId);
            }
        }
        return changed;
    }

    private void changeCategoryRequirements(Element categoryUnitElement) {
        NodeList requiredNodes = categoryUnitElement.getElementsByTagName("required");
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int j = 0;
        while (j < requiredNodes.getLength()) {
            Node requiredIU = requiredNodes.item(j);
            String reqUnitId = this.getAttributeValue(requiredIU, "name");
            if (!("org.eclipse.xtend.sdk.feature.group".equals(reqUnitId) || "org.eclipse.xtext.sdk.feature.group".equals(reqUnitId) || "org.eclipse.emf.mwe2.language.sdk.feature.group".equals(reqUnitId) || "org.eclipse.xtext.redist.feature.group".equals(reqUnitId) || "org.eclipse.xtend.gwt.feature.group".equals(reqUnitId))) {
                toRemove.add(requiredIU);
            }
            ++j;
        }
        for (Node node : toRemove) {
            System.out.println("Removing " + this.getAttributeValue(node, "name") + " from " + this.getAttributeValue(categoryUnitElement, "id"));
            node.getParentNode().removeChild(node);
        }
        if (categoryUnitElement.getElementsByTagName("required").getLength() == 0) {
            System.out.println(String.valueOf(this.getAttributeValue(categoryUnitElement, "id")) + "is empty - removing category.");
            categoryUnitElement.getParentNode().removeChild(categoryUnitElement);
        }
    }

    private void jarFile(File destDir, File file) throws IOException {
        int len;
        String target = "content.jar";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(destDir, target)));
        FileInputStream in = new FileInputStream(file);
        out.putNextEntry(new ZipEntry(file.getName()));
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.closeEntry();
        in.close();
        out.close();
        System.out.println("File " + file.getPath() + " jared into " + target);
    }

    private void deleteIfExists(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    private File saveDocument(Document document, File parentDir) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        File file = new File(parentDir, CONTEN_METADATA_XML);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
        System.out.println("File " + file.getPath() + " saved!");
        return file;
    }

    private File extract(File dest, File jarFile) throws IOException, FileNotFoundException {
        InputStream is = this.contentXmlJarEntry(jarFile);
        File f = new File(dest + File.separator + CONTEN_METADATA_XML);
        if (f.exists()) {
            System.out.println("Using existing " + f);
            return f;
        }
        FileOutputStream fos = new FileOutputStream(f);
        while (is.available() > 0) {
            fos.write(is.read());
        }
        fos.close();
        is.close();
        System.out.println("Extracted " + jarFile + " to " + f);
        return f;
    }

    private InputStream contentXmlJarEntry(File jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile);
        ZipEntry entry = jar.getEntry(CONTEN_METADATA_XML);
        return jar.getInputStream(entry);
    }

    private String getAttributeValue(Node node, String name) {
        String result = null;
        Node attrnode = node.getAttributes().getNamedItem(name);
        if (attrnode != null) {
            result = attrnode.getNodeValue();
        }
        return result;
    }
}

