/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.internal.runtime.CompareProgressMonitor;
import org.eclipse.emf.compare.match.EMFCompareMatchMessages;
import org.eclipse.emf.compare.match.engine.IMatchEngine;
import org.eclipse.emf.compare.match.internal.statistic.NameSimilarity;
import org.eclipse.emf.compare.match.internal.statistic.StructureSimilarity;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchFactory;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.compare.match.statistic.MetamodelFilter;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericMatchEngine
implements IMatchEngine {
    private static final double GENERAL_THRESHOLD = 0.96;
    private static final String MATCH_ELEMENT_NAME = "matchedElements";
    private static final int MIN_ATTRIBUTES_COUNT = 5;
    private static final char NAME_SIMILARITY = 'n';
    private static final char RELATION_SIMILARITY = 'r';
    private static final String SUBMATCH_ELEMENT_NAME = "subMatchElements";
    private static final char TYPE_SIMILARITY = 't';
    private static final String UNMATCH_ELEMENT_NAME = "unmatchedElements";
    private static final char VALUE_SIMILARITY = 'v';
    protected final MetamodelFilter filter = new MetamodelFilter();
    protected final Map<String, Object> options = new EMFCompareMap();
    private final Map<String, EObject> matchedByID = new EMFCompareMap();
    private final Map<String, EObject> matchedByXMIID = new EMFCompareMap();
    private final Map<String, Double> metricsCache = new EMFCompareMap();
    private final Set<EObject> remainingUnmatchedElements = new HashSet<EObject>();
    private final List<EObject> stillToFindFromModel1 = new ArrayList<EObject>();
    private final List<EObject> stillToFindFromModel2 = new ArrayList<EObject>();
    private final Map<EObject, Integer> nonNullFeatureCounts = new HashMap<EObject, Integer>(20);

    public GenericMatchEngine() {
        this.options.putAll(this.loadPreferenceOptionMap());
    }

    @Override
    public MatchModel contentMatch(EObject leftObject, EObject rightObject, EObject ancestor, Map<String, Object> optionMap) {
        MatchModel root = MatchFactory.eINSTANCE.createMatchModel();
        this.setModelRoots(root, leftObject.eResource(), rightObject.eResource(), ancestor.eResource());
        CompareProgressMonitor monitor = new CompareProgressMonitor();
        MatchModel leftObjectAncestorMatch = this.contentMatch(leftObject, ancestor, optionMap);
        MatchModel rightObjectAncestorMatch = this.contentMatch(rightObject, ancestor, optionMap);
        ArrayList<MatchElement> leftObjectMatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)leftObjectAncestorMatch.getMatchedElements());
        ArrayList<MatchElement> rightObjectMatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)rightObjectAncestorMatch.getMatchedElements());
        for (Object unmatch : leftObjectAncestorMatch.getUnmatchedElements()) {
            this.remainingUnmatchedElements.add(((UnmatchElement)unmatch).getElement());
        }
        for (Object unmatch : rightObjectAncestorMatch.getUnmatchedElements()) {
            this.remainingUnmatchedElements.add(((UnmatchElement)unmatch).getElement());
        }
        try {
            Match3Elements subMatchRoot = null;
            if (leftObjectMatchedElements.size() > 0 && rightObjectMatchedElements.size() > 0) {
                Match2Elements leftObjectMatchRoot = (Match2Elements)leftObjectMatchedElements.get(0);
                Match2Elements rightObjectMatchRoot = (Match2Elements)rightObjectMatchedElements.get(0);
                subMatchRoot = MatchFactory.eINSTANCE.createMatch3Elements();
                subMatchRoot.setSimilarity(this.absoluteMetric(leftObjectMatchRoot.getLeftElement(), rightObjectMatchRoot.getLeftElement(), rightObjectMatchRoot.getRightElement()));
                subMatchRoot.setLeftElement(leftObjectMatchRoot.getLeftElement());
                subMatchRoot.setRightElement(rightObjectMatchRoot.getLeftElement());
                subMatchRoot.setOriginElement(rightObjectMatchRoot.getRightElement());
                this.redirectedAdd(root, MATCH_ELEMENT_NAME, subMatchRoot);
                this.createSub3Match(root, subMatchRoot, leftObjectMatchRoot, rightObjectMatchRoot);
            } else {
                for (EObject left : leftObjectMatchedElements) {
                    this.stillToFindFromModel1.add(left);
                }
                for (EObject right : rightObjectMatchedElements) {
                    this.stillToFindFromModel2.add(right);
                }
            }
            this.processUnmatchedElements(root, subMatchRoot);
            HashSet<EObject> remainingLeft = new HashSet<EObject>();
            HashSet<EObject> remainingRight = new HashSet<EObject>();
            for (EObject unmatched : this.remainingUnmatchedElements) {
                Object iterator;
                if (unmatched.eResource() == leftObject.eResource()) {
                    remainingLeft.add(unmatched);
                    iterator = unmatched.eAllContents();
                    while (iterator.hasNext()) {
                        remainingLeft.add((EObject)iterator.next());
                    }
                    continue;
                }
                if (unmatched.eResource() != rightObject.eResource()) continue;
                remainingRight.add(unmatched);
                iterator = unmatched.eAllContents();
                while (iterator.hasNext()) {
                    remainingRight.add((EObject)iterator.next());
                }
            }
            this.stillToFindFromModel1.clear();
            this.stillToFindFromModel2.clear();
            List<Match2Elements> mappings = this.mapLists(new ArrayList<EObject>(remainingLeft), new ArrayList<EObject>(remainingRight), (Integer)this.getOption("match.search.window"), monitor);
            for (Match2Elements map : mappings) {
                Match3Elements subMatch = MatchFactory.eINSTANCE.createMatch3Elements();
                subMatch.setLeftElement(map.getLeftElement());
                subMatch.setRightElement(map.getRightElement());
                if (subMatchRoot == null) {
                    this.redirectedAdd(root, MATCH_ELEMENT_NAME, subMatch);
                    continue;
                }
                this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, subMatch);
            }
            EMFCompareMap unmatchedElements = new EMFCompareMap();
            for (EObject unmatch : this.stillToFindFromModel1) {
                unmatchedElements.put(unmatch, false);
                this.createThreeWayUnmatchElements(root, (Map<EObject, Boolean>)unmatchedElements, true);
            }
            unmatchedElements.clear();
            for (EObject remoteUnmatch : this.stillToFindFromModel2) {
                unmatchedElements.put(remoteUnmatch, true);
                this.createThreeWayUnmatchElements(root, (Map<EObject, Boolean>)unmatchedElements, false);
            }
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        catch (InterruptedException interruptedException) {}
        return root;
    }

    @Override
    public MatchModel contentMatch(EObject leftObject, EObject rightObject, Map<String, Object> optionMap) {
        if (optionMap != null && optionMap.size() > 0) {
            this.loadOptionMap(optionMap);
        }
        CompareProgressMonitor monitor = new CompareProgressMonitor();
        MatchModel root = MatchFactory.eINSTANCE.createMatchModel();
        this.setModelRoots(root, leftObject.eResource(), rightObject.eResource());
        HashSet<EObject> still1 = new HashSet<EObject>();
        HashSet<EObject> still2 = new HashSet<EObject>();
        try {
            if (!((Boolean)this.getOption("match.ignore.xmi.id")).booleanValue()) {
                this.matchByXMIID(leftObject, rightObject);
            }
            if (!((Boolean)this.getOption("match.ignore.id")).booleanValue()) {
                this.matchByID(leftObject, rightObject);
            }
            if (this.isSimilar(leftObject, rightObject)) {
                this.stillToFindFromModel1.clear();
                this.stillToFindFromModel2.clear();
                Match2Elements matchModelRoot = this.recursiveMappings(leftObject, rightObject, monitor);
                this.redirectedAdd(root, MATCH_ELEMENT_NAME, matchModelRoot);
                this.createSubMatchElements(matchModelRoot, new ArrayList<EObject>(this.stillToFindFromModel1), new ArrayList<EObject>(this.stillToFindFromModel2), monitor);
                still1.addAll(this.stillToFindFromModel1);
                still2.addAll(this.stillToFindFromModel2);
                this.createUnmatchElements(root, still1, true, false);
                this.createUnmatchElements(root, still2, false, false);
            } else {
                still1.add(leftObject);
                still2.add(rightObject);
                this.createUnmatchElements(root, still1, true, false);
                this.createUnmatchElements(root, still2, false, false);
            }
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        catch (InterruptedException interruptedException) {}
        return root;
    }

    @Override
    public MatchModel modelMatch(EObject leftRoot, EObject rightRoot, EObject ancestor, Map<String, Object> optionMap) throws InterruptedException {
        if (optionMap != null && optionMap.size() > 0) {
            this.loadOptionMap(optionMap);
        }
        MatchModel result = null;
        CompareProgressMonitor monitor = new CompareProgressMonitor(this.getOption("match.progress.monitor"));
        int size = 1;
        for (EObject root : leftRoot.eResource().getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        this.startMonitor(monitor, size << 1);
        result = this.doMatch(leftRoot.eResource(), rightRoot.eResource(), ancestor.eResource(), monitor);
        return result;
    }

    @Override
    public MatchModel modelMatch(EObject leftRoot, EObject rightRoot, Map<String, Object> optionMap) throws InterruptedException {
        if (optionMap != null && optionMap.size() > 0) {
            this.loadOptionMap(optionMap);
        }
        MatchModel result = null;
        CompareProgressMonitor monitor = new CompareProgressMonitor(this.getOption("match.progress.monitor"));
        int size = 1;
        for (EObject root : leftRoot.eResource().getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        this.startMonitor(monitor, size);
        result = this.doMatch(leftRoot.eResource(), rightRoot.eResource(), monitor);
        return result;
    }

    @Override
    public void reset() {
        this.filter.clear();
        this.options.clear();
        this.matchedByID.clear();
        this.matchedByXMIID.clear();
        this.metricsCache.clear();
        this.nonNullFeatureCounts.clear();
        this.remainingUnmatchedElements.clear();
        this.stillToFindFromModel1.clear();
        this.stillToFindFromModel2.clear();
        this.options.putAll(this.loadPreferenceOptionMap());
    }

    @Override
    public MatchModel resourceMatch(Resource leftResource, Resource rightResource, Map<String, Object> optionMap) throws InterruptedException {
        if (optionMap != null && optionMap.size() > 0) {
            this.loadOptionMap(optionMap);
        }
        MatchModel result = null;
        CompareProgressMonitor monitor = new CompareProgressMonitor(this.getOption("match.progress.monitor"));
        int size = 1;
        for (EObject root : leftResource.getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        this.startMonitor(monitor, size);
        result = this.doMatch(leftResource, rightResource, monitor);
        return result;
    }

    @Override
    public MatchModel resourceMatch(Resource leftResource, Resource rightResource, Resource ancestorResource, Map<String, Object> optionMap) throws InterruptedException {
        if (optionMap != null && optionMap.size() > 0) {
            this.loadOptionMap(optionMap);
        }
        MatchModel result = null;
        CompareProgressMonitor monitor = new CompareProgressMonitor(this.getOption("match.progress.monitor"));
        int size = 1;
        for (EObject root : leftResource.getContents()) {
            TreeIterator rootContent = root.eAllContents();
            while (rootContent.hasNext()) {
                rootContent.next();
                ++size;
            }
        }
        this.startMonitor(monitor, size << 1);
        result = this.doMatch(leftResource, rightResource, ancestorResource, monitor);
        return result;
    }

    protected double contentSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 'v');
        if (value == null) {
            value = this.getSimilarityFromCache(obj2, obj1, 'v');
        }
        if (value != null) {
            similarity = value;
        } else if (this.filter.getFilteredFeatures(obj1).size() < 5 || this.filter.getFilteredFeatures(obj2).size() < 5) {
            similarity = NameSimilarity.nameSimilarityMetric(NameSimilarity.contentValue(obj1), NameSimilarity.contentValue(obj2));
            this.setSimilarityInCache(obj1, obj2, 'v', similarity);
        } else {
            similarity = NameSimilarity.nameSimilarityMetric(NameSimilarity.contentValue(obj1, this.filter), NameSimilarity.contentValue(obj2, this.filter));
            this.setSimilarityInCache(obj1, obj2, 'v', similarity);
        }
        return similarity;
    }

    protected EObject findMostSimilar(EObject eObj, List<EObject> list) throws FactoryException {
        double max = 0.0;
        EObject resultObject = null;
        Iterator<EObject> it = list.iterator();
        while (it.hasNext() && max != 1.0) {
            double similarity;
            EObject next = it.next();
            if (!((Boolean)this.getOption("match.distinct.metamodels")).booleanValue() && eObj.eClass() != next.eClass() || !((similarity = this.absoluteMetric(eObj, next)) > max)) continue;
            max = similarity;
            resultObject = next;
        }
        return resultObject;
    }

    protected <T> T getOption(String key) throws ClassCastException {
        return (T)this.options.get(key);
    }

    protected boolean haveDistinctID(EObject left, EObject right) throws FactoryException {
        boolean result = false;
        StringBuilder leftKey = new StringBuilder();
        leftKey.append(NameSimilarity.findName(left));
        leftKey.append(left.hashCode());
        EObject matched = this.matchedByID.get(leftKey.toString());
        result = matched != null ? matched != right : EcoreUtil.getID((EObject)left) != null;
        return result;
    }

    protected boolean haveDistinctXMIID(EObject left, EObject right) throws FactoryException {
        boolean result = false;
        StringBuilder leftKey = new StringBuilder();
        leftKey.append(NameSimilarity.findName(left));
        leftKey.append(left.hashCode());
        EObject matched = this.matchedByXMIID.get(leftKey.toString());
        result = matched != null ? matched != right : left.eResource() instanceof XMIResource && ((XMIResource)left.eResource()).getID(left) != null;
        return result;
    }

    protected boolean isSimilar(EObject obj1, EObject obj2) throws FactoryException {
        boolean similar = false;
        double nameSimilarity = this.nameSimilarity(obj1, obj2);
        boolean hasSameUri = this.hasSameUri(obj1, obj2);
        int obj1NonNullFeatures = this.nonNullFeaturesCount(obj1);
        int obj2NonNullFeatures = this.nonNullFeaturesCount(obj2);
        if (obj1 instanceof EGenericType || obj2 instanceof EGenericType) {
            similar = this.isSimilar(obj1.eContainer(), obj2.eContainer());
        } else if (!((Boolean)this.getOption("match.distinct.metamodels")).booleanValue() && obj1.eClass() != obj2.eClass()) {
            similar = false;
        } else if (!((Boolean)this.getOption("match.ignore.id")).booleanValue() && this.haveDistinctID(obj1, obj2)) {
            similar = false;
        } else if (!((Boolean)this.getOption("match.ignore.xmi.id")).booleanValue() && this.haveDistinctXMIID(obj1, obj2)) {
            similar = false;
        } else if (nameSimilarity == 1.0 && hasSameUri) {
            similar = true;
        } else if (obj1NonNullFeatures == 1 && obj2NonNullFeatures == 1) {
            similar = nameSimilarity > 0.7;
        } else if (nameSimilarity > 0.8 && obj1NonNullFeatures <= 5 && obj2NonNullFeatures <= 5 && this.typeSimilarity(obj1, obj2) > 0.96) {
            similar = true;
        } else {
            double contentSimilarity = this.contentSimilarity(obj1, obj2);
            double relationsSimilarity = this.relationsSimilarity(obj1, obj2);
            if (relationsSimilarity == 1.0 && hasSameUri && nameSimilarity > 0.2) {
                similar = true;
            } else if (contentSimilarity == 1.0 && relationsSimilarity == 1.0) {
                similar = true;
            } else if (contentSimilarity > 0.96 && relationsSimilarity > 0.9 && nameSimilarity > 0.2) {
                similar = true;
            } else if (relationsSimilarity > 0.96 && contentSimilarity > 0.9) {
                similar = true;
            } else if (contentSimilarity > 0.9 && nameSimilarity > 0.9 && relationsSimilarity > 0.9) {
                similar = true;
            } else if (contentSimilarity > 0.96 && nameSimilarity > 0.96 && this.typeSimilarity(obj1, obj2) > 0.96) {
                similar = true;
            }
        }
        return similar;
    }

    protected double nameSimilarity(EObject obj1, EObject obj2) {
        double similarity = 0.0;
        try {
            Double value = this.getSimilarityFromCache(obj1, obj2, 'n');
            if (value != null) {
                similarity = value;
            } else {
                similarity = NameSimilarity.nameSimilarityMetric(NameSimilarity.findName(obj1), NameSimilarity.findName(obj2));
                this.setSimilarityInCache(obj1, obj2, 'n', similarity);
            }
        }
        catch (FactoryException factoryException) {}
        return similarity;
    }

    Map<String, Object> loadPreferenceOptionMap() {
        EMFCompareMap optionMap = new EMFCompareMap(17);
        optionMap.put("match.search.window", this.getPreferenceSearchWindow());
        optionMap.put("match.ignore.id", this.getPreferenceIgnoreID());
        optionMap.put("match.ignore.xmi.id", this.getPreferenceIgnoreXMIID());
        optionMap.put("match.distinct.metamodels", this.getPreferenceDistinctMetaModel());
        optionMap.put("match.progress.monitor", null);
        return optionMap;
    }

    private double absoluteMetric(EObject obj1, EObject obj2) throws FactoryException {
        double nameSimilarity = this.nameSimilarity(obj1, obj2);
        double relationsSimilarity = this.relationsSimilarity(obj1, obj2);
        double sameUri = 0.0;
        if (this.hasSameUri(obj1, obj2)) {
            sameUri = 1.0;
        }
        double positionSimilarity = relationsSimilarity / 2.0 + sameUri / 2.0;
        if (this.nonNullFeaturesCount(obj1) > 5 && this.nonNullFeaturesCount(obj2) > 5) {
            double contentSimilarity = this.contentSimilarity(obj1, obj2);
            return (contentSimilarity * 0.5 + nameSimilarity * 0.4 + positionSimilarity * 0.4) / 1.3;
        }
        return (nameSimilarity * 0.8 + positionSimilarity * 0.2) / 1.0;
    }

    private double absoluteMetric(EObject obj1, EObject obj2, EObject obj3) throws FactoryException {
        double metric1 = this.absoluteMetric(obj1, obj2);
        double metric2 = this.absoluteMetric(obj1, obj3);
        double metric3 = this.absoluteMetric(obj2, obj3);
        return (metric1 + metric2 + metric3) / 3.0;
    }

    private void createSub3Match(MatchModel root, Match3Elements matchElementRoot, Match2Elements left, Match2Elements right) throws FactoryException {
        EList<MatchElement> leftSubMatches = left.getSubMatchElements();
        EList<MatchElement> rightSubMatches = right.getSubMatchElements();
        ArrayList<MatchElement> leftNotFound = new ArrayList<MatchElement>((Collection<MatchElement>)leftSubMatches);
        ArrayList<MatchElement> rightNotFound = new ArrayList<MatchElement>((Collection<MatchElement>)rightSubMatches);
        for (MatchElement nextLeft : leftSubMatches) {
            Match2Elements nextLeftMatch = (Match2Elements)nextLeft;
            Match2Elements correspondingMatch = null;
            for (MatchElement nextRight : rightNotFound) {
                Match2Elements nextRightMatch = (Match2Elements)nextRight;
                if (!nextRightMatch.getRightElement().equals(nextLeftMatch.getRightElement())) continue;
                correspondingMatch = nextRightMatch;
                break;
            }
            if (correspondingMatch == null) continue;
            Match3Elements match = MatchFactory.eINSTANCE.createMatch3Elements();
            match.setSimilarity(this.absoluteMetric(nextLeftMatch.getLeftElement(), correspondingMatch.getLeftElement(), correspondingMatch.getRightElement()));
            match.setLeftElement(nextLeftMatch.getLeftElement());
            match.setRightElement(correspondingMatch.getLeftElement());
            match.setOriginElement(correspondingMatch.getRightElement());
            this.redirectedAdd(matchElementRoot, SUBMATCH_ELEMENT_NAME, match);
            this.createSub3Match(root, matchElementRoot, nextLeftMatch, correspondingMatch);
            leftNotFound.remove(nextLeftMatch);
            rightNotFound.remove(correspondingMatch);
        }
        for (MatchElement nextLeftNotFound : leftNotFound) {
            this.stillToFindFromModel1.add(nextLeftNotFound);
        }
        for (MatchElement nextRightNotFound : rightNotFound) {
            this.stillToFindFromModel2.add(nextRightNotFound);
        }
    }

    private void createSubMatchElements(EObject root, List<EObject> list1, List<EObject> list2, CompareProgressMonitor monitor) throws FactoryException, InterruptedException {
        this.stillToFindFromModel1.clear();
        this.stillToFindFromModel2.clear();
        List<Match2Elements> mappings = this.mapLists(list1, list2, (Integer)this.getOption("match.search.window"), monitor);
        for (Match2Elements map : mappings) {
            Match2Elements match = this.recursiveMappings(map.getLeftElement(), map.getRightElement(), monitor);
            this.redirectedAdd(root, SUBMATCH_ELEMENT_NAME, match);
        }
    }

    private void createThreeWayUnmatchElements(MatchModel root, Map<EObject, Boolean> unmatchedElements, boolean leftSide) throws FactoryException {
        for (Map.Entry<EObject, Boolean> entry : unmatchedElements.entrySet()) {
            if (unmatchedElements.containsKey(entry.getKey().eContainer())) continue;
            UnmatchElement unMap = MatchFactory.eINSTANCE.createUnmatchElement();
            unMap.setElement(entry.getKey());
            if (entry.getValue().booleanValue()) {
                unMap.setRemote(true);
            }
            if (leftSide) {
                unMap.setSide(Side.LEFT);
            } else {
                unMap.setSide(Side.RIGHT);
            }
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unMap);
        }
        unmatchedElements.clear();
    }

    private void createUnmatchElements(MatchModel root, Set<EObject> unmatchedElements, boolean leftSide, boolean remote) throws FactoryException {
        for (EObject element : unmatchedElements) {
            UnmatchElement unMap = MatchFactory.eINSTANCE.createUnmatchElement();
            unMap.setElement(element);
            unMap.setRemote(remote);
            if (leftSide) {
                unMap.setSide(Side.LEFT);
            } else {
                unMap.setSide(Side.RIGHT);
            }
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unMap);
        }
        unmatchedElements.clear();
    }

    private MatchModel doMatch(Resource leftResource, Resource rightResource, CompareProgressMonitor monitor) throws InterruptedException {
        MatchModel root = MatchFactory.eINSTANCE.createMatchModel();
        this.setModelRoots(root, leftResource, rightResource);
        this.filterUnused(leftResource);
        this.filterUnused(rightResource);
        try {
            if (!((Boolean)this.getOption("match.ignore.xmi.id")).booleanValue() && leftResource instanceof XMIResource && rightResource instanceof XMIResource) {
                this.matchByXMIID((XMIResource)leftResource, (XMIResource)rightResource);
            }
            if (!((Boolean)this.getOption("match.ignore.id")).booleanValue()) {
                this.matchByID(leftResource, rightResource);
            }
            monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.roots"));
            List<Match2Elements> matchedRoots = this.mapLists((List<EObject>)leftResource.getContents(), (List<EObject>)rightResource.getContents(), (Integer)this.getOption("match.search.window"), monitor);
            this.stillToFindFromModel1.clear();
            this.stillToFindFromModel2.clear();
            ArrayList<EObject> unmatchedLeftRoots = new ArrayList<EObject>((Collection<EObject>)leftResource.getContents());
            ArrayList<EObject> unmatchedRightRoots = new ArrayList<EObject>((Collection<EObject>)rightResource.getContents());
            HashSet<EObject> still1 = new HashSet<EObject>();
            HashSet<EObject> still2 = new HashSet<EObject>();
            if (leftResource.getContents().size() > 0 && rightResource.getContents().size() > 0) {
                Match2Elements matchModelRoot = MatchFactory.eINSTANCE.createMatch2Elements();
                if (matchedRoots.size() == 0) {
                    Match2Elements rootMapping = MatchFactory.eINSTANCE.createMatch2Elements();
                    rootMapping.setLeftElement((EObject)leftResource.getContents().get(0));
                    EObject rightElement = this.findMostSimilar((EObject)leftResource.getContents().get(0), unmatchedRightRoots);
                    if (rightElement == null) {
                        rightElement = (EObject)unmatchedRightRoots.get(0);
                    }
                    rootMapping.setRightElement(rightElement);
                    matchedRoots.add(rootMapping);
                }
                monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.rootsContents"));
                for (Match2Elements matchedRoot : matchedRoots) {
                    Match2Elements rootMapping = this.recursiveMappings(matchedRoot.getLeftElement(), matchedRoot.getRightElement(), monitor);
                    if (matchModelRoot.getLeftElement() == null) {
                        matchModelRoot = rootMapping;
                        this.redirectedAdd(root, MATCH_ELEMENT_NAME, matchModelRoot);
                    } else {
                        this.redirectedAdd(matchModelRoot, SUBMATCH_ELEMENT_NAME, rootMapping);
                    }
                    still1.removeAll(this.stillToFindFromModel1);
                    still2.removeAll(this.stillToFindFromModel2);
                    this.createSubMatchElements(rootMapping, new ArrayList<EObject>(this.stillToFindFromModel1), new ArrayList<EObject>(this.stillToFindFromModel2), monitor);
                    still1.addAll(this.stillToFindFromModel1);
                    still2.addAll(this.stillToFindFromModel2);
                    unmatchedLeftRoots.remove(matchedRoot.getLeftElement());
                    unmatchedRightRoots.remove(matchedRoot.getRightElement());
                }
                monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.unmatchedRoots"));
                this.createSubMatchElements(matchModelRoot, unmatchedLeftRoots, unmatchedRightRoots, monitor);
            } else {
                still1.addAll(unmatchedLeftRoots);
                still2.addAll(unmatchedRightRoots);
            }
            still1.addAll(this.stillToFindFromModel1);
            still2.addAll(this.stillToFindFromModel2);
            this.createUnmatchElements(root, still1, true, false);
            this.createUnmatchElements(root, still2, false, false);
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        return root;
    }

    private MatchModel doMatch(Resource leftResource, Resource rightResource, Resource ancestorResource, CompareProgressMonitor monitor) throws InterruptedException {
        MatchModel root = MatchFactory.eINSTANCE.createMatchModel();
        this.setModelRoots(root, leftResource, rightResource, ancestorResource);
        MatchModel root1AncestorMatch = this.doMatch(leftResource, ancestorResource, monitor);
        MatchModel root2AncestorMatch = this.doMatch(rightResource, ancestorResource, monitor);
        ArrayList<MatchElement> root1MatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)root1AncestorMatch.getMatchedElements());
        ArrayList<MatchElement> root2MatchedElements = new ArrayList<MatchElement>((Collection<MatchElement>)root2AncestorMatch.getMatchedElements());
        for (Object unmatch : root1AncestorMatch.getUnmatchedElements()) {
            this.remainingUnmatchedElements.add(((UnmatchElement)unmatch).getElement());
        }
        for (Object unmatch : root2AncestorMatch.getUnmatchedElements()) {
            this.remainingUnmatchedElements.add(((UnmatchElement)unmatch).getElement());
        }
        try {
            Match3Elements subMatchRoot = MatchFactory.eINSTANCE.createMatch3Elements();
            if (root2MatchedElements.size() > 0) {
                Match2Elements root1Match = (Match2Elements)root1MatchedElements.get(0);
                Match2Elements root2Match = (Match2Elements)root2MatchedElements.get(0);
                subMatchRoot.setSimilarity(this.absoluteMetric(root1Match.getLeftElement(), root2Match.getLeftElement(), root2Match.getRightElement()));
                subMatchRoot.setLeftElement(root1Match.getLeftElement());
                subMatchRoot.setRightElement(root2Match.getLeftElement());
                subMatchRoot.setOriginElement(root2Match.getRightElement());
                this.redirectedAdd(root, MATCH_ELEMENT_NAME, subMatchRoot);
                this.createSub3Match(root, subMatchRoot, root1Match, root2Match);
            } else if (root1MatchedElements.size() > 0) {
                this.stillToFindFromModel1.add((EObject)root1MatchedElements.get(0));
            }
            this.processUnmatchedElements(root, subMatchRoot);
            HashSet<EObject> remainingLeft = new HashSet<EObject>();
            HashSet<EObject> remainingRight = new HashSet<EObject>();
            for (EObject unmatched : this.remainingUnmatchedElements) {
                Object iterator;
                if (unmatched.eResource() == leftResource) {
                    remainingLeft.add(unmatched);
                    iterator = unmatched.eAllContents();
                    while (iterator.hasNext()) {
                        remainingLeft.add((EObject)iterator.next());
                    }
                    continue;
                }
                if (unmatched.eResource() != rightResource) continue;
                remainingRight.add(unmatched);
                iterator = unmatched.eAllContents();
                while (iterator.hasNext()) {
                    remainingRight.add((EObject)iterator.next());
                }
            }
            this.stillToFindFromModel1.clear();
            this.stillToFindFromModel2.clear();
            List<Match2Elements> mappings = this.mapLists(new ArrayList<EObject>(remainingLeft), new ArrayList<EObject>(remainingRight), (Integer)this.getOption("match.search.window"), monitor);
            for (Match2Elements map : mappings) {
                Match3Elements subMatch = MatchFactory.eINSTANCE.createMatch3Elements();
                subMatch.setLeftElement(map.getLeftElement());
                subMatch.setRightElement(map.getRightElement());
                this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, subMatch);
            }
            EMFCompareMap unmatchedElements = new EMFCompareMap();
            for (EObject unmatch : this.stillToFindFromModel1) {
                unmatchedElements.put(unmatch, false);
                this.createThreeWayUnmatchElements(root, (Map<EObject, Boolean>)unmatchedElements, true);
            }
            unmatchedElements.clear();
            for (EObject remoteUnmatch : this.stillToFindFromModel2) {
                unmatchedElements.put(remoteUnmatch, true);
                this.createThreeWayUnmatchElements(root, (Map<EObject, Boolean>)unmatchedElements, false);
            }
        }
        catch (FactoryException e) {
            EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
        }
        return root;
    }

    private void filterUnused(Resource resource) {
        for (EObject root : resource.getContents()) {
            this.filter.analyseModel(root);
        }
    }

    private List<EObject> getContents(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>((Collection<EObject>)eObject.eContents());
        for (EReference reference : eObject.eClass().getEAllReferences()) {
            if (!reference.isContainment() || !reference.isDerived()) continue;
            Object value = eObject.eGet((EStructuralFeature)reference);
            if (value instanceof Collection) {
                for (Object newValue : (Collection)value) {
                    if (result.contains(newValue) || !(newValue instanceof EObject)) continue;
                    result.add((EObject)newValue);
                }
                continue;
            }
            if (!(value instanceof EObject)) continue;
            result.add((EObject)value);
        }
        return result;
    }

    private boolean getPreferenceDistinctMetaModel() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null) {
            return EMFComparePlugin.getDefault().getBoolean("emfcompare.distinct.metamodel");
        }
        return false;
    }

    private boolean getPreferenceIgnoreID() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null) {
            return EMFComparePlugin.getDefault().getBoolean("emfcompare.ignore.ID");
        }
        return false;
    }

    private boolean getPreferenceIgnoreXMIID() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null) {
            return EMFComparePlugin.getDefault().getBoolean("emfcompare.ignore.XMI.ID");
        }
        return false;
    }

    private int getPreferenceSearchWindow() {
        int searchWindow = 100;
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault() != null && EMFComparePlugin.getDefault().getInt("emfcompare.search.window") > 0) {
            searchWindow = EMFComparePlugin.getDefault().getInt("emfcompare.search.window");
        }
        if (searchWindow < 0) {
            searchWindow = 0;
        }
        return searchWindow;
    }

    private Double getSimilarityFromCache(EObject obj1, EObject obj2, char similarityKind) {
        return this.metricsCache.get(this.pairHashCode(obj1, obj2, similarityKind));
    }

    private boolean hasSameUri(EObject obj1, EObject obj2) {
        if (obj1.eResource() != null && obj2.eResource() != null) {
            return obj1.eResource().getURIFragment(obj1).equals(obj2.eResource().getURIFragment(obj2));
        }
        return false;
    }

    private void loadOptionMap(Map<String, Object> map) {
        this.options.putAll(map);
        if ((Integer)this.getOption("match.search.window") < 0) {
            this.options.put("match.search.window", this.getPreferenceSearchWindow());
        }
    }

    private List<Match2Elements> mapLists(List<EObject> list1, List<EObject> list2, int window, CompareProgressMonitor monitor) throws FactoryException, InterruptedException {
        ArrayList<Match2Elements> result = new ArrayList<Match2Elements>();
        int curIndex = 0 - window / 2;
        ArrayList<EObject> notFoundList1 = new ArrayList<EObject>(list1);
        ArrayList<EObject> notFoundList2 = new ArrayList<EObject>(list2);
        Iterator<EObject> it1 = list1.iterator();
        while (it1.hasNext() && notFoundList2.size() > 0) {
            EObject obj1 = it1.next();
            StringBuilder obj1Key = new StringBuilder();
            obj1Key.append(NameSimilarity.findName(obj1));
            obj1Key.append(obj1.hashCode());
            EObject obj2 = this.matchedByID.get(obj1Key.toString());
            if (obj2 == null) {
                EObject obj1Check;
                int end = Math.min(curIndex + window - (list2.size() - notFoundList2.size()), notFoundList2.size());
                int index = Math.min(Math.max(curIndex - (list2.size() - notFoundList2.size()), 0), end);
                obj2 = this.findMostSimilar(obj1, notFoundList2.subList(index, end));
                if (obj2 != null && (obj1Check = this.findMostSimilar(obj2, notFoundList1)) != obj1 && obj1Check != null && this.isSimilar(obj1Check, obj2)) continue;
            }
            if (notFoundList1.contains(obj1) && notFoundList2.contains(obj2) && this.isSimilar(obj1, obj2)) {
                Match2Elements mapping = MatchFactory.eINSTANCE.createMatch2Elements();
                double metric = this.absoluteMetric(obj1, obj2);
                mapping.setLeftElement(obj1);
                mapping.setRightElement(obj2);
                mapping.setSimilarity(metric);
                result.add(mapping);
                notFoundList1.remove(obj1);
                notFoundList2.remove(obj2);
            }
            ++curIndex;
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        this.stillToFindFromModel1.addAll(notFoundList1);
        this.stillToFindFromModel2.addAll(notFoundList2);
        return result;
    }

    private void matchByID(EObject obj1, EObject obj2) throws FactoryException {
        this.matchedByID.clear();
        TreeIterator iterator1 = obj1.eAllContents();
        block0: while (iterator1.hasNext()) {
            EObject item1 = (EObject)iterator1.next();
            String item1ID = EcoreUtil.getID((EObject)item1);
            if (item1ID == null) continue;
            TreeIterator iterator2 = obj2.eAllContents();
            while (iterator2.hasNext()) {
                EObject item2 = (EObject)iterator2.next();
                String item2ID = EcoreUtil.getID((EObject)item2);
                if (item2 == null || !item1ID.equals(item2ID)) continue;
                StringBuilder item1Key = new StringBuilder();
                item1Key.append(NameSimilarity.findName(item1));
                item1Key.append(item1.hashCode());
                this.matchedByID.put(item1Key.toString(), item2);
                continue block0;
            }
        }
    }

    private void matchByID(Resource left, Resource right) throws FactoryException {
        this.matchedByID.clear();
        TreeIterator leftIterator = left.getAllContents();
        block0: while (leftIterator.hasNext()) {
            EObject item1 = (EObject)leftIterator.next();
            String item1ID = EcoreUtil.getID((EObject)item1);
            if (item1ID == null) continue;
            TreeIterator rightIterator = right.getAllContents();
            while (rightIterator.hasNext()) {
                EObject item2 = (EObject)rightIterator.next();
                String item2ID = EcoreUtil.getID((EObject)item2);
                if (item2 == null || !item1ID.equals(item2ID)) continue;
                StringBuilder item1Key = new StringBuilder();
                item1Key.append(NameSimilarity.findName(item1));
                item1Key.append(item1.hashCode());
                this.matchedByID.put(item1Key.toString(), item2);
                continue block0;
            }
        }
    }

    private void matchByXMIID(EObject obj1, EObject obj2) throws FactoryException {
        this.matchedByXMIID.clear();
        if (obj1 != null && obj2 != null && obj1.eResource() instanceof XMIResource && obj2.eResource() instanceof XMIResource) {
            XMIResource left = (XMIResource)obj1.eResource();
            XMIResource right = (XMIResource)obj2.eResource();
            TreeIterator iterator = obj1.eAllContents();
            while (iterator.hasNext()) {
                EObject item2;
                EObject item1 = (EObject)iterator.next();
                String item1ID = left.getID(item1);
                if (item1ID == null || (item2 = right.getEObject(item1ID)) == null) continue;
                StringBuilder item1Key = new StringBuilder();
                item1Key.append(NameSimilarity.findName(item1));
                item1Key.append(item1.hashCode());
                this.matchedByXMIID.put(item1Key.toString(), item2);
            }
        }
    }

    private void matchByXMIID(XMIResource left, XMIResource right) throws FactoryException {
        this.matchedByXMIID.clear();
        TreeIterator leftIterator = left.getAllContents();
        while (leftIterator.hasNext()) {
            EObject item2;
            EObject item1 = (EObject)leftIterator.next();
            String item1ID = left.getID(item1);
            if (item1ID == null || (item2 = right.getEObject(item1ID)) == null) continue;
            StringBuilder item1Key = new StringBuilder();
            item1Key.append(NameSimilarity.findName(item1));
            item1Key.append(item1.hashCode());
            this.matchedByXMIID.put(item1Key.toString(), item2);
        }
    }

    private int nonNullFeaturesCount(EObject eobj) {
        Integer nonNullFeatures = this.nonNullFeatureCounts.get(eobj);
        if (nonNullFeatures == null) {
            int count = 0;
            for (EStructuralFeature feature : eobj.eClass().getEAllStructuralFeatures()) {
                if (eobj.eGet(feature) == null || "".equals(eobj.eGet(feature).toString())) continue;
                ++count;
            }
            nonNullFeatures = count;
            this.nonNullFeatureCounts.put(eobj, nonNullFeatures);
        }
        return nonNullFeatures;
    }

    private String pairHashCode(EObject obj1, EObject obj2, char similarityKind) {
        if (similarityKind == 'n' || similarityKind == 't' || similarityKind == 'v' || similarityKind == 'r') {
            StringBuilder hash = new StringBuilder();
            hash.append(similarityKind).append(obj1.hashCode()).append(obj2.hashCode());
            return hash.toString();
        }
        throw new IllegalArgumentException(EMFCompareMatchMessages.getString("DifferencesServices.illegalSimilarityKind", Character.valueOf(similarityKind)));
    }

    private void processUnmatchedElements(MatchModel root, Match3Elements subMatchRoot) throws FactoryException {
        UnmatchElement unmatch;
        for (EObject obj1 : new ArrayList<EObject>(this.stillToFindFromModel1)) {
            boolean matchFound = false;
            if (!(obj1 instanceof Match2Elements)) continue;
            Match2Elements match1 = (Match2Elements)obj1;
            for (EObject obj2 : new ArrayList<EObject>(this.stillToFindFromModel2)) {
                if (!(obj2 instanceof Match2Elements)) continue;
                Match2Elements match2 = (Match2Elements)obj2;
                if (match1.getRightElement() != match2.getRightElement()) continue;
                matchFound = true;
                Match3Elements match = MatchFactory.eINSTANCE.createMatch3Elements();
                match.setSimilarity(this.absoluteMetric(match1.getLeftElement(), match2.getLeftElement(), match2.getRightElement()));
                match.setLeftElement(match1.getLeftElement());
                match.setRightElement(match2.getLeftElement());
                match.setOriginElement(match2.getRightElement());
                if (subMatchRoot == null) {
                    this.redirectedAdd(root, MATCH_ELEMENT_NAME, match);
                    this.createSub3Match(root, match, match1, match2);
                } else {
                    this.redirectedAdd(subMatchRoot, SUBMATCH_ELEMENT_NAME, match);
                    this.createSub3Match(root, subMatchRoot, match1, match2);
                }
                this.stillToFindFromModel1.remove(match1);
                this.stillToFindFromModel2.remove(match2);
            }
            if (matchFound) continue;
            this.remainingUnmatchedElements.add(match1.getLeftElement());
        }
        for (EObject eObj : new ArrayList<EObject>(this.stillToFindFromModel1)) {
            if (!(eObj instanceof Match2Elements)) continue;
            Match2Elements nextRightNotFound = (Match2Elements)eObj;
            unmatch = MatchFactory.eINSTANCE.createUnmatchElement();
            unmatch.setElement(nextRightNotFound.getLeftElement());
            unmatch.setSide(Side.LEFT);
            unmatch.setRemote(true);
            this.remainingUnmatchedElements.remove(nextRightNotFound.getLeftElement());
            this.remainingUnmatchedElements.remove(nextRightNotFound.getRightElement());
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unmatch);
        }
        for (EObject eObj : new ArrayList<EObject>(this.stillToFindFromModel2)) {
            if (!(eObj instanceof Match2Elements)) continue;
            Match2Elements nextLeftNotFound = (Match2Elements)eObj;
            unmatch = MatchFactory.eINSTANCE.createUnmatchElement();
            unmatch.setElement(nextLeftNotFound.getLeftElement());
            unmatch.setSide(Side.RIGHT);
            this.remainingUnmatchedElements.remove(nextLeftNotFound.getLeftElement());
            this.remainingUnmatchedElements.remove(nextLeftNotFound.getRightElement());
            this.redirectedAdd(root, UNMATCH_ELEMENT_NAME, unmatch);
        }
    }

    private Match2Elements recursiveMappings(EObject current1, EObject current2, CompareProgressMonitor monitor) throws FactoryException, InterruptedException {
        Match2Elements mapping = null;
        mapping = MatchFactory.eINSTANCE.createMatch2Elements();
        mapping.setLeftElement(current1);
        mapping.setRightElement(current2);
        mapping.setSimilarity(this.absoluteMetric(current1, current2));
        List<Match2Elements> mapList = this.mapLists(this.getContents(current1), this.getContents(current2), (Integer)this.getOption("match.search.window"), monitor);
        for (Match2Elements subMapping : mapList) {
            EFactory.eAdd((EObject)mapping, (String)SUBMATCH_ELEMENT_NAME, (Object)this.recursiveMappings(subMapping.getLeftElement(), subMapping.getRightElement(), monitor));
        }
        return mapping;
    }

    private void redirectedAdd(EObject object, String name, Object value) throws FactoryException {
        EFactory.eAdd((EObject)object, (String)name, (Object)value);
    }

    private double relationsSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 'r');
        if (value != null) {
            similarity = value;
        } else {
            similarity = StructureSimilarity.relationsSimilarityMetric(obj1, obj2, this.filter);
            this.setSimilarityInCache(obj1, obj2, 'r', similarity);
        }
        return similarity;
    }

    private void setModelRoots(MatchModel modelRoot, Resource left, Resource right) {
        this.setModelRoots(modelRoot, left, right, null);
    }

    private void setModelRoots(MatchModel modelRoot, Resource left, Resource right, Resource ancestor) {
        if (left != null) {
            modelRoot.getLeftRoots().addAll((Collection)left.getContents());
        }
        if (right != null) {
            modelRoot.getRightRoots().addAll((Collection)right.getContents());
        }
        if (ancestor != null) {
            modelRoot.getAncestorRoots().addAll((Collection)ancestor.getContents());
        }
    }

    private void setSimilarityInCache(EObject obj1, EObject obj2, char similarityKind, double similarity) {
        this.metricsCache.put(this.pairHashCode(obj1, obj2, similarityKind), new Double(similarity));
    }

    private void startMonitor(CompareProgressMonitor monitor, int size) {
        monitor.beginTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.task"), size);
        monitor.subTask(EMFCompareMatchMessages.getString("DifferencesServices.monitor.browsing"));
    }

    private double typeSimilarity(EObject obj1, EObject obj2) throws FactoryException {
        double similarity = 0.0;
        Double value = this.getSimilarityFromCache(obj1, obj2, 't');
        if (value != null) {
            similarity = value;
        } else {
            similarity = StructureSimilarity.typeSimilarityMetric(obj1, obj2);
            this.setSimilarityInCache(obj1, obj2, 't', similarity);
        }
        return similarity;
    }
}

