/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.ast.util;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.internal.core.Workflow;
import org.eclipse.emf.mwe.internal.core.ast.AbstractASTBase;
import org.eclipse.emf.mwe.internal.core.ast.ComponentAST;
import org.eclipse.emf.mwe.internal.core.ast.SimpleParamAST;
import org.eclipse.emf.mwe.internal.core.ast.parser.WorkflowParser;
import org.eclipse.emf.mwe.internal.core.ast.util.VisitorAnalyzer;
import org.eclipse.emf.mwe.internal.core.ast.util.VisitorCreator;
import org.eclipse.emf.mwe.internal.core.ast.util.VisitorInitializer;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowContainer;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.BooleanConverter;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.Converter;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.FileConverter;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.IntegerConverter;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.StringArrayConverter;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.StringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowFactory {
    private final ResourceLoader loader = ResourceLoaderFactory.createResourceLoader();

    public Workflow parseInitAndCreate(String fileName, Map<String, String> params, Map<Class<?>, Converter> converter, Issues issues) {
        InputStream in = this.loader.getResourceAsStream(fileName);
        if (in == null) {
            throw new IllegalArgumentException("Couldn't load file " + fileName);
        }
        return this.parseInitAndCreate(in, fileName, params, converter, issues);
    }

    public Workflow parseInitAndCreate(InputStream in, String resourceName, Map<String, String> params, Map<Class<?>, Converter> converters, Issues issues) {
        AbstractASTBase wfast = this.parseAndInitialize(in, resourceName, issues, params);
        if (this.isAbstract(wfast)) {
            issues.clear();
            issues.addError("This workflow file is abstract and cannot be run directly. It must be called from another workflow, passing in the required parameters.");
            return null;
        }
        if (issues.hasErrors()) {
            return null;
        }
        WorkflowContainer wc = new WorkflowContainer();
        wfast.accept(new VisitorAnalyzer(issues, converters, wc.getClass()));
        if (issues.hasErrors()) {
            return null;
        }
        wfast.accept(new VisitorCreator(issues, converters, wc));
        Workflow wfRoot = (Workflow)wc.getRoot();
        return wfRoot;
    }

    private boolean isAbstract(AbstractASTBase wfast) {
        if (wfast instanceof ComponentAST) {
            ComponentAST ca = (ComponentAST)wfast;
            for (AbstractASTBase child : ca.getChildren()) {
                SimpleParamAST spa;
                if (!(child instanceof SimpleParamAST) || !(spa = (SimpleParamAST)child).getName().toLowerCase().equals("abstract") || !spa.getValue().toLowerCase().equals("true")) continue;
                return true;
            }
        }
        return false;
    }

    public AbstractASTBase parseAndInitialize(String uri, Issues issues, Map<String, String> properties) {
        InputStream in = this.loader.getResourceAsStream(uri);
        if (in == null) {
            issues.addError("Couldn't find resource '" + uri + "'", null);
            return null;
        }
        return this.parseAndInitialize(in, uri, issues, properties);
    }

    public AbstractASTBase parseAndInitialize(InputStream in, String resourceName, Issues issues, Map<String, String> properties) {
        WorkflowParser wp = new WorkflowParser();
        AbstractASTBase wfast = wp.parse(in, resourceName, issues);
        if (wfast != null) {
            VisitorInitializer pr = new VisitorInitializer(issues, properties, new HashMap<String, ComponentAST>());
            wfast.accept(pr);
        }
        return wfast;
    }

    public Set<?> parseInitAndAnalyze(InputStream in, String resourceName, Issues issues, Map<String, String> properties, Map<Class<?>, Converter> converter) {
        AbstractASTBase wf = this.parseAndInitialize(in, resourceName, issues, properties);
        Map<Class<?>, Converter> conv = WorkflowFactory.getDefaultConverter();
        conv.putAll(converter);
        VisitorAnalyzer visitor = new VisitorAnalyzer(issues, conv, WorkflowContainer.class);
        return (Set)wf.accept(visitor);
    }

    public static Map<Class<?>, Converter> getDefaultConverter() {
        HashMap m = new HashMap();
        m.put(Object.class, new StringConverter());
        m.put(String.class, new StringConverter());
        m.put(Boolean.class, new BooleanConverter());
        m.put(Boolean.TYPE, new BooleanConverter());
        m.put(Integer.class, new IntegerConverter());
        m.put(Integer.TYPE, new IntegerConverter());
        m.put(String[].class, new StringArrayConverter());
        m.put(File.class, new FileConverter());
        return m;
    }
}

