/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.cdo.client.AttributeConverter;
import org.eclipse.emf.cdo.client.MappingProvider;
import org.eclipse.emf.cdo.core.CDODataTypes;
import org.eclipse.emf.cdo.core.UnknownDataTypeException;
import org.eclipse.emf.cdo.mapping.AttributeMapping;
import org.eclipse.emf.cdo.mapping.ClassMapping;
import org.eclipse.emf.cdo.mapping.MappingFactory;
import org.eclipse.emf.cdo.mapping.PackageMapping;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringHelper;

public class AnnotationMappingProviderImpl
implements MappingProvider,
CDODataTypes {
    public static final String ANNOTATION_SOURCE = "cdo";
    private static final String KEY_PERSISTENT = "persistent";
    private static final String KEY_TABLE_NAME = "tableName";
    private static final String KEY_COLUMN_NAME = "columnName";
    private static final String KEY_COLUMN_TYPE = "columnType";
    protected EPackage ePackage;
    protected PackageMapping mappingModel;
    protected boolean autoPersistent;
    protected AttributeConverter attributeConverter;

    public boolean getAutoPersistent() {
        return this.autoPersistent;
    }

    public AnnotationMappingProviderImpl(EPackage ePackage, boolean autoPersistent, AttributeConverter attributeConverter) {
        this.ePackage = ePackage;
        this.autoPersistent = autoPersistent;
        this.attributeConverter = attributeConverter;
        this.mappingModel = this.createPackageMapping();
    }

    public PackageMapping getPackageMapping() {
        return this.mappingModel;
    }

    public ClassMapping getClassMapping(String className) {
        try {
            EClass eClass = this.getEClass(className);
            ClassMapping result = this.createClassMapping(eClass, this.getAutoPersistent());
            return result;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public AttributeMapping getAttributeMapping(String className, String attributeName) {
        try {
            EAttribute eAttribute = this.getEAttribute(className, attributeName);
            AttributeMapping result = this.createAttributeMapping(eAttribute, this.getAutoPersistent());
            return result;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    protected EClass getEClass(String className) {
        EClassifier result = this.ePackage.getEClassifier(className);
        if (result == null) {
            throw new NoSuchElementException("package " + this.ePackage.getName() + " does not contain classifier " + className);
        }
        if (result instanceof EClass) {
            return (EClass)result;
        }
        throw new NoSuchElementException("classifier " + className + " is not a class");
    }

    protected EAttribute getEAttribute(String className, String attributeName) {
        EClass eClass = this.getEClass(className);
        EStructuralFeature result = eClass.getEStructuralFeature(attributeName);
        if (result == null) {
            throw new NoSuchElementException("package " + this.ePackage.getName() + " does not contain attribute " + className + "." + attributeName);
        }
        if (result instanceof EAttribute) {
            return (EAttribute)result;
        }
        throw new NoSuchElementException("structural feature " + className + "." + attributeName + " is not an attribute");
    }

    protected AttributeMapping createAttributeMapping(EAttribute eAttribute, boolean autoPersistentToUse) {
        boolean persistent = AnnotationMappingProviderImpl.getBooleanAnnotation((EModelElement)eAttribute, KEY_PERSISTENT, autoPersistentToUse);
        if (!persistent) {
            return null;
        }
        String attributeName = eAttribute.getName();
        String defaultColumnName = AnnotationMappingProviderImpl.sqlIdentifier(attributeName);
        String columnName = AnnotationMappingProviderImpl.getAnnotation((EModelElement)eAttribute, KEY_COLUMN_NAME, defaultColumnName);
        int defaultColumnType = AnnotationMappingProviderImpl.getDefaultColumnType(eAttribute, this.attributeConverter);
        int columnType = AnnotationMappingProviderImpl.getIntAnnotation((EModelElement)eAttribute, KEY_COLUMN_TYPE, defaultColumnType);
        AttributeMapping attributeMapping = MappingFactory.eINSTANCE.createAttributeMapping();
        attributeMapping.setAttributeName(attributeName);
        attributeMapping.setColumnName(columnName);
        attributeMapping.setColumnType(columnType);
        return attributeMapping;
    }

    protected ClassMapping createClassMapping(EClass eClass, boolean autoPersistentToUse) {
        boolean persistent = AnnotationMappingProviderImpl.getBooleanAnnotation((EModelElement)eClass, KEY_PERSISTENT, autoPersistentToUse);
        if (!persistent) {
            return null;
        }
        String className = eClass.getName();
        String defaultTableName = AnnotationMappingProviderImpl.sqlIdentifier(className);
        String tableName = AnnotationMappingProviderImpl.getAnnotation((EModelElement)eClass, KEY_TABLE_NAME, defaultTableName);
        ClassMapping classMapping = MappingFactory.eINSTANCE.createClassMapping();
        classMapping.setClassName(className);
        classMapping.setTableName(tableName);
        EList attributes = eClass.getEAllAttributes();
        for (EAttribute attribute : attributes) {
            AttributeMapping attributeMapping = this.createAttributeMapping(attribute, persistent);
            classMapping.getAttributes().add((Object)attributeMapping);
        }
        return classMapping;
    }

    protected PackageMapping createPackageMapping() {
        PackageMapping packageMapping = MappingFactory.eINSTANCE.createPackageMapping();
        packageMapping.setPackageName(this.ePackage.getName());
        EList classifiers = this.ePackage.getEClassifiers();
        for (EClassifier classifier : classifiers) {
            EClass eClass;
            ClassMapping classMapping;
            if (!(classifier instanceof EClass) || (classMapping = this.createClassMapping(eClass = (EClass)classifier, this.autoPersistent)) == null) continue;
            packageMapping.getClasses().add((Object)classMapping);
        }
        return packageMapping;
    }

    public static String getAnnotation(EModelElement element, String key, String defaultValue) {
        EMap details;
        EAnnotation annotation = element.getEAnnotation(ANNOTATION_SOURCE);
        if (annotation != null && (details = annotation.getDetails()) != null) {
            String value = (String)details.get((Object)key);
            return value == null ? defaultValue : value;
        }
        return defaultValue;
    }

    public static boolean getBooleanAnnotation(EModelElement element, String key, boolean defaultValue) {
        String annotation = AnnotationMappingProviderImpl.getAnnotation(element, key, defaultValue ? "true" : "false");
        if (annotation.equals("true")) {
            return true;
        }
        if (annotation.equals("false")) {
            return false;
        }
        throw new ImplementationError("the value of cdo." + key + " should be 'false' or 'true'");
    }

    public static int getIntAnnotation(EModelElement element, String key, int defaultValue) {
        String annotation = AnnotationMappingProviderImpl.getAnnotation(element, key, Integer.toString(defaultValue));
        return Integer.parseInt(annotation);
    }

    public static String columnName(EAttribute attribute) {
        String name = attribute.getName();
        return AnnotationMappingProviderImpl.sqlIdentifier(name);
    }

    public static String sqlIdentifier(String name) {
        StringBuffer result = new StringBuffer();
        List parsedName = StringHelper.parseName((String)name, (char)'_');
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(nameComponent);
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append('_');
        }
        return result.toString().toUpperCase();
    }

    public static String tableName(EClass eClass) {
        String name = eClass.getName();
        return AnnotationMappingProviderImpl.sqlIdentifier(name);
    }

    public static int getDefaultColumnType(EAttribute attribute, AttributeConverter attributeConverter) {
        int dataType = attributeConverter.getCDODataType(attribute.getEAttributeType());
        switch (dataType) {
            case -2: 
            case 2: {
                return 16;
            }
            case -1: 
            case 1: {
                return 1;
            }
            case -3: 
            case 3: {
                return -6;
            }
            case -4: 
            case 4: {
                return 5;
            }
            case -5: 
            case 5: {
                return 4;
            }
            case -6: 
            case 6: {
                return -5;
            }
            case -7: 
            case 7: {
                return 6;
            }
            case -8: 
            case 8: {
                return 8;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return -1;
            }
        }
        throw new UnknownDataTypeException("Can't handle type " + dataType);
    }
}

