/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.cdo.client.CDOPersistable;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.OptimisticControlException;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.CDOResourceFactoryImpl;
import org.eclipse.emf.cdo.client.impl.ResourceManagerImpl;
import org.eclipse.emf.cdo.client.protocol.ClientCDOProtocolImpl;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.core.Channel;

public class CDOResourceImpl
extends ResourceImpl
implements CDOResource {
    protected ResourceInfo resourceInfo;
    protected ResourceManager resourceManager;
    private static long nextTempOIDFragment;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(CDOResourceImpl.class);
    }

    public CDOResourceImpl(ResourceInfo resourceInfo, ResourceManager resourceManager) {
        super(URI.createURI((String)("cdo://" + resourceInfo.getRID())));
        this.resourceInfo = resourceInfo;
        this.resourceManager = resourceManager;
    }

    public ResourceInfo getInfo() {
        return this.resourceInfo;
    }

    public void setPath(String path) {
        this.resourceInfo.setPath(path);
    }

    public String getPath() {
        if (this.resourceInfo.getPath() == null && this.resourceManager.isRequestingObjects()) {
            Channel channel = this.resourceManager.getChannel();
            int rid = this.getRID();
            this.resourceInfo.setPath(ClientCDOProtocolImpl.requestResourceRID(channel, rid));
        }
        return this.resourceInfo.getPath();
    }

    public int getRID() {
        return this.resourceInfo.getRID();
    }

    public boolean isExisting() {
        return this.resourceInfo.isExisting();
    }

    public void setExisting(boolean existing) {
        this.resourceInfo.setExisting(existing);
    }

    public Set queryExtent(EClass context, boolean exactMatch) {
        return this.resourceManager.queryExtent(context, exactMatch, this);
    }

    public Set queryExtent(EClass context) {
        return this.resourceManager.queryExtent(context, this);
    }

    public EList queryCrossReferences(EObject object) {
        return this.resourceManager.queryCrossReferences(object, this);
    }

    public void load(Map options) {
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = (ResourceImpl.ContentsEList)super.getContents();
            if (this.isExisting() && this.resourceManager.isRequestingObjects()) {
                ClientCDOProtocolImpl.requestLoadResource(this.resourceManager.getChannel(), this.getRID(), this.resourceManager.getPackageManager());
            }
        }
        return this.contents;
    }

    public void save(Map options) {
        try {
            this.resourceManager.commit();
        }
        catch (OptimisticControlException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Error while committing", (Throwable)ex);
            throw ex;
        }
        catch (Throwable t) {
            logger.error((Object)"Error while committing", t);
            throw new RuntimeException(t);
        }
    }

    public synchronized EObject getEObjectByID(String id) {
        OIDEncoder oidEncoder = this.resourceManager.getPackageManager().getOidEncoder();
        long oidFragment = Long.parseLong(id);
        long oid = oidEncoder.getOID(this.getRID(), oidFragment);
        EObject object = this.resourceManager.getObject(oid);
        if (object != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Object " + oid + " found --> " + ResourceManagerImpl.getLabel(object)));
            }
        } else {
            object = this.resourceManager.getProxyObject(oid);
        }
        return object;
    }

    public void attached(EObject eObject) {
        this.attach(eObject);
        TreeIterator tree = eObject.eAllContents();
        while (tree.hasNext()) {
            EObject child = (EObject)tree.next();
            this.attach(child);
        }
    }

    private void attach(EObject eObject) {
        if (eObject instanceof CDOPersistable) {
            CDOPersistable persistable = (CDOPersistable)eObject;
            if (persistable.cdoGetOID() == 0L) {
                long oid = this.getNextTempOID();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attaching object " + eObject + " with oid " + oid));
                }
                ResourceManagerImpl.initPersistable(persistable, this, oid, -1);
            }
        } else {
            logger.warn((Object)("Attached object is not CDOPersistable: " + eObject));
        }
    }

    public void detached(EObject eObject) {
        this.detach(eObject);
        TreeIterator tree = eObject.eAllContents();
        while (tree.hasNext()) {
            EObject child = (EObject)tree.next();
            this.detach(child);
        }
    }

    private void detach(EObject eObject) {
        EList references = eObject.eClass().getEAllReferences();
        for (EReference reference : references) {
            if (reference.isContainment() || reference.isContainer()) continue;
            eObject.eUnset((EStructuralFeature)reference);
        }
        this.resourceManager.detachObject(eObject);
    }

    protected long getNextTempOID() {
        OIDEncoder oidEncoder = this.resourceManager.getPackageManager().getOidEncoder();
        return -oidEncoder.getOID(this.getRID(), ++nextTempOIDFragment);
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void preLoad() {
        TreeIterator it = EcoreUtil.getAllContents((Resource)this, (boolean)true);
        while (it.hasNext()) {
            CDOPersistable persistable = (CDOPersistable)it.next();
            persistable.cdoLoad();
        }
    }

    public String toString() {
        URI formatURI = CDOResourceFactoryImpl.formatURI(this.getPath());
        return formatURI.toString();
    }
}

