/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ocl.ui.viewer;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.search.ocl.engine.IOCLFactory;
import org.eclipse.emf.search.ocl.engine.ModelingLevel;
import org.eclipse.emf.search.ocl.ui.viewer.OCLPartitionScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.OCLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLDocument
extends Document {
    private EObject context;
    private IOCLFactory<Object> oclFactory;
    private ModelingLevel level;

    public OCLDocument() {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new OCLPartitionScanner(), new String[]{"__ocl_comment"});
        partitioner.connect((IDocument)this);
        this.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void setOCLContext(EObject ctx) {
        this.context = ctx;
    }

    public EObject getOCLContext() {
        return this.context;
    }

    public void setOCLFactory(IOCLFactory<Object> factory) {
        this.oclFactory = factory;
    }

    public IOCLFactory<Object> getOCLFactory() {
        return this.oclFactory;
    }

    public void setModelingLevel(ModelingLevel lvl) {
        this.level = lvl;
    }

    public ModelingLevel getModelingLevel() {
        return this.level;
    }

    List<Choice> getOCLChoices(int offset) {
        if (this.context == null) {
            return Collections.emptyList();
        }
        try {
            String text = this.get(0, offset);
            OCL ocl = this.oclFactory.createOCL();
            OCLHelper helper = ocl.createOCLHelper();
            return helper.getSyntaxHelp(this.level.setContext(helper, this.context, this.oclFactory), text);
        }
        catch (BadLocationException badLocationException) {
            return Collections.emptyList();
        }
    }
}

