/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.handlers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ui.handlers.IModelElementEditorSelectionHandler;
import org.eclipse.emf.search.ui.pages.ModelEditorOpenEnum;
import org.eclipse.emf.search.ui.services.OpenDiagramParticipantDescriptor;
import org.eclipse.emf.search.ui.services.OpenDiagramParticipantExtensionManager;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractModelElementEditorSelectionHandler
implements IModelElementEditorSelectionHandler {
    public IStatus handleModelSearchElementSelection(IEditorPart part, Object selection, ModelEditorOpenEnum mode) {
        switch (mode) {
            case TREE: {
                return this.handleOpenTreeEditorWithSelection(part, selection);
            }
            case DIAGRAM: {
                return this.handleOpenDiagramEditorWithSelection(selection);
            }
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleOpenDiagramEditorWithSelection(Object selection) {
        OpenDiagramParticipantDescriptor desc = OpenDiagramParticipantExtensionManager.getInstance().find(this.getNsURI());
        if (desc instanceof OpenDiagramParticipantDescriptor) {
            ArrayList<Object> selectionObjects = new ArrayList<Object>();
            selectionObjects.add(selection);
            desc.getOpenDiagramHandler().openDiagramEditor(this.getNsURI(), selectionObjects);
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public abstract IStatus handleOpenTreeEditorWithSelection(IEditorPart var1, Object var2);

    public abstract boolean isCompatibleModelElementEditorSelectionHandler(IEditorPart var1);

    protected abstract String getNsURI();
}

