/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.utils.ModelSearchImagesUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ActionContributionDescriptor {
    public static final String ACTION_CONTRIBUTION_EXT_ID = "id";
    public static final String ACTION_ID = "action";
    public static final String TARGET_MENU_ID = "targetMenuID";
    public static final String TARGET_META_MODEL_ID = "targetMetaModelID";
    public static final String ACTION_ICON_ID = "icon";
    public String ID;
    public Action action;
    public String targetMenuID;
    public String targetMetaModelID;
    public ImageDescriptor icon;
    private IConfigurationElement configElement;

    public ActionContributionDescriptor(IConfigurationElement element) throws CoreException {
        this.configElement = element;
        this.load();
    }

    private void load() throws CoreException {
        Bundle bundle = Platform.getBundle((String)this.configElement.getNamespaceIdentifier());
        this.ID = this.configElement.getAttribute(ACTION_CONTRIBUTION_EXT_ID);
        this.action = (Action)this.configElement.createExecutableExtension(ACTION_ID);
        this.action.setId(this.ID);
        this.targetMenuID = this.configElement.getAttribute(TARGET_MENU_ID);
        this.targetMetaModelID = this.configElement.getAttribute(TARGET_META_MODEL_ID);
        String imagePath = this.configElement.getAttribute(ACTION_ICON_ID);
        this.icon = imagePath != null && !imagePath.equals("") ? ModelSearchImagesUtil.getImageDescriptor((Bundle)bundle, (String)imagePath) : ModelSearchImagesUtil.MISSING_IMG_DESC;
        if (this.ID == null || this.ID.equals("") || this.action == null || this.targetMenuID == null || this.targetMenuID.equals("") || this.targetMetaModelID == null || this.targetMetaModelID.equals("")) {
            throw new CoreException((IStatus)new Status(4, this.configElement.getContributor().getName(), 0, String.valueOf(Messages.getString("ActionContributionDescriptor.invalidExtensionErrorMessage")) + this.ID, null));
        }
    }

    public String getID() {
        return this.ID;
    }

    public Action getAction() {
        return this.action;
    }

    public String getTargetMenuID() {
        return this.targetMenuID;
    }

    public String getTargetMetaModelID() {
        return this.targetMetaModelID;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }
}

