/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.services.MenuContributionDescriptor;

public class MenuContributionExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String MODEL_SEARCH_PAGE_MENU_CONTRIBUTION_EXT_POINT_ID = String.valueOf(bundleId) + ".modelSearchPageMenuContribution";
    private static MenuContributionExtensionManager manager;
    private SortedSet<MenuContributionDescriptor> menuContributions = new TreeSet<MenuContributionDescriptor>(new Comparator<MenuContributionDescriptor>(){

        @Override
        public int compare(MenuContributionDescriptor o1, MenuContributionDescriptor o2) {
            return o2.getID().compareTo(o1.getID());
        }
    });

    protected MenuContributionExtensionManager() {
        super(MODEL_SEARCH_PAGE_MENU_CONTRIBUTION_EXT_POINT_ID);
        this.readRegistry();
    }

    public static MenuContributionExtensionManager getInstance() {
        return manager == null ? (manager = new MenuContributionExtensionManager()) : manager;
    }

    public MenuContributionDescriptor find(String id) {
        for (MenuContributionDescriptor desc : this.menuContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return null;
    }

    public MenuContributionDescriptor[] getMenuContributions() {
        return this.menuContributions.toArray(new MenuContributionDescriptor[this.menuContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                this.menuContributions.add(new MenuContributionDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelExtensibleSearchQueryTabExtensionManager.addExtensionErrorMessage"), (Throwable)ce));
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            String id = confElt.getAttribute("id");
            MenuContributionDescriptor descriptor = this.find(id);
            this.menuContributions.remove(descriptor);
            ++n2;
        }
    }
}

