/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.socket.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.eclipse.net4j.socket.ActiveSocketConnector;
import org.eclipse.net4j.socket.impl.AbstractSocketConnector;
import org.eclipse.net4j.spring.ValidationException;

public class ActiveSocketConnectorImpl
extends AbstractSocketConnector
implements ActiveSocketConnector {
    public static final int DEFAULT_PORT = 2036;
    private String host;
    private int port = 2036;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.doSet("host", host);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.doSet("port", port);
    }

    public int getType() {
        return 0;
    }

    protected void prepareBasicChannel() throws InterruptedException {
        this.addChannel("control");
        long start = System.currentTimeMillis();
        while (!this.isAuthenticated()) {
            Thread.sleep(250L);
            if (System.currentTimeMillis() <= start + this.getAuthenticationTimeout()) continue;
            this.warn("Timeout while authenticating");
            break;
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("host");
    }

    protected void activate() throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        this.setSocketChannel(socketChannel);
        InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(this.host), this.port);
        socketChannel.connect(addr);
        super.activate();
    }

    protected void deactivate() throws Exception {
        if (this.getSocketChannel() != null) {
            this.getSocketChannel().close();
            this.setSocketChannel(null);
            if (this.isDebugEnabled()) {
                this.info("Disconnected");
            }
        }
        super.deactivate();
    }
}

