/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.common.utils.file;

import java.io.File;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.core.scope.ModelSearchScope;
import org.eclipse.emf.search.ecore.common.utils.file.EcoreModelSearchScopeFileSystemVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreModelSearchDirectoryScopeFactory {
    private static EcoreModelSearchDirectoryScopeFactory instance;

    public static EcoreModelSearchDirectoryScopeFactory getInstance() {
        return instance == null ? (instance = new EcoreModelSearchDirectoryScopeFactory()) : instance;
    }

    private IModelSearchScope<Object, Resource> collectModelSearchScopeParticipants(File[] nodes, EcoreModelSearchScopeFileSystemVisitor visitor) {
        File[] fileArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            File node = fileArray[n2];
            this.accept(node, visitor);
            ++n2;
        }
        return visitor.getModelSearchScope();
    }

    private void accept(File node, EcoreModelSearchScopeFileSystemVisitor visitor) {
        if (node instanceof File && node.exists() && node.canRead() && !node.isHidden()) {
            if (node.isDirectory()) {
                File[] fileArray = node.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File n3 = fileArray[n2];
                    this.accept(n3, visitor);
                    ++n2;
                }
            } else if (node.isFile()) {
                visitor.visit(node);
            }
        }
    }

    public IModelSearchScope<Object, Resource> createModelSearchFileSystemScope(String engineID) {
        return this.collectModelSearchScopeParticipants(File.listRoots(), this.getModelSearchFileSystemVisitor((IModelSearchScope<Object, Resource>)new ModelSearchScope("Global File System Scope")));
    }

    protected EcoreModelSearchScopeFileSystemVisitor getModelSearchFileSystemVisitor(IModelSearchScope<Object, Resource> scope) {
        return new EcoreModelSearchScopeFileSystemVisitor(scope);
    }

    public IModelSearchScope<Object, Resource> createModelSearchFileSystemDirectoryScope(File[] fsNodes) {
        IModelSearchScope<Object, Resource> scope = new IModelSearchScope<Object, Resource>("Directory Scope");
        scope = this.collectModelSearchScopeParticipants(fsNodes, this.getModelSearchFileSystemVisitor(scope));
        return scope;
    }
}

