/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.services;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.core.services.AbstractExtensionManager;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.emf.search.ui.services.ParticipantTabDescriptor;

public final class ModelSearchParticipantTabExtensionManager
extends AbstractExtensionManager {
    private static final String bundleId = Activator.getDefault().getBundle().getSymbolicName();
    public static final String EMF_UI_MODEL_SEARCH_PARTICIPANT_TABS_EXT_POINT_ID = String.valueOf(bundleId) + ".modelSearchParticipantTab";
    private static ModelSearchParticipantTabExtensionManager manager;
    private SortedSet<ParticipantTabDescriptor> participantContributions = new TreeSet<ParticipantTabDescriptor>(new Comparator<ParticipantTabDescriptor>(){

        @Override
        public int compare(ParticipantTabDescriptor o1, ParticipantTabDescriptor o2) {
            return o1.getID().compareTo(o2.getID());
        }
    });

    protected ModelSearchParticipantTabExtensionManager() {
        super(EMF_UI_MODEL_SEARCH_PARTICIPANT_TABS_EXT_POINT_ID);
        this.readRegistry();
    }

    public static ModelSearchParticipantTabExtensionManager getInstance() {
        return manager == null ? (manager = new ModelSearchParticipantTabExtensionManager()) : manager;
    }

    public ParticipantTabDescriptor find(String id) {
        for (ParticipantTabDescriptor desc : this.participantContributions) {
            if (!id.equals(desc.getID())) continue;
            return desc;
        }
        return this.participantContributions.first();
    }

    public ParticipantTabDescriptor[] getModelSearchParticipantDescriptors() {
        return this.participantContributions.toArray(new ParticipantTabDescriptor[this.participantContributions.size()]);
    }

    protected void addExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            try {
                this.participantContributions.add(new ParticipantTabDescriptor(confElt));
            }
            catch (CoreException ce) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, bundleId, 0, Messages.getString("ModelExtensibleSearchParticipantTabExtensionManager.1"), (Throwable)ce));
            }
            ++n2;
        }
    }

    protected void removeExtension(IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement confElt = iConfigurationElementArray[n2];
            String id = confElt.getAttribute("id");
            ParticipantTabDescriptor descriptor = this.find(id);
            this.participantContributions.remove(descriptor);
            ++n2;
        }
    }
}

