/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.core.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.net4j.core.AuthenticationManager;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.springframework.core.io.Resource;

public class PropertiesAuthenticationManagerImpl
extends ServiceImpl
implements AuthenticationManager {
    protected String fileName;
    protected transient Properties properties;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.doSet("fileName", fileName);
    }

    public char[] getPassword(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("userName == null");
        }
        String pw = this.properties.getProperty(userName);
        if (pw == null) {
            return null;
        }
        return pw.toCharArray();
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("fileName");
        try {
            Resource resource = this.getContainer().getResource(this.fileName);
            InputStream stream = resource.getInputStream();
            this.properties = new Properties();
            this.properties.load(stream);
        }
        catch (IOException ex) {
            this.error("Error while reading file " + this.fileName, ex);
            throw new ValidationException("Error while loading credentials", (Throwable)ex);
        }
    }

    protected void deactivate() throws Exception {
        this.fileName = null;
        super.deactivate();
    }
}

