/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.swt;

import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.adapter.AbstractAdapter;
import org.eclipse.net4j.examples.mvc.aspect.IEnablementViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IFocusViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMetaDataAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseButtonViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseMovementViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseTrackingViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.ISelectionViewAspect;
import org.eclipse.net4j.examples.mvc.swt.AbstractSelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public class ButtonViewAdapter
extends AbstractSelectionAdapter {
    private String[] items = new String[]{"false", "true"};
    private boolean released;

    public ButtonViewAdapter(Factory factory) {
        super((IAdapter.Factory<Control>)factory);
    }

    public Button getButtonControl() {
        return (Button)this.getTarget();
    }

    public void add(String string, int index) {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void add(String string) {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void deselect(int index) {
        this.checkIndexArgument(index);
        this.select(1 - index);
    }

    public void deselect(int start, int end) {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void deselect(int[] indices) {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void deselectAll() {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public String getItem(int index) {
        this.checkIndexArgument(index);
        return this.items[index];
    }

    public int getItemCount() {
        return this.items.length;
    }

    public int getItemHeight() {
        return this.getButtonControl().getSize().y;
    }

    public String[] getItems() {
        return this.items;
    }

    public String[] getSelection() {
        return new String[]{this.items[this.getSelectionIndex()]};
    }

    public int getSelectionCount() {
        return 1;
    }

    public int getSelectionIndex() {
        return this.getButtonControl().getSelection() ? 1 : 0;
    }

    public int[] getSelectionIndices() {
        return new int[]{this.getSelectionIndex()};
    }

    public int getFocusIndex() {
        if (!this.getButtonControl().isFocusControl()) {
            return -1;
        }
        return this.getSelectionIndex();
    }

    public int getTopIndex() {
        return 0;
    }

    public int getVisibleItemCount() {
        return 1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        if (string == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (start <= 0 && string.equals(this.items[0])) {
            return 0;
        }
        if (start <= 1 && string.equals(this.items[1])) {
            return 1;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        return index == this.getSelectionIndex();
    }

    public void remove(int index) {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void remove(int start, int end) {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void remove(int[] indices) {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void remove(String string) {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void removeAll() {
        throw new UnsupportedOperationException("Button does only support 2 items");
    }

    public void select(int index) {
        this.checkIndexArgument(index);
        this.getButtonControl().setEnabled(index != 0);
    }

    public void select(int start, int end) {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void select(int[] indices) {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void selectAll() {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void setItem(int index, String string) {
        this.checkIndexArgument(index);
        this.items[index] = string;
    }

    public void setItems(String[] items) {
        if (items == null) {
            throw new IllegalArgumentException("items == null");
        }
        if (items.length != 2) {
            throw new IllegalArgumentException("items.length != 2");
        }
        this.items = items;
    }

    public void setSelection(int index) {
        this.select(index);
    }

    public void setSelection(int start, int end) {
        this.select(start, end);
    }

    public void setSelection(int[] indices) {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void setSelection(String[] items) {
        throw new UnsupportedOperationException("Button does not support multiple selection");
    }

    public void setTopIndex(int index) {
    }

    public void setVisibleItemCount(int count) {
    }

    public void showSelection() {
    }

    public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
        block2: {
            boolean bl;
            try {
                if (!this.released) break block2;
                bl = super.onSelection(item, detail, x, y, width, height, stateMask, doit);
                this.released = !this.released;
            }
            catch (Throwable throwable) {
                this.released = !this.released;
                throw throwable;
            }
            return bl;
        }
        this.released = !this.released;
        return false;
    }

    protected void connectTarget(Class viewAspect) {
        super.connectTarget(viewAspect);
        if (viewAspect == ISelectionViewAspect.class) {
            this.getButtonControl().addSelectionListener((SelectionListener)this);
        }
    }

    protected void disconnectTarget(Class viewAspect) {
        if (!((Control)this.getTarget()).isDisposed() && viewAspect == ISelectionViewAspect.class) {
            this.getButtonControl().removeSelectionListener((SelectionListener)this);
        }
        super.disconnectTarget(viewAspect);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractAdapter.AbstractFactory<Control> {
        private static final Class[] ASPECTS = new Class[]{IMetaDataAspect.class, IEnablementViewAspect.class, IFocusViewAspect.class, IMouseButtonViewAspect.class, IMouseTrackingViewAspect.class, IMouseMovementViewAspect.class, ISelectionViewAspect.class};
        private static final Class[] ADAPTABLE_CLASSES = new Class[]{Button.class};

        public IAdapter<Control> createAdapter() {
            return new ButtonViewAdapter(this);
        }

        public Class[] getAspects() {
            return ASPECTS;
        }

        public Class[] getAdaptableClasses() {
            return ADAPTABLE_CLASSES;
        }
    }
}

