/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.socket.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.core.impl.AbstractAcceptor;
import org.eclipse.net4j.socket.SocketAcceptor;
import org.eclipse.net4j.socket.SocketConnector;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.thread.Worker;

public class SocketAcceptorImpl
extends AbstractAcceptor
implements SocketAcceptor {
    public static final String DEFAULT_ADDR = "0.0.0.0";
    public static final String DEFAULT_SLAVE_NAME = "slave";
    public static final int DEFAULT_PORT = 2036;
    private String listenAddr = "0.0.0.0";
    private String slaveName = "slave";
    private int listenPort = 2036;
    private transient Listener listener;
    private transient ServerSocketChannel serverChannel;

    public String getListenAddr() {
        return this.listenAddr;
    }

    public void setListenAddr(String listenAddr) {
        this.doSet("listenAddr", listenAddr);
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.doSet("listenPort", listenPort);
    }

    public String getSlaveName() {
        return this.slaveName;
    }

    public void setSlaveName(String slaveName) {
        this.doSet("slaveName", slaveName);
    }

    protected Connector createSlave(SocketChannel socketChannel) {
        SocketConnector slave = (SocketConnector)this.getContainer().getBean(this.slaveName);
        slave.setSocketChannel(socketChannel);
        return slave;
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("listenAddr");
    }

    protected void activate() throws Exception {
        super.activate();
        this.serverChannel = ServerSocketChannel.open();
        InetAddress iAddr = InetAddress.getByName(this.listenAddr);
        InetSocketAddress addr = new InetSocketAddress(iAddr, this.listenPort);
        this.serverChannel.socket().bind(addr);
        this.listener = new Listener();
        this.listener.setDaemon(true);
        this.listener.startup();
    }

    protected void deactivate() throws Exception {
        super.deactivate();
        if (this.listener != null) {
            this.listener.shutdown(200L);
            this.listener = null;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel = null;
        }
        this.listenAddr = null;
        this.slaveName = null;
    }

    private class Listener
    extends Worker {
        public Listener() {
            super(String.valueOf(SocketAcceptorImpl.this.getFullBeanName()) + ".Listener");
        }

        public long doWorkStep(int progress) {
            SocketChannel socketChannel = null;
            try {
                socketChannel = SocketAcceptorImpl.this.serverChannel.accept();
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                return -1L;
            }
            catch (Exception ex) {
                if (SocketAcceptorImpl.this.isActive()) {
                    SocketAcceptorImpl.this.error("Error while accepting a socket channel", ex);
                }
                return -1L;
            }
            Connector slave = SocketAcceptorImpl.this.createSlave(socketChannel);
            SocketAcceptorImpl.this.accept(slave);
            return 0L;
        }
    }
}

