/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.edit.policies;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenDiagramEditPolicy
extends OpenEditPolicy {
    protected Command getOpenCommand(Request request) {
        EditPart targetEditPart = this.getTargetEditPart(request);
        if (!(targetEditPart.getModel() instanceof View)) {
            return null;
        }
        EAnnotation ann = ((View)targetEditPart.getModel()).getEAnnotation("uri://eclipse.org/gmf/openDiagramPolicy");
        if (ann == null) {
            return null;
        }
        return new ICommandProxy((ICommand)new OpenDiagramCommand(ann));
    }

    private static class OpenDiagramCommand
    extends AbstractTransactionalCommand {
        private final EAnnotation diagramFacet;

        OpenDiagramCommand(EAnnotation annotation) {
            super(TransactionUtil.getEditingDomain((EObject)annotation), "Open diagram", null);
            this.diagramFacet = annotation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                Diagram diagram = this.getDiagramToOpen();
                if (diagram == null) {
                    diagram = this.intializeNewDiagram();
                }
                DiagramEditorInput editorInput = new DiagramEditorInput(diagram);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)editorInput, this.getEditorID());
                return CommandResult.newOKCommandResult();
            }
            catch (Exception ex) {
                throw new ExecutionException("Can't open diagram", (Throwable)ex);
            }
        }

        protected Diagram getDiagramToOpen() {
            for (Object next : this.diagramFacet.getReferences()) {
                if (!(next instanceof Diagram)) continue;
                return (Diagram)next;
            }
            return null;
        }

        protected Diagram intializeNewDiagram() throws ExecutionException {
            Diagram d = ViewService.createDiagram((EObject)this.getDiagramDomainElement(), (String)this.getDiagramKind(), (PreferencesHint)this.getPreferencesHint());
            if (d == null) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind");
            }
            this.diagramFacet.getReferences().add((Object)d);
            assert (this.diagramFacet.eResource() != null);
            this.diagramFacet.eResource().getContents().add((Object)d);
            try {
                Iterator it = this.diagramFacet.eResource().getResourceSet().getResources().iterator();
                while (it.hasNext()) {
                    ((Resource)it.next()).save(Collections.EMPTY_MAP);
                }
            }
            catch (IOException ex) {
                throw new ExecutionException("Can't create diagram of '" + this.getDiagramKind() + "' kind", (Throwable)ex);
            }
            return d;
        }

        protected EObject getDiagramDomainElement() {
            return ((View)this.diagramFacet.getEModelElement()).getElement();
        }

        protected PreferencesHint getPreferencesHint() {
            return EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
        }

        protected String getDiagramKind() {
            return "Ecore";
        }

        protected String getEditorID() {
            return "org.eclipse.gmf.ecore.part.EcoreDiagramEditorID";
        }
    }
}

