/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.figures;

import java.util.Hashtable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.TransparentBorder;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;

public class NodeFigure
extends Figure
implements HandleBounds,
IAnchorableFigure {
    private Hashtable connectionAnchors;
    public static final String szAnchor = "";

    public Rectangle getHandleBounds() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.getBorder() instanceof TransparentBorder) {
            insets = ((TransparentBorder)this.getBorder()).getTransparentInsets((IFigure)this);
        }
        return new Rectangle(this.getBounds().x + insets.left, this.getBounds().y + insets.top, this.getBounds().width - (insets.right + insets.left), this.getBounds().height - (insets.bottom + insets.top));
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        ConnectionAnchor connectAnchor = (ConnectionAnchor)this.getConnectionAnchors().get(terminal);
        if (connectAnchor == null) {
            if (terminal.equals(szAnchor)) {
                connectAnchor = this.createDefaultAnchor();
                this.getConnectionAnchors().put(terminal, connectAnchor);
            } else {
                connectAnchor = this.createAnchor(SlidableAnchor.parseTerminalString((String)terminal));
            }
        }
        return connectAnchor;
    }

    public String getConnectionAnchorTerminal(ConnectionAnchor c) {
        if (c instanceof SlidableAnchor) {
            return ((SlidableAnchor)c).getTerminal();
        }
        if (this.getConnectionAnchors().containsValue(c)) {
            for (String key : this.getConnectionAnchors().keySet()) {
                if (!this.getConnectionAnchors().get(key).equals(c)) continue;
                return key;
            }
        }
        this.getConnectionAnchor(szAnchor);
        return szAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        return this.createConnectionAnchor(p);
    }

    protected ConnectionAnchor createConnectionAnchor(Point p) {
        if (p == null) {
            return this.getConnectionAnchor(szAnchor);
        }
        Point temp = p.getCopy();
        this.translateToRelative((Translatable)temp);
        PrecisionPoint pt = BaseSlidableAnchor.getAnchorRelativeLocation((Point)temp, (Rectangle)this.getBounds());
        if (this.isDefaultAnchorArea(pt)) {
            return this.getConnectionAnchor(szAnchor);
        }
        return this.createAnchor(pt);
    }

    protected boolean isDefaultAnchorArea(PrecisionPoint p) {
        return p.preciseX >= this.getSlidableAnchorArea() / 2.0 && p.preciseX <= 1.0 - this.getSlidableAnchorArea() / 2.0 && p.preciseY >= this.getSlidableAnchorArea() / 2.0 && p.preciseY <= 1.0 - this.getSlidableAnchorArea() / 2.0;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque() && this.getBorder() != null) {
            Rectangle tempRect = new Rectangle(this.getBounds());
            tempRect.crop(this.getBorder().getInsets((IFigure)this));
            graphics.fillRectangle(tempRect);
            return;
        }
        super.paintFigure(graphics);
    }

    protected Hashtable getConnectionAnchors() {
        if (this.connectionAnchors == null) {
            this.connectionAnchors = new Hashtable(1);
        }
        return this.connectionAnchors;
    }

    protected double getSlidableAnchorArea() {
        return 0.5;
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new SlidableAnchor((IFigure)this);
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new SlidableAnchor((IFigure)this, p);
    }

    public static String getDefaultAnchorID() {
        return szAnchor;
    }
}

