/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Extension
extends SyntaxElement {
    private final Identifier name;
    private final List formalParameters;
    protected ExtensionFile file;
    protected final boolean cached;
    private final boolean isPrivate;
    protected final Identifier returnType;
    private List<EClassifier> resolvedParameterTypes = null;
    private final Map<List<Object>, Object> cache = new HashMap<List<Object>, Object>();

    public Extension(int start, int end, int line, Identifier name, Identifier returnType, List formalParameters, boolean cached, boolean isPrivate) {
        super(start, end, line);
        this.name = name;
        this.formalParameters = formalParameters;
        this.returnType = returnType;
        this.cached = cached;
        this.isPrivate = isPrivate;
    }

    public List getFormalParameters() {
        return this.formalParameters;
    }

    public String getName() {
        return this.name.getValue();
    }

    public final EClassifier getReturnType(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithResource(this.getExtensionFile());
        return this.internalGetReturnType(parameters, ctx, issues);
    }

    protected abstract EClassifier internalGetReturnType(EClassifier[] var1, ExecutionContext var2, Set<AnalysationIssue> var3);

    public final void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier pt;
        List params = this.getFormalParameters();
        HashSet<String> usedNames = new HashSet<String>();
        for (DeclaredParameter p : params) {
            EClassifier pt2 = ctx.getTypeForName(p.getType().getValue());
            if (pt2 == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Type not found: " + p.getType().getValue(), p.getType()));
            }
            if (!usedNames.add(p.getName().getValue())) {
                issues.add(new AnalysationIssue(AnalysationIssue.Type.SYNTAX_ERROR, "Duplicate parameter name: " + p.getName().getValue(), p.getName()));
            }
            ctx = ctx.cloneWithVariable(new Variable(p.getName().getValue(), pt2));
        }
        if (this.returnType != null && (pt = ctx.getTypeForName(this.returnType.getValue())) == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, "Type not found: " + this.returnType.getValue(), this.returnType));
        }
        this.analyzeInternal(ctx, issues);
    }

    protected abstract void analyzeInternal(ExecutionContext var1, Set<AnalysationIssue> var2);

    public Object evaluate(Object[] parameters, ExecutionContext ctx) {
        List<Object> l;
        if (this.cached && this.cache.containsKey(l = Arrays.asList(parameters))) {
            return this.cache.get(l);
        }
        if (this.getExtensionFile() == null) {
            throw new IllegalStateException("No containing file!");
        }
        ctx = ctx.cloneWithResource(this.getExtensionFile());
        Object result = this.evaluateInternal(parameters, ctx);
        if (this.cached) {
            this.cache.put(Arrays.asList(parameters), result);
        }
        return result;
    }

    public final void setExtensionFile(ExtensionFile f) {
        this.file = f;
    }

    public ExtensionFile getExtensionFile() {
        return this.file;
    }

    protected abstract Object evaluateInternal(Object[] var1, ExecutionContext var2);

    public List<String> getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            names.add(((DeclaredParameter)iter.next()).getName().getValue());
        }
        return names;
    }

    public void init(ExecutionContext ctx) {
        if (this.resolvedParameterTypes == null) {
            try {
                this.resolvedParameterTypes = new ArrayList<EClassifier>();
                Iterator iter = this.getFormalParameters().iterator();
                while (iter.hasNext()) {
                    String name = ((DeclaredParameter)iter.next()).getType().getValue();
                    EClassifier t = ctx.getTypeForName(name);
                    if (t == null) {
                        throw new EvaluationException("Couldn't resolve type for '" + name + "'. Did you forget to configure the corresponding metamodel?", (SyntaxElement)this);
                    }
                    this.resolvedParameterTypes.add(t);
                }
                this.resolvedParameterTypes = Collections.unmodifiableList(this.resolvedParameterTypes);
            }
            catch (RuntimeException e) {
                this.resolvedParameterTypes = null;
                throw e;
            }
        }
    }

    public List<EClassifier> getParameterTypes() {
        return this.resolvedParameterTypes;
    }

    public Identifier getReturnTypeIdentifier() {
        return this.returnType;
    }

    public String toString() {
        return String.valueOf(this.returnType != null ? String.valueOf(this.returnType.getValue()) + " " : "") + this.getName() + "(" + this.paramsToString() + ")";
    }

    private String paramsToString() {
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            DeclaredParameter element = (DeclaredParameter)iter.next();
            buff.append(element.getType() + " " + element.getName());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }
}

