/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.presentation.GMFGraphModelWizard;
import org.eclipse.gmf.internal.bridge.resolver.StructureResolver;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.Messages;
import org.eclipse.gmf.internal.bridge.wizards.WizardOperationMode;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DefinitionPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSelectionPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSourceImpl;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.GraphDefBuilder;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.StructureBuilder;
import org.eclipse.gmf.internal.common.URIUtil;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ResourceLocationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;

public class GMFGraphSimpleModelWizard
extends GMFGraphModelWizard {
    protected ModelSelectionPage graphicalModelSelectionPage;
    protected DefinitionPage graphicalDefinitionPage;
    protected WizardOperationMode mode = new WizardOperationMode("gmfgraph", "create");

    public void setMode(String mode) {
        this.mode.setMode(mode);
    }

    protected boolean isInReconcileMode() {
        return this.graphicalModelSelectionPage != null && this.graphicalModelSelectionPage.getResource() != null;
    }

    public boolean performFinish() {
        if (this.isInReconcileMode()) {
            this.reconcileModel();
            try {
                WizardUtil.saveModel(this.getContainer(), this.graphicalModelSelectionPage.getResource());
            }
            catch (Exception exception) {
                Plugin.log(exception);
                return false;
            }
            IFile modelFile = this.getModelFile();
            if (modelFile != null) {
                WizardUtil.openEditor(modelFile);
            }
            return true;
        }
        return super.performFinish();
    }

    protected EObject createInitialModel() {
        GraphDefBuilder builder = new GraphDefBuilder(null);
        return builder.process(this.graphicalDefinitionPage.getModel());
    }

    protected void reconcileModel() {
        Canvas existingCanvas = null;
        for (EObject element : this.graphicalModelSelectionPage.getResource().getContents()) {
            if (!(element instanceof Canvas)) continue;
            existingCanvas = (Canvas)element;
            break;
        }
        GraphDefBuilder builder = new GraphDefBuilder(existingCanvas);
        Canvas canvas = builder.process(this.graphicalDefinitionPage.getModel());
        if (canvas != null && existingCanvas != canvas) {
            this.graphicalModelSelectionPage.getResource().getContents().add((Object)canvas);
        }
    }

    public void addPages() {
        ResourceLocationProvider rloc = new ResourceLocationProvider((ISelection)this.selection);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (this.mode.detectReconcile(rloc)) {
            this.graphicalModelSelectionPage = new ModelSelectionPage("GraphicalModelSelectionPage", rloc, (ResourceSet)resourceSet, "gmfgraph");
            this.graphicalModelSelectionPage.setPageComplete(false);
            this.graphicalModelSelectionPage.setModelRequired(true);
            this.graphicalModelSelectionPage.setTitle(Messages.SimpleModelWizardGraphModelSelectionPageTitle);
            this.graphicalModelSelectionPage.setDescription(Messages.SimpleModelWizardGraphModelSelectionPageDesc);
            this.addPage((IWizardPage)this.graphicalModelSelectionPage);
        } else {
            Object selected;
            super.addPages();
            if (this.selection != null && !this.selection.isEmpty() && (selected = this.selection.getFirstElement()) instanceof IFile) {
                this.newFileCreationPage.setFileName(WizardUtil.getDefaultFileName((IFile)selected, "gmfgraph"));
            }
        }
        DomainModelSelectionPage domainModelSelectionPage = new DomainModelSelectionPage("DomainModelSelectionPage", rloc, (ResourceSet)resourceSet);
        domainModelSelectionPage.setTitle(Messages.SimpleModelWizardDomainModelSelectionPageTitle);
        domainModelSelectionPage.setDescription(Messages.SimpleModelWizardDomainModelSelectionPageDesc);
        this.addPage((IWizardPage)domainModelSelectionPage);
        this.graphicalDefinitionPage = new DefinitionPage("GraphicalDefinitionPage", new StructureBuilder(new StructureResolver(), true), domainModelSelectionPage){

            protected DomainModelSourceImpl createDomainModelSource(EPackage contents, EClass diagramElement) {
                if (GMFGraphSimpleModelWizard.this.isInReconcileMode()) {
                    return new DomainModelSourceImpl(contents, diagramElement){

                        public boolean isDisabled(EObject domainElement) {
                            return GraphDefBuilder.getDiagramElement((Iterator<EObject>)(this).GMFGraphSimpleModelWizard.this.graphicalModelSelectionPage.getResource().getAllContents(), domainElement) != null;
                        }
                    };
                }
                return super.createDomainModelSource(contents, diagramElement);
            }
        };
        this.graphicalDefinitionPage.setTitle(Messages.SimpleModelWizardGraphDefinitionPageTitle);
        this.graphicalDefinitionPage.setDescription(Messages.SimpleModelWizardGraphDefinitionPageDesc);
        this.addPage((IWizardPage)this.graphicalDefinitionPage);
    }

    public IFile getModelFile() {
        if (this.isInReconcileMode()) {
            return URIUtil.getFile((URI)this.graphicalModelSelectionPage.getResource().getURI());
        }
        return super.getModelFile();
    }
}

